/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.MessageUsefulness;
import software.amazon.awssdk.services.qbusiness.model.MessageUsefulnessReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageUsefulnessFeedback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageUsefulnessFeedback> {
    private static final SdkField<String> USEFULNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usefulness").getter(MessageUsefulnessFeedback.getter(MessageUsefulnessFeedback::usefulnessAsString)).setter(MessageUsefulnessFeedback.setter(Builder::usefulness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usefulness").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(MessageUsefulnessFeedback.getter(MessageUsefulnessFeedback::reasonAsString)).setter(MessageUsefulnessFeedback.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(MessageUsefulnessFeedback.getter(MessageUsefulnessFeedback::comment)).setter(MessageUsefulnessFeedback.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<Instant> SUBMITTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("submittedAt").getter(MessageUsefulnessFeedback.getter(MessageUsefulnessFeedback::submittedAt)).setter(MessageUsefulnessFeedback.setter(Builder::submittedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USEFULNESS_FIELD, REASON_FIELD, COMMENT_FIELD, SUBMITTED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("usefulness", USEFULNESS_FIELD);
            this.put("reason", REASON_FIELD);
            this.put("comment", COMMENT_FIELD);
            this.put("submittedAt", SUBMITTED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String usefulness;
    private final String reason;
    private final String comment;
    private final Instant submittedAt;

    private MessageUsefulnessFeedback(BuilderImpl builder) {
        this.usefulness = builder.usefulness;
        this.reason = builder.reason;
        this.comment = builder.comment;
        this.submittedAt = builder.submittedAt;
    }

    public final MessageUsefulness usefulness() {
        return MessageUsefulness.fromValue(this.usefulness);
    }

    public final String usefulnessAsString() {
        return this.usefulness;
    }

    public final MessageUsefulnessReason reason() {
        return MessageUsefulnessReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant submittedAt() {
        return this.submittedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usefulnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageUsefulnessFeedback)) {
            return false;
        }
        MessageUsefulnessFeedback other = (MessageUsefulnessFeedback)obj;
        return Objects.equals(this.usefulnessAsString(), other.usefulnessAsString()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.submittedAt(), other.submittedAt());
    }

    public final String toString() {
        return ToString.builder((String)"MessageUsefulnessFeedback").add("Usefulness", (Object)this.usefulnessAsString()).add("Reason", (Object)this.reasonAsString()).add("Comment", (Object)this.comment()).add("SubmittedAt", (Object)this.submittedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usefulness": {
                return Optional.ofNullable(clazz.cast(this.usefulnessAsString()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "submittedAt": {
                return Optional.ofNullable(clazz.cast(this.submittedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageUsefulnessFeedback, T> g) {
        return obj -> g.apply((MessageUsefulnessFeedback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usefulness;
        private String reason;
        private String comment;
        private Instant submittedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageUsefulnessFeedback model) {
            this.usefulness(model.usefulness);
            this.reason(model.reason);
            this.comment(model.comment);
            this.submittedAt(model.submittedAt);
        }

        public final String getUsefulness() {
            return this.usefulness;
        }

        public final void setUsefulness(String usefulness) {
            this.usefulness = usefulness;
        }

        @Override
        public final Builder usefulness(String usefulness) {
            this.usefulness = usefulness;
            return this;
        }

        @Override
        public final Builder usefulness(MessageUsefulness usefulness) {
            this.usefulness(usefulness == null ? null : usefulness.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(MessageUsefulnessReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getSubmittedAt() {
            return this.submittedAt;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public MessageUsefulnessFeedback build() {
            return new MessageUsefulnessFeedback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageUsefulnessFeedback> {
        public Builder usefulness(String var1);

        public Builder usefulness(MessageUsefulness var1);

        public Builder reason(String var1);

        public Builder reason(MessageUsefulnessReason var1);

        public Builder comment(String var1);

        public Builder submittedAt(Instant var1);
    }
}

