/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.BasicAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.IdcAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.NoAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.OAuth2ClientCredentialConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginAuthConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginAuthConfiguration> {
    private static final SdkField<BasicAuthConfiguration> BASIC_AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("basicAuthConfiguration").getter(PluginAuthConfiguration.getter(PluginAuthConfiguration::basicAuthConfiguration)).setter(PluginAuthConfiguration.setter(Builder::basicAuthConfiguration)).constructor(BasicAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthConfiguration").build()}).build();
    private static final SdkField<OAuth2ClientCredentialConfiguration> O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2ClientCredentialConfiguration").getter(PluginAuthConfiguration.getter(PluginAuthConfiguration::oAuth2ClientCredentialConfiguration)).setter(PluginAuthConfiguration.setter(Builder::oAuth2ClientCredentialConfiguration)).constructor(OAuth2ClientCredentialConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2ClientCredentialConfiguration").build()}).build();
    private static final SdkField<NoAuthConfiguration> NO_AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("noAuthConfiguration").getter(PluginAuthConfiguration.getter(PluginAuthConfiguration::noAuthConfiguration)).setter(PluginAuthConfiguration.setter(Builder::noAuthConfiguration)).constructor(NoAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noAuthConfiguration").build()}).build();
    private static final SdkField<IdcAuthConfiguration> IDC_AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("idcAuthConfiguration").getter(PluginAuthConfiguration.getter(PluginAuthConfiguration::idcAuthConfiguration)).setter(PluginAuthConfiguration.setter(Builder::idcAuthConfiguration)).constructor(IdcAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcAuthConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_CONFIGURATION_FIELD, O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION_FIELD, NO_AUTH_CONFIGURATION_FIELD, IDC_AUTH_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("basicAuthConfiguration", BASIC_AUTH_CONFIGURATION_FIELD);
            this.put("oAuth2ClientCredentialConfiguration", O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION_FIELD);
            this.put("noAuthConfiguration", NO_AUTH_CONFIGURATION_FIELD);
            this.put("idcAuthConfiguration", IDC_AUTH_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BasicAuthConfiguration basicAuthConfiguration;
    private final OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration;
    private final NoAuthConfiguration noAuthConfiguration;
    private final IdcAuthConfiguration idcAuthConfiguration;
    private final Type type;

    private PluginAuthConfiguration(BuilderImpl builder) {
        this.basicAuthConfiguration = builder.basicAuthConfiguration;
        this.oAuth2ClientCredentialConfiguration = builder.oAuth2ClientCredentialConfiguration;
        this.noAuthConfiguration = builder.noAuthConfiguration;
        this.idcAuthConfiguration = builder.idcAuthConfiguration;
        this.type = builder.type;
    }

    public final BasicAuthConfiguration basicAuthConfiguration() {
        return this.basicAuthConfiguration;
    }

    public final OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration() {
        return this.oAuth2ClientCredentialConfiguration;
    }

    public final NoAuthConfiguration noAuthConfiguration() {
        return this.noAuthConfiguration;
    }

    public final IdcAuthConfiguration idcAuthConfiguration() {
        return this.idcAuthConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2ClientCredentialConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.noAuthConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcAuthConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginAuthConfiguration)) {
            return false;
        }
        PluginAuthConfiguration other = (PluginAuthConfiguration)obj;
        return Objects.equals(this.basicAuthConfiguration(), other.basicAuthConfiguration()) && Objects.equals(this.oAuth2ClientCredentialConfiguration(), other.oAuth2ClientCredentialConfiguration()) && Objects.equals(this.noAuthConfiguration(), other.noAuthConfiguration()) && Objects.equals(this.idcAuthConfiguration(), other.idcAuthConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PluginAuthConfiguration").add("BasicAuthConfiguration", (Object)this.basicAuthConfiguration()).add("OAuth2ClientCredentialConfiguration", (Object)this.oAuth2ClientCredentialConfiguration()).add("NoAuthConfiguration", (Object)this.noAuthConfiguration()).add("IdcAuthConfiguration", (Object)this.idcAuthConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "basicAuthConfiguration": {
                return Optional.ofNullable(clazz.cast(this.basicAuthConfiguration()));
            }
            case "oAuth2ClientCredentialConfiguration": {
                return Optional.ofNullable(clazz.cast(this.oAuth2ClientCredentialConfiguration()));
            }
            case "noAuthConfiguration": {
                return Optional.ofNullable(clazz.cast(this.noAuthConfiguration()));
            }
            case "idcAuthConfiguration": {
                return Optional.ofNullable(clazz.cast(this.idcAuthConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static PluginAuthConfiguration fromBasicAuthConfiguration(BasicAuthConfiguration basicAuthConfiguration) {
        return (PluginAuthConfiguration)PluginAuthConfiguration.builder().basicAuthConfiguration(basicAuthConfiguration).build();
    }

    public static PluginAuthConfiguration fromBasicAuthConfiguration(Consumer<BasicAuthConfiguration.Builder> basicAuthConfiguration) {
        BasicAuthConfiguration.Builder builder = BasicAuthConfiguration.builder();
        basicAuthConfiguration.accept(builder);
        return PluginAuthConfiguration.fromBasicAuthConfiguration((BasicAuthConfiguration)builder.build());
    }

    public static PluginAuthConfiguration fromOAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration) {
        return (PluginAuthConfiguration)PluginAuthConfiguration.builder().oAuth2ClientCredentialConfiguration(oAuth2ClientCredentialConfiguration).build();
    }

    public static PluginAuthConfiguration fromOAuth2ClientCredentialConfiguration(Consumer<OAuth2ClientCredentialConfiguration.Builder> oAuth2ClientCredentialConfiguration) {
        OAuth2ClientCredentialConfiguration.Builder builder = OAuth2ClientCredentialConfiguration.builder();
        oAuth2ClientCredentialConfiguration.accept(builder);
        return PluginAuthConfiguration.fromOAuth2ClientCredentialConfiguration((OAuth2ClientCredentialConfiguration)builder.build());
    }

    public static PluginAuthConfiguration fromNoAuthConfiguration(NoAuthConfiguration noAuthConfiguration) {
        return (PluginAuthConfiguration)PluginAuthConfiguration.builder().noAuthConfiguration(noAuthConfiguration).build();
    }

    public static PluginAuthConfiguration fromNoAuthConfiguration(Consumer<NoAuthConfiguration.Builder> noAuthConfiguration) {
        NoAuthConfiguration.Builder builder = NoAuthConfiguration.builder();
        noAuthConfiguration.accept(builder);
        return PluginAuthConfiguration.fromNoAuthConfiguration((NoAuthConfiguration)builder.build());
    }

    public static PluginAuthConfiguration fromIdcAuthConfiguration(IdcAuthConfiguration idcAuthConfiguration) {
        return (PluginAuthConfiguration)PluginAuthConfiguration.builder().idcAuthConfiguration(idcAuthConfiguration).build();
    }

    public static PluginAuthConfiguration fromIdcAuthConfiguration(Consumer<IdcAuthConfiguration.Builder> idcAuthConfiguration) {
        IdcAuthConfiguration.Builder builder = IdcAuthConfiguration.builder();
        idcAuthConfiguration.accept(builder);
        return PluginAuthConfiguration.fromIdcAuthConfiguration((IdcAuthConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PluginAuthConfiguration, T> g) {
        return obj -> g.apply((PluginAuthConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BASIC_AUTH_CONFIGURATION,
        O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION,
        NO_AUTH_CONFIGURATION,
        IDC_AUTH_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private BasicAuthConfiguration basicAuthConfiguration;
        private OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration;
        private NoAuthConfiguration noAuthConfiguration;
        private IdcAuthConfiguration idcAuthConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PluginAuthConfiguration model) {
            this.basicAuthConfiguration(model.basicAuthConfiguration);
            this.oAuth2ClientCredentialConfiguration(model.oAuth2ClientCredentialConfiguration);
            this.noAuthConfiguration(model.noAuthConfiguration);
            this.idcAuthConfiguration(model.idcAuthConfiguration);
        }

        public final BasicAuthConfiguration.Builder getBasicAuthConfiguration() {
            return this.basicAuthConfiguration != null ? this.basicAuthConfiguration.toBuilder() : null;
        }

        public final void setBasicAuthConfiguration(BasicAuthConfiguration.BuilderImpl basicAuthConfiguration) {
            BasicAuthConfiguration oldValue = this.basicAuthConfiguration;
            this.basicAuthConfiguration = basicAuthConfiguration != null ? basicAuthConfiguration.build() : null;
            this.handleUnionValueChange(Type.BASIC_AUTH_CONFIGURATION, oldValue, this.basicAuthConfiguration);
        }

        @Override
        public final Builder basicAuthConfiguration(BasicAuthConfiguration basicAuthConfiguration) {
            BasicAuthConfiguration oldValue = this.basicAuthConfiguration;
            this.basicAuthConfiguration = basicAuthConfiguration;
            this.handleUnionValueChange(Type.BASIC_AUTH_CONFIGURATION, oldValue, this.basicAuthConfiguration);
            return this;
        }

        public final OAuth2ClientCredentialConfiguration.Builder getOAuth2ClientCredentialConfiguration() {
            return this.oAuth2ClientCredentialConfiguration != null ? this.oAuth2ClientCredentialConfiguration.toBuilder() : null;
        }

        public final void setOAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration.BuilderImpl oAuth2ClientCredentialConfiguration) {
            OAuth2ClientCredentialConfiguration oldValue = this.oAuth2ClientCredentialConfiguration;
            this.oAuth2ClientCredentialConfiguration = oAuth2ClientCredentialConfiguration != null ? oAuth2ClientCredentialConfiguration.build() : null;
            this.handleUnionValueChange(Type.O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION, oldValue, this.oAuth2ClientCredentialConfiguration);
        }

        @Override
        public final Builder oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration oAuth2ClientCredentialConfiguration) {
            OAuth2ClientCredentialConfiguration oldValue = this.oAuth2ClientCredentialConfiguration;
            this.oAuth2ClientCredentialConfiguration = oAuth2ClientCredentialConfiguration;
            this.handleUnionValueChange(Type.O_AUTH2_CLIENT_CREDENTIAL_CONFIGURATION, oldValue, this.oAuth2ClientCredentialConfiguration);
            return this;
        }

        public final NoAuthConfiguration.Builder getNoAuthConfiguration() {
            return this.noAuthConfiguration != null ? this.noAuthConfiguration.toBuilder() : null;
        }

        public final void setNoAuthConfiguration(NoAuthConfiguration.BuilderImpl noAuthConfiguration) {
            NoAuthConfiguration oldValue = this.noAuthConfiguration;
            this.noAuthConfiguration = noAuthConfiguration != null ? noAuthConfiguration.build() : null;
            this.handleUnionValueChange(Type.NO_AUTH_CONFIGURATION, oldValue, this.noAuthConfiguration);
        }

        @Override
        public final Builder noAuthConfiguration(NoAuthConfiguration noAuthConfiguration) {
            NoAuthConfiguration oldValue = this.noAuthConfiguration;
            this.noAuthConfiguration = noAuthConfiguration;
            this.handleUnionValueChange(Type.NO_AUTH_CONFIGURATION, oldValue, this.noAuthConfiguration);
            return this;
        }

        public final IdcAuthConfiguration.Builder getIdcAuthConfiguration() {
            return this.idcAuthConfiguration != null ? this.idcAuthConfiguration.toBuilder() : null;
        }

        public final void setIdcAuthConfiguration(IdcAuthConfiguration.BuilderImpl idcAuthConfiguration) {
            IdcAuthConfiguration oldValue = this.idcAuthConfiguration;
            this.idcAuthConfiguration = idcAuthConfiguration != null ? idcAuthConfiguration.build() : null;
            this.handleUnionValueChange(Type.IDC_AUTH_CONFIGURATION, oldValue, this.idcAuthConfiguration);
        }

        @Override
        public final Builder idcAuthConfiguration(IdcAuthConfiguration idcAuthConfiguration) {
            IdcAuthConfiguration oldValue = this.idcAuthConfiguration;
            this.idcAuthConfiguration = idcAuthConfiguration;
            this.handleUnionValueChange(Type.IDC_AUTH_CONFIGURATION, oldValue, this.idcAuthConfiguration);
            return this;
        }

        public PluginAuthConfiguration build() {
            return new PluginAuthConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginAuthConfiguration> {
        public Builder basicAuthConfiguration(BasicAuthConfiguration var1);

        default public Builder basicAuthConfiguration(Consumer<BasicAuthConfiguration.Builder> basicAuthConfiguration) {
            return this.basicAuthConfiguration((BasicAuthConfiguration)((BasicAuthConfiguration.Builder)BasicAuthConfiguration.builder().applyMutation(basicAuthConfiguration)).build());
        }

        public Builder oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfiguration var1);

        default public Builder oAuth2ClientCredentialConfiguration(Consumer<OAuth2ClientCredentialConfiguration.Builder> oAuth2ClientCredentialConfiguration) {
            return this.oAuth2ClientCredentialConfiguration((OAuth2ClientCredentialConfiguration)((OAuth2ClientCredentialConfiguration.Builder)OAuth2ClientCredentialConfiguration.builder().applyMutation(oAuth2ClientCredentialConfiguration)).build());
        }

        public Builder noAuthConfiguration(NoAuthConfiguration var1);

        default public Builder noAuthConfiguration(Consumer<NoAuthConfiguration.Builder> noAuthConfiguration) {
            return this.noAuthConfiguration((NoAuthConfiguration)((NoAuthConfiguration.Builder)NoAuthConfiguration.builder().applyMutation(noAuthConfiguration)).build());
        }

        public Builder idcAuthConfiguration(IdcAuthConfiguration var1);

        default public Builder idcAuthConfiguration(Consumer<IdcAuthConfiguration.Builder> idcAuthConfiguration) {
            return this.idcAuthConfiguration((IdcAuthConfiguration)((IdcAuthConfiguration.Builder)IdcAuthConfiguration.builder().applyMutation(idcAuthConfiguration)).build());
        }
    }
}

