/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to configure access permissions for a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessConfiguration.Builder, AccessConfiguration> {
    private static final SdkField<List<AccessControl>> ACCESS_CONTROLS_FIELD = SdkField
            .<List<AccessControl>> builder(MarshallingType.LIST)
            .memberName("accessControls")
            .getter(getter(AccessConfiguration::accessControls))
            .setter(setter(Builder::accessControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberRelation").getter(getter(AccessConfiguration::memberRelationAsString))
            .setter(setter(Builder::memberRelation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROLS_FIELD,
            MEMBER_RELATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AccessControl> accessControls;

    private final String memberRelation;

    private AccessConfiguration(BuilderImpl builder) {
        this.accessControls = builder.accessControls;
        this.memberRelation = builder.memberRelation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessControls() {
        return accessControls != null && !(accessControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AccessControlList</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessControls} method.
     * </p>
     * 
     * @return A list of <code>AccessControlList</code> objects.
     */
    public final List<AccessControl> accessControls() {
        return accessControls;
    }

    /**
     * <p>
     * Describes the member relation within the <code>AccessControlList</code> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return Describes the member relation within the <code>AccessControlList</code> object.
     * @see MemberRelation
     */
    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(memberRelation);
    }

    /**
     * <p>
     * Describes the member relation within the <code>AccessControlList</code> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return Describes the member relation within the <code>AccessControlList</code> object.
     * @see MemberRelation
     */
    public final String memberRelationAsString() {
        return memberRelation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessControls() ? accessControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(memberRelationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessConfiguration)) {
            return false;
        }
        AccessConfiguration other = (AccessConfiguration) obj;
        return hasAccessControls() == other.hasAccessControls() && Objects.equals(accessControls(), other.accessControls())
                && Objects.equals(memberRelationAsString(), other.memberRelationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessConfiguration").add("AccessControls", hasAccessControls() ? accessControls() : null)
                .add("MemberRelation", memberRelationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessControls":
            return Optional.ofNullable(clazz.cast(accessControls()));
        case "memberRelation":
            return Optional.ofNullable(clazz.cast(memberRelationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessControls", ACCESS_CONTROLS_FIELD);
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessConfiguration, T> g) {
        return obj -> g.apply((AccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessConfiguration> {
        /**
         * <p>
         * A list of <code>AccessControlList</code> objects.
         * </p>
         * 
         * @param accessControls
         *        A list of <code>AccessControlList</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControls(Collection<AccessControl> accessControls);

        /**
         * <p>
         * A list of <code>AccessControlList</code> objects.
         * </p>
         * 
         * @param accessControls
         *        A list of <code>AccessControlList</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControls(AccessControl... accessControls);

        /**
         * <p>
         * A list of <code>AccessControlList</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AccessControl.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.AccessControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AccessControl.Builder#build()} is called immediately
         * and its result is passed to {@link #accessControls(List<AccessControl>)}.
         * 
         * @param accessControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AccessControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControls(java.util.Collection<AccessControl>)
         */
        Builder accessControls(Consumer<AccessControl.Builder>... accessControls);

        /**
         * <p>
         * Describes the member relation within the <code>AccessControlList</code> object.
         * </p>
         * 
         * @param memberRelation
         *        Describes the member relation within the <code>AccessControlList</code> object.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(String memberRelation);

        /**
         * <p>
         * Describes the member relation within the <code>AccessControlList</code> object.
         * </p>
         * 
         * @param memberRelation
         *        Describes the member relation within the <code>AccessControlList</code> object.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(MemberRelation memberRelation);
    }

    static final class BuilderImpl implements Builder {
        private List<AccessControl> accessControls = DefaultSdkAutoConstructList.getInstance();

        private String memberRelation;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessConfiguration model) {
            accessControls(model.accessControls);
            memberRelation(model.memberRelation);
        }

        public final List<AccessControl.Builder> getAccessControls() {
            List<AccessControl.Builder> result = AccessControlsCopier.copyToBuilder(this.accessControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControls(Collection<AccessControl.BuilderImpl> accessControls) {
            this.accessControls = AccessControlsCopier.copyFromBuilder(accessControls);
        }

        @Override
        public final Builder accessControls(Collection<AccessControl> accessControls) {
            this.accessControls = AccessControlsCopier.copy(accessControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControls(AccessControl... accessControls) {
            accessControls(Arrays.asList(accessControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControls(Consumer<AccessControl.Builder>... accessControls) {
            accessControls(Stream.of(accessControls).map(c -> AccessControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMemberRelation() {
            return memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        @Override
        public AccessConfiguration build() {
            return new AccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
