/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An output event that Amazon Q Business returns to an user who wants to perform a plugin action during a non-streaming
 * chat conversation. It contains information about the selected action with a list of possible user input fields, some
 * pre-populated by Amazon Q Business.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionReview implements SdkPojo, Serializable, ToCopyableBuilder<ActionReview.Builder, ActionReview> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(ActionReview::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final SdkField<String> PLUGIN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginType").getter(getter(ActionReview::pluginTypeAsString)).setter(setter(Builder::pluginType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginType").build()).build();

    private static final SdkField<Map<String, ActionReviewPayloadField>> PAYLOAD_FIELD = SdkField
            .<Map<String, ActionReviewPayloadField>> builder(MarshallingType.MAP)
            .memberName("payload")
            .getter(getter(ActionReview::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ActionReviewPayloadField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionReviewPayloadField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PAYLOAD_FIELD_NAME_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("payloadFieldNameSeparator").getter(getter(ActionReview::payloadFieldNameSeparator))
            .setter(setter(Builder::payloadFieldNameSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFieldNameSeparator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD,
            PLUGIN_TYPE_FIELD, PAYLOAD_FIELD, PAYLOAD_FIELD_NAME_SEPARATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pluginId;

    private final String pluginType;

    private final Map<String, ActionReviewPayloadField> payload;

    private final String payloadFieldNameSeparator;

    private ActionReview(BuilderImpl builder) {
        this.pluginId = builder.pluginId;
        this.pluginType = builder.pluginType;
        this.payload = builder.payload;
        this.payloadFieldNameSeparator = builder.payloadFieldNameSeparator;
    }

    /**
     * <p>
     * The identifier of the plugin associated with the action review.
     * </p>
     * 
     * @return The identifier of the plugin associated with the action review.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The type of plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pluginType} will
     * return {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pluginTypeAsString}.
     * </p>
     * 
     * @return The type of plugin.
     * @see PluginType
     */
    public final PluginType pluginType() {
        return PluginType.fromValue(pluginType);
    }

    /**
     * <p>
     * The type of plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pluginType} will
     * return {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pluginTypeAsString}.
     * </p>
     * 
     * @return The type of plugin.
     * @see PluginType
     */
    public final String pluginTypeAsString() {
        return pluginType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Payload property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPayload() {
        return payload != null && !(payload instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Field values that an end user needs to provide to Amazon Q Business for Amazon Q Business to perform the
     * requested plugin action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPayload} method.
     * </p>
     * 
     * @return Field values that an end user needs to provide to Amazon Q Business for Amazon Q Business to perform the
     *         requested plugin action.
     */
    public final Map<String, ActionReviewPayloadField> payload() {
        return payload;
    }

    /**
     * <p>
     * A string used to retain information about the hierarchical contexts within an action review payload.
     * </p>
     * 
     * @return A string used to retain information about the hierarchical contexts within an action review payload.
     */
    public final String payloadFieldNameSeparator() {
        return payloadFieldNameSeparator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(pluginTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPayload() ? payload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(payloadFieldNameSeparator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionReview)) {
            return false;
        }
        ActionReview other = (ActionReview) obj;
        return Objects.equals(pluginId(), other.pluginId()) && Objects.equals(pluginTypeAsString(), other.pluginTypeAsString())
                && hasPayload() == other.hasPayload() && Objects.equals(payload(), other.payload())
                && Objects.equals(payloadFieldNameSeparator(), other.payloadFieldNameSeparator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionReview").add("PluginId", pluginId()).add("PluginType", pluginTypeAsString())
                .add("Payload", hasPayload() ? payload() : null).add("PayloadFieldNameSeparator", payloadFieldNameSeparator())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "pluginType":
            return Optional.ofNullable(clazz.cast(pluginTypeAsString()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "payloadFieldNameSeparator":
            return Optional.ofNullable(clazz.cast(payloadFieldNameSeparator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("pluginType", PLUGIN_TYPE_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("payloadFieldNameSeparator", PAYLOAD_FIELD_NAME_SEPARATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionReview, T> g) {
        return obj -> g.apply((ActionReview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionReview> {
        /**
         * <p>
         * The identifier of the plugin associated with the action review.
         * </p>
         * 
         * @param pluginId
         *        The identifier of the plugin associated with the action review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The type of plugin.
         * </p>
         * 
         * @param pluginType
         *        The type of plugin.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder pluginType(String pluginType);

        /**
         * <p>
         * The type of plugin.
         * </p>
         * 
         * @param pluginType
         *        The type of plugin.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder pluginType(PluginType pluginType);

        /**
         * <p>
         * Field values that an end user needs to provide to Amazon Q Business for Amazon Q Business to perform the
         * requested plugin action.
         * </p>
         * 
         * @param payload
         *        Field values that an end user needs to provide to Amazon Q Business for Amazon Q Business to perform
         *        the requested plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Map<String, ActionReviewPayloadField> payload);

        /**
         * <p>
         * A string used to retain information about the hierarchical contexts within an action review payload.
         * </p>
         * 
         * @param payloadFieldNameSeparator
         *        A string used to retain information about the hierarchical contexts within an action review payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadFieldNameSeparator(String payloadFieldNameSeparator);
    }

    static final class BuilderImpl implements Builder {
        private String pluginId;

        private String pluginType;

        private Map<String, ActionReviewPayloadField> payload = DefaultSdkAutoConstructMap.getInstance();

        private String payloadFieldNameSeparator;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionReview model) {
            pluginId(model.pluginId);
            pluginType(model.pluginType);
            payload(model.payload);
            payloadFieldNameSeparator(model.payloadFieldNameSeparator);
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getPluginType() {
            return pluginType;
        }

        public final void setPluginType(String pluginType) {
            this.pluginType = pluginType;
        }

        @Override
        public final Builder pluginType(String pluginType) {
            this.pluginType = pluginType;
            return this;
        }

        @Override
        public final Builder pluginType(PluginType pluginType) {
            this.pluginType(pluginType == null ? null : pluginType.toString());
            return this;
        }

        public final Map<String, ActionReviewPayloadField.Builder> getPayload() {
            Map<String, ActionReviewPayloadField.Builder> result = ActionReviewPayloadCopier.copyToBuilder(this.payload);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPayload(Map<String, ActionReviewPayloadField.BuilderImpl> payload) {
            this.payload = ActionReviewPayloadCopier.copyFromBuilder(payload);
        }

        @Override
        public final Builder payload(Map<String, ActionReviewPayloadField> payload) {
            this.payload = ActionReviewPayloadCopier.copy(payload);
            return this;
        }

        public final String getPayloadFieldNameSeparator() {
            return payloadFieldNameSeparator;
        }

        public final void setPayloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
        }

        @Override
        public final Builder payloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
            return this;
        }

        @Override
        public ActionReview build() {
            return new ActionReview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
