/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for an Amazon Q Business plugin action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionSummary implements SdkPojo, Serializable, ToCopyableBuilder<ActionSummary.Builder, ActionSummary> {
    private static final SdkField<String> ACTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionIdentifier").getter(getter(ActionSummary::actionIdentifier))
            .setter(setter(Builder::actionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIdentifier").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(ActionSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> INSTRUCTION_EXAMPLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instructionExample").getter(getter(ActionSummary::instructionExample))
            .setter(setter(Builder::instructionExample))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionExample").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ActionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_IDENTIFIER_FIELD,
            DISPLAY_NAME_FIELD, INSTRUCTION_EXAMPLE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionIdentifier;

    private final String displayName;

    private final String instructionExample;

    private final String description;

    private ActionSummary(BuilderImpl builder) {
        this.actionIdentifier = builder.actionIdentifier;
        this.displayName = builder.displayName;
        this.instructionExample = builder.instructionExample;
        this.description = builder.description;
    }

    /**
     * <p>
     * The identifier of an Amazon Q Business plugin action.
     * </p>
     * 
     * @return The identifier of an Amazon Q Business plugin action.
     */
    public final String actionIdentifier() {
        return actionIdentifier;
    }

    /**
     * <p>
     * The display name assigned by Amazon Q Business to a plugin action. You can't modify this value.
     * </p>
     * 
     * @return The display name assigned by Amazon Q Business to a plugin action. You can't modify this value.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * An Amazon Q Business suggested prompt and end user can use to invoke a plugin action. This value can be modified
     * and sent as input to initiate an action. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a Jira task
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a chat assistant task to find the root cause of a specific incident
     * </p>
     * </li>
     * </ul>
     * 
     * @return An Amazon Q Business suggested prompt and end user can use to invoke a plugin action. This value can be
     *         modified and sent as input to initiate an action. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Create a Jira task
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create a chat assistant task to find the root cause of a specific incident
     *         </p>
     *         </li>
     */
    public final String instructionExample() {
        return instructionExample;
    }

    /**
     * <p>
     * The description of an Amazon Q Business plugin action.
     * </p>
     * 
     * @return The description of an Amazon Q Business plugin action.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(instructionExample());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionSummary)) {
            return false;
        }
        ActionSummary other = (ActionSummary) obj;
        return Objects.equals(actionIdentifier(), other.actionIdentifier()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(instructionExample(), other.instructionExample())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionSummary").add("ActionIdentifier", actionIdentifier()).add("DisplayName", displayName())
                .add("InstructionExample", instructionExample()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionIdentifier":
            return Optional.ofNullable(clazz.cast(actionIdentifier()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "instructionExample":
            return Optional.ofNullable(clazz.cast(instructionExample()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionIdentifier", ACTION_IDENTIFIER_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("instructionExample", INSTRUCTION_EXAMPLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionSummary, T> g) {
        return obj -> g.apply((ActionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionSummary> {
        /**
         * <p>
         * The identifier of an Amazon Q Business plugin action.
         * </p>
         * 
         * @param actionIdentifier
         *        The identifier of an Amazon Q Business plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionIdentifier(String actionIdentifier);

        /**
         * <p>
         * The display name assigned by Amazon Q Business to a plugin action. You can't modify this value.
         * </p>
         * 
         * @param displayName
         *        The display name assigned by Amazon Q Business to a plugin action. You can't modify this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * An Amazon Q Business suggested prompt and end user can use to invoke a plugin action. This value can be
         * modified and sent as input to initiate an action. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Create a Jira task
         * </p>
         * </li>
         * <li>
         * <p>
         * Create a chat assistant task to find the root cause of a specific incident
         * </p>
         * </li>
         * </ul>
         * 
         * @param instructionExample
         *        An Amazon Q Business suggested prompt and end user can use to invoke a plugin action. This value can
         *        be modified and sent as input to initiate an action. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Create a Jira task
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create a chat assistant task to find the root cause of a specific incident
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionExample(String instructionExample);

        /**
         * <p>
         * The description of an Amazon Q Business plugin action.
         * </p>
         * 
         * @param description
         *        The description of an Amazon Q Business plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String actionIdentifier;

        private String displayName;

        private String instructionExample;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionSummary model) {
            actionIdentifier(model.actionIdentifier);
            displayName(model.displayName);
            instructionExample(model.instructionExample);
            description(model.description);
        }

        public final String getActionIdentifier() {
            return actionIdentifier;
        }

        public final void setActionIdentifier(String actionIdentifier) {
            this.actionIdentifier = actionIdentifier;
        }

        @Override
        public final Builder actionIdentifier(String actionIdentifier) {
            this.actionIdentifier = actionIdentifier;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getInstructionExample() {
            return instructionExample;
        }

        public final void setInstructionExample(String instructionExample) {
            this.instructionExample = instructionExample;
        }

        @Override
        public final Builder instructionExample(String instructionExample) {
            this.instructionExample = instructionExample;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ActionSummary build() {
            return new ActionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
