/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The creator mode specific admin controls configured for an Amazon Q Business application. Determines whether an end
 * user can generate LLM-only responses when they use the web experience.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin
 * controls and guardrails</a> and <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
 * >Conversation settings</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppliedCreatorModeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppliedCreatorModeConfiguration.Builder, AppliedCreatorModeConfiguration> {
    private static final SdkField<String> CREATOR_MODE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorModeControl").getter(getter(AppliedCreatorModeConfiguration::creatorModeControlAsString))
            .setter(setter(Builder::creatorModeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorModeControl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_MODE_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String creatorModeControl;

    private AppliedCreatorModeConfiguration(BuilderImpl builder) {
        this.creatorModeControl = builder.creatorModeControl;
    }

    /**
     * <p>
     * Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #creatorModeControl} will return {@link CreatorModeControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #creatorModeControlAsString}.
     * </p>
     * 
     * @return Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
     * @see CreatorModeControl
     */
    public final CreatorModeControl creatorModeControl() {
        return CreatorModeControl.fromValue(creatorModeControl);
    }

    /**
     * <p>
     * Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #creatorModeControl} will return {@link CreatorModeControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #creatorModeControlAsString}.
     * </p>
     * 
     * @return Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
     * @see CreatorModeControl
     */
    public final String creatorModeControlAsString() {
        return creatorModeControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creatorModeControlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedCreatorModeConfiguration)) {
            return false;
        }
        AppliedCreatorModeConfiguration other = (AppliedCreatorModeConfiguration) obj;
        return Objects.equals(creatorModeControlAsString(), other.creatorModeControlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppliedCreatorModeConfiguration").add("CreatorModeControl", creatorModeControlAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creatorModeControl":
            return Optional.ofNullable(clazz.cast(creatorModeControlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("creatorModeControl", CREATOR_MODE_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppliedCreatorModeConfiguration, T> g) {
        return obj -> g.apply((AppliedCreatorModeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppliedCreatorModeConfiguration> {
        /**
         * <p>
         * Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
         * </p>
         * 
         * @param creatorModeControl
         *        Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
         * @see CreatorModeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreatorModeControl
         */
        Builder creatorModeControl(String creatorModeControl);

        /**
         * <p>
         * Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
         * </p>
         * 
         * @param creatorModeControl
         *        Information about whether creator mode is enabled or disabled for an Amazon Q Business application.
         * @see CreatorModeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreatorModeControl
         */
        Builder creatorModeControl(CreatorModeControl creatorModeControl);
    }

    static final class BuilderImpl implements Builder {
        private String creatorModeControl;

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedCreatorModeConfiguration model) {
            creatorModeControl(model.creatorModeControl);
        }

        public final String getCreatorModeControl() {
            return creatorModeControl;
        }

        public final void setCreatorModeControl(String creatorModeControl) {
            this.creatorModeControl = creatorModeControl;
        }

        @Override
        public final Builder creatorModeControl(String creatorModeControl) {
            this.creatorModeControl = creatorModeControl;
            return this;
        }

        @Override
        public final Builder creatorModeControl(CreatorModeControl creatorModeControl) {
            this.creatorModeControl(creatorModeControl == null ? null : creatorModeControl.toString());
            return this;
        }

        @Override
        public AppliedCreatorModeConfiguration build() {
            return new AppliedCreatorModeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
