/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attachment in an Amazon Q Business conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attachment implements SdkPojo, Serializable, ToCopyableBuilder<Attachment.Builder, Attachment> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentId").getter(getter(Attachment::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(Attachment::conversationId)).setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Attachment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<CopyFromSource> COPY_FROM_FIELD = SdkField.<CopyFromSource> builder(MarshallingType.SDK_POJO)
            .memberName("copyFrom").getter(getter(Attachment::copyFrom)).setter(setter(Builder::copyFrom))
            .constructor(CopyFromSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyFrom").build()).build();

    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileType").getter(getter(Attachment::fileType)).setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final SdkField<Integer> FILE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("fileSize").getter(getter(Attachment::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()).build();

    private static final SdkField<String> MD5_CHKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("md5chksum").getter(getter(Attachment::md5chksum)).setter(setter(Builder::md5chksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5chksum").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Attachment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Attachment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(Attachment::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            CONVERSATION_ID_FIELD, NAME_FIELD, COPY_FROM_FIELD, FILE_TYPE_FIELD, FILE_SIZE_FIELD, MD5_CHKSUM_FIELD,
            CREATED_AT_FIELD, STATUS_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachmentId;

    private final String conversationId;

    private final String name;

    private final CopyFromSource copyFrom;

    private final String fileType;

    private final Integer fileSize;

    private final String md5chksum;

    private final Instant createdAt;

    private final String status;

    private final ErrorDetail error;

    private Attachment(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.conversationId = builder.conversationId;
        this.name = builder.name;
        this.copyFrom = builder.copyFrom;
        this.fileType = builder.fileType;
        this.fileSize = builder.fileSize;
        this.md5chksum = builder.md5chksum;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.error = builder.error;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business attachment.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business conversation the attachment is associated with.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business conversation the attachment is associated with.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * Filename of the Amazon Q Business attachment.
     * </p>
     * 
     * @return Filename of the Amazon Q Business attachment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A CopyFromSource containing a reference to the original source of the Amazon Q Business attachment.
     * </p>
     * 
     * @return A CopyFromSource containing a reference to the original source of the Amazon Q Business attachment.
     */
    public final CopyFromSource copyFrom() {
        return copyFrom;
    }

    /**
     * <p>
     * Filetype of the Amazon Q Business attachment.
     * </p>
     * 
     * @return Filetype of the Amazon Q Business attachment.
     */
    public final String fileType() {
        return fileType;
    }

    /**
     * <p>
     * Size in bytes of the Amazon Q Business attachment.
     * </p>
     * 
     * @return Size in bytes of the Amazon Q Business attachment.
     */
    public final Integer fileSize() {
        return fileSize;
    }

    /**
     * <p>
     * MD5 checksum of the Amazon Q Business attachment contents.
     * </p>
     * 
     * @return MD5 checksum of the Amazon Q Business attachment contents.
     */
    public final String md5chksum() {
        return md5chksum;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business attachment was created.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business attachment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * AttachmentStatus of the Amazon Q Business attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return AttachmentStatus of the Amazon Q Business attachment.
     * @see AttachmentStatus
     */
    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(status);
    }

    /**
     * <p>
     * AttachmentStatus of the Amazon Q Business attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return AttachmentStatus of the Amazon Q Business attachment.
     * @see AttachmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * ErrorDetail providing information about a Amazon Q Business attachment error.
     * </p>
     * 
     * @return ErrorDetail providing information about a Amazon Q Business attachment error.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(copyFrom());
        hashCode = 31 * hashCode + Objects.hashCode(fileType());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(md5chksum());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(name(), other.name()) && Objects.equals(copyFrom(), other.copyFrom())
                && Objects.equals(fileType(), other.fileType()) && Objects.equals(fileSize(), other.fileSize())
                && Objects.equals(md5chksum(), other.md5chksum()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attachment").add("AttachmentId", attachmentId()).add("ConversationId", conversationId())
                .add("Name", name()).add("CopyFrom", copyFrom()).add("FileType", fileType()).add("FileSize", fileSize())
                .add("Md5chksum", md5chksum()).add("CreatedAt", createdAt()).add("Status", statusAsString())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "copyFrom":
            return Optional.ofNullable(clazz.cast(copyFrom()));
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileType()));
        case "fileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "md5chksum":
            return Optional.ofNullable(clazz.cast(md5chksum()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("copyFrom", COPY_FROM_FIELD);
        map.put("fileType", FILE_TYPE_FIELD);
        map.put("fileSize", FILE_SIZE_FIELD);
        map.put("md5chksum", MD5_CHKSUM_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attachment> {
        /**
         * <p>
         * The identifier of the Amazon Q Business attachment.
         * </p>
         * 
         * @param attachmentId
         *        The identifier of the Amazon Q Business attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The identifier of the Amazon Q Business conversation the attachment is associated with.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the Amazon Q Business conversation the attachment is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * Filename of the Amazon Q Business attachment.
         * </p>
         * 
         * @param name
         *        Filename of the Amazon Q Business attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A CopyFromSource containing a reference to the original source of the Amazon Q Business attachment.
         * </p>
         * 
         * @param copyFrom
         *        A CopyFromSource containing a reference to the original source of the Amazon Q Business attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyFrom(CopyFromSource copyFrom);

        /**
         * <p>
         * A CopyFromSource containing a reference to the original source of the Amazon Q Business attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopyFromSource.Builder} avoiding the need
         * to create one manually via {@link CopyFromSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopyFromSource.Builder#build()} is called immediately and its
         * result is passed to {@link #copyFrom(CopyFromSource)}.
         * 
         * @param copyFrom
         *        a consumer that will call methods on {@link CopyFromSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyFrom(CopyFromSource)
         */
        default Builder copyFrom(Consumer<CopyFromSource.Builder> copyFrom) {
            return copyFrom(CopyFromSource.builder().applyMutation(copyFrom).build());
        }

        /**
         * <p>
         * Filetype of the Amazon Q Business attachment.
         * </p>
         * 
         * @param fileType
         *        Filetype of the Amazon Q Business attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * Size in bytes of the Amazon Q Business attachment.
         * </p>
         * 
         * @param fileSize
         *        Size in bytes of the Amazon Q Business attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Integer fileSize);

        /**
         * <p>
         * MD5 checksum of the Amazon Q Business attachment contents.
         * </p>
         * 
         * @param md5chksum
         *        MD5 checksum of the Amazon Q Business attachment contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5chksum(String md5chksum);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business attachment was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q Business attachment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * AttachmentStatus of the Amazon Q Business attachment.
         * </p>
         * 
         * @param status
         *        AttachmentStatus of the Amazon Q Business attachment.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * AttachmentStatus of the Amazon Q Business attachment.
         * </p>
         * 
         * @param status
         *        AttachmentStatus of the Amazon Q Business attachment.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(AttachmentStatus status);

        /**
         * <p>
         * ErrorDetail providing information about a Amazon Q Business attachment error.
         * </p>
         * 
         * @param error
         *        ErrorDetail providing information about a Amazon Q Business attachment error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * ErrorDetail providing information about a Amazon Q Business attachment error.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String conversationId;

        private String name;

        private CopyFromSource copyFrom;

        private String fileType;

        private Integer fileSize;

        private String md5chksum;

        private Instant createdAt;

        private String status;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            attachmentId(model.attachmentId);
            conversationId(model.conversationId);
            name(model.name);
            copyFrom(model.copyFrom);
            fileType(model.fileType);
            fileSize(model.fileSize);
            md5chksum(model.md5chksum);
            createdAt(model.createdAt);
            status(model.status);
            error(model.error);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CopyFromSource.Builder getCopyFrom() {
            return copyFrom != null ? copyFrom.toBuilder() : null;
        }

        public final void setCopyFrom(CopyFromSource.BuilderImpl copyFrom) {
            this.copyFrom = copyFrom != null ? copyFrom.build() : null;
        }

        @Override
        public final Builder copyFrom(CopyFromSource copyFrom) {
            this.copyFrom = copyFrom;
            return this;
        }

        public final String getFileType() {
            return fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public final Integer getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Integer fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Integer fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final String getMd5chksum() {
            return md5chksum;
        }

        public final void setMd5chksum(String md5chksum) {
            this.md5chksum = md5chksum;
        }

        @Override
        public final Builder md5chksum(String md5chksum) {
            this.md5chksum = md5chksum;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public Attachment build() {
            return new Attachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
