/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is either a file directly uploaded into a web experience chat or a reference to an existing attachment that is
 * part of a web experience chat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentInput implements SdkPojo, Serializable, ToCopyableBuilder<AttachmentInput.Builder, AttachmentInput> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(AttachmentInput::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AttachmentInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<CopyFromSource> COPY_FROM_FIELD = SdkField.<CopyFromSource> builder(MarshallingType.SDK_POJO)
            .memberName("copyFrom").getter(getter(AttachmentInput::copyFrom)).setter(setter(Builder::copyFrom))
            .constructor(CopyFromSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, NAME_FIELD,
            COPY_FROM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes data;

    private final String name;

    private final CopyFromSource copyFrom;

    private AttachmentInput(BuilderImpl builder) {
        this.data = builder.data;
        this.name = builder.name;
        this.copyFrom = builder.copyFrom;
    }

    /**
     * <p>
     * The contents of the attachment.
     * </p>
     * 
     * @return The contents of the attachment.
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The filename of the attachment.
     * </p>
     * 
     * @return The filename of the attachment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A reference to an existing attachment.
     * </p>
     * 
     * @return A reference to an existing attachment.
     */
    public final CopyFromSource copyFrom() {
        return copyFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(copyFrom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentInput)) {
            return false;
        }
        AttachmentInput other = (AttachmentInput) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(name(), other.name())
                && Objects.equals(copyFrom(), other.copyFrom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachmentInput").add("Data", data()).add("Name", name()).add("CopyFrom", copyFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "copyFrom":
            return Optional.ofNullable(clazz.cast(copyFrom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("data", DATA_FIELD);
        map.put("name", NAME_FIELD);
        map.put("copyFrom", COPY_FROM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachmentInput, T> g) {
        return obj -> g.apply((AttachmentInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentInput> {
        /**
         * <p>
         * The contents of the attachment.
         * </p>
         * 
         * @param data
         *        The contents of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The filename of the attachment.
         * </p>
         * 
         * @param name
         *        The filename of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A reference to an existing attachment.
         * </p>
         * 
         * @param copyFrom
         *        A reference to an existing attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyFrom(CopyFromSource copyFrom);

        /**
         * <p>
         * A reference to an existing attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopyFromSource.Builder} avoiding the need
         * to create one manually via {@link CopyFromSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopyFromSource.Builder#build()} is called immediately and its
         * result is passed to {@link #copyFrom(CopyFromSource)}.
         * 
         * @param copyFrom
         *        a consumer that will call methods on {@link CopyFromSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyFrom(CopyFromSource)
         */
        default Builder copyFrom(Consumer<CopyFromSource.Builder> copyFrom) {
            return copyFrom(CopyFromSource.builder().applyMutation(copyFrom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes data;

        private String name;

        private CopyFromSource copyFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentInput model) {
            data(model.data);
            name(model.name);
            copyFrom(model.copyFrom);
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CopyFromSource.Builder getCopyFrom() {
            return copyFrom != null ? copyFrom.toBuilder() : null;
        }

        public final void setCopyFrom(CopyFromSource.BuilderImpl copyFrom) {
            this.copyFrom = copyFrom != null ? copyFrom.build() : null;
        }

        @Override
        public final Builder copyFrom(CopyFromSource copyFrom) {
            this.copyFrom = copyFrom;
            return this;
        }

        @Override
        public AttachmentInput build() {
            return new AttachmentInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
