/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the phrases blocked from chat by your chat control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockedPhrasesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockedPhrasesConfiguration.Builder, BlockedPhrasesConfiguration> {
    private static final SdkField<List<String>> BLOCKED_PHRASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedPhrases")
            .getter(getter(BlockedPhrasesConfiguration::blockedPhrases))
            .setter(setter(Builder::blockedPhrases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageOverride").getter(getter(BlockedPhrasesConfiguration::systemMessageOverride))
            .setter(setter(Builder::systemMessageOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_PHRASES_FIELD,
            SYSTEM_MESSAGE_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> blockedPhrases;

    private final String systemMessageOverride;

    private BlockedPhrasesConfiguration(BuilderImpl builder) {
        this.blockedPhrases = builder.blockedPhrases;
        this.systemMessageOverride = builder.systemMessageOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedPhrases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedPhrases() {
        return blockedPhrases != null && !(blockedPhrases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of phrases blocked from a Amazon Q Business web experience chat.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedPhrases} method.
     * </p>
     * 
     * @return A list of phrases blocked from a Amazon Q Business web experience chat.
     */
    public final List<String> blockedPhrases() {
        return blockedPhrases;
    }

    /**
     * <p>
     * The configured custom message displayed to an end user informing them that they've used a blocked phrase during
     * chat.
     * </p>
     * 
     * @return The configured custom message displayed to an end user informing them that they've used a blocked phrase
     *         during chat.
     */
    public final String systemMessageOverride() {
        return systemMessageOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedPhrases() ? blockedPhrases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockedPhrasesConfiguration)) {
            return false;
        }
        BlockedPhrasesConfiguration other = (BlockedPhrasesConfiguration) obj;
        return hasBlockedPhrases() == other.hasBlockedPhrases() && Objects.equals(blockedPhrases(), other.blockedPhrases())
                && Objects.equals(systemMessageOverride(), other.systemMessageOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockedPhrasesConfiguration")
                .add("BlockedPhrases", hasBlockedPhrases() ? blockedPhrases() : null)
                .add("SystemMessageOverride", systemMessageOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockedPhrases":
            return Optional.ofNullable(clazz.cast(blockedPhrases()));
        case "systemMessageOverride":
            return Optional.ofNullable(clazz.cast(systemMessageOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blockedPhrases", BLOCKED_PHRASES_FIELD);
        map.put("systemMessageOverride", SYSTEM_MESSAGE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockedPhrasesConfiguration, T> g) {
        return obj -> g.apply((BlockedPhrasesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockedPhrasesConfiguration> {
        /**
         * <p>
         * A list of phrases blocked from a Amazon Q Business web experience chat.
         * </p>
         * 
         * @param blockedPhrases
         *        A list of phrases blocked from a Amazon Q Business web experience chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrases(Collection<String> blockedPhrases);

        /**
         * <p>
         * A list of phrases blocked from a Amazon Q Business web experience chat.
         * </p>
         * 
         * @param blockedPhrases
         *        A list of phrases blocked from a Amazon Q Business web experience chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrases(String... blockedPhrases);

        /**
         * <p>
         * The configured custom message displayed to an end user informing them that they've used a blocked phrase
         * during chat.
         * </p>
         * 
         * @param systemMessageOverride
         *        The configured custom message displayed to an end user informing them that they've used a blocked
         *        phrase during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageOverride(String systemMessageOverride);
    }

    static final class BuilderImpl implements Builder {
        private List<String> blockedPhrases = DefaultSdkAutoConstructList.getInstance();

        private String systemMessageOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockedPhrasesConfiguration model) {
            blockedPhrases(model.blockedPhrases);
            systemMessageOverride(model.systemMessageOverride);
        }

        public final Collection<String> getBlockedPhrases() {
            if (blockedPhrases instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedPhrases;
        }

        public final void setBlockedPhrases(Collection<String> blockedPhrases) {
            this.blockedPhrases = BlockedPhrasesCopier.copy(blockedPhrases);
        }

        @Override
        public final Builder blockedPhrases(Collection<String> blockedPhrases) {
            this.blockedPhrases = BlockedPhrasesCopier.copy(blockedPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedPhrases(String... blockedPhrases) {
            blockedPhrases(Arrays.asList(blockedPhrases));
            return this;
        }

        public final String getSystemMessageOverride() {
            return systemMessageOverride;
        }

        public final void setSystemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
        }

        @Override
        public final Builder systemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
            return this;
        }

        @Override
        public BlockedPhrasesConfiguration build() {
            return new BlockedPhrasesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
