/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for browser extension configuration for an Amazon Q Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrowserExtensionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BrowserExtensionConfiguration.Builder, BrowserExtensionConfiguration> {
    private static final SdkField<List<String>> ENABLED_BROWSER_EXTENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enabledBrowserExtensions")
            .getter(getter(BrowserExtensionConfiguration::enabledBrowserExtensionsAsStrings))
            .setter(setter(Builder::enabledBrowserExtensionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledBrowserExtensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLED_BROWSER_EXTENSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> enabledBrowserExtensions;

    private BrowserExtensionConfiguration(BuilderImpl builder) {
        this.enabledBrowserExtensions = builder.enabledBrowserExtensions;
    }

    /**
     * <p>
     * Specify the browser extensions allowed for your Amazon Q web experience.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge, Opera,
     * etc.).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and Mozilla
     * Firefox.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledBrowserExtensions} method.
     * </p>
     * 
     * @return Specify the browser extensions allowed for your Amazon Q web experience.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge,
     *         Opera, etc.).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and
     *         Mozilla Firefox.
     *         </p>
     *         </li>
     */
    public final List<BrowserExtension> enabledBrowserExtensions() {
        return BrowserExtensionListCopier.copyStringToEnum(enabledBrowserExtensions);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledBrowserExtensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledBrowserExtensions() {
        return enabledBrowserExtensions != null && !(enabledBrowserExtensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the browser extensions allowed for your Amazon Q web experience.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge, Opera,
     * etc.).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and Mozilla
     * Firefox.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledBrowserExtensions} method.
     * </p>
     * 
     * @return Specify the browser extensions allowed for your Amazon Q web experience.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge,
     *         Opera, etc.).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and
     *         Mozilla Firefox.
     *         </p>
     *         </li>
     */
    public final List<String> enabledBrowserExtensionsAsStrings() {
        return enabledBrowserExtensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledBrowserExtensions() ? enabledBrowserExtensionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserExtensionConfiguration)) {
            return false;
        }
        BrowserExtensionConfiguration other = (BrowserExtensionConfiguration) obj;
        return hasEnabledBrowserExtensions() == other.hasEnabledBrowserExtensions()
                && Objects.equals(enabledBrowserExtensionsAsStrings(), other.enabledBrowserExtensionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrowserExtensionConfiguration")
                .add("EnabledBrowserExtensions", hasEnabledBrowserExtensions() ? enabledBrowserExtensionsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabledBrowserExtensions":
            return Optional.ofNullable(clazz.cast(enabledBrowserExtensionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabledBrowserExtensions", ENABLED_BROWSER_EXTENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrowserExtensionConfiguration, T> g) {
        return obj -> g.apply((BrowserExtensionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrowserExtensionConfiguration> {
        /**
         * <p>
         * Specify the browser extensions allowed for your Amazon Q web experience.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge,
         * Opera, etc.).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and Mozilla
         * Firefox.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enabledBrowserExtensions
         *        Specify the browser extensions allowed for your Amazon Q web experience.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft
         *        Edge, Opera, etc.).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and
         *        Mozilla Firefox.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBrowserExtensionsWithStrings(Collection<String> enabledBrowserExtensions);

        /**
         * <p>
         * Specify the browser extensions allowed for your Amazon Q web experience.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge,
         * Opera, etc.).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and Mozilla
         * Firefox.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enabledBrowserExtensions
         *        Specify the browser extensions allowed for your Amazon Q web experience.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft
         *        Edge, Opera, etc.).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and
         *        Mozilla Firefox.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBrowserExtensionsWithStrings(String... enabledBrowserExtensions);

        /**
         * <p>
         * Specify the browser extensions allowed for your Amazon Q web experience.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge,
         * Opera, etc.).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and Mozilla
         * Firefox.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enabledBrowserExtensions
         *        Specify the browser extensions allowed for your Amazon Q web experience.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft
         *        Edge, Opera, etc.).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and
         *        Mozilla Firefox.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBrowserExtensions(Collection<BrowserExtension> enabledBrowserExtensions);

        /**
         * <p>
         * Specify the browser extensions allowed for your Amazon Q web experience.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft Edge,
         * Opera, etc.).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and Mozilla
         * Firefox.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enabledBrowserExtensions
         *        Specify the browser extensions allowed for your Amazon Q web experience.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHROME</code> — Enables the extension for Chromium-based browsers (Google Chrome, Microsoft
         *        Edge, Opera, etc.).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIREFOX</code> — Enables the extension for Mozilla Firefox.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHROME</code> and <code>FIREFOX</code> — Enable the extension for Chromium-based browsers and
         *        Mozilla Firefox.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledBrowserExtensions(BrowserExtension... enabledBrowserExtensions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> enabledBrowserExtensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserExtensionConfiguration model) {
            enabledBrowserExtensionsWithStrings(model.enabledBrowserExtensions);
        }

        public final Collection<String> getEnabledBrowserExtensions() {
            if (enabledBrowserExtensions instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledBrowserExtensions;
        }

        public final void setEnabledBrowserExtensions(Collection<String> enabledBrowserExtensions) {
            this.enabledBrowserExtensions = BrowserExtensionListCopier.copy(enabledBrowserExtensions);
        }

        @Override
        public final Builder enabledBrowserExtensionsWithStrings(Collection<String> enabledBrowserExtensions) {
            this.enabledBrowserExtensions = BrowserExtensionListCopier.copy(enabledBrowserExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledBrowserExtensionsWithStrings(String... enabledBrowserExtensions) {
            enabledBrowserExtensionsWithStrings(Arrays.asList(enabledBrowserExtensions));
            return this;
        }

        @Override
        public final Builder enabledBrowserExtensions(Collection<BrowserExtension> enabledBrowserExtensions) {
            this.enabledBrowserExtensions = BrowserExtensionListCopier.copyEnumToString(enabledBrowserExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledBrowserExtensions(BrowserExtension... enabledBrowserExtensions) {
            enabledBrowserExtensions(Arrays.asList(enabledBrowserExtensions));
            return this;
        }

        @Override
        public BrowserExtensionConfiguration build() {
            return new BrowserExtensionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
