/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration event activated by an end user request to select a specific chat mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationEvent.Builder, ConfigurationEvent>, ChatInputStream {
    private static final SdkField<String> CHAT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("chatMode").getter(getter(ConfigurationEvent::chatModeAsString)).setter(setter(Builder::chatMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatMode").build()).build();

    private static final SdkField<ChatModeConfiguration> CHAT_MODE_CONFIGURATION_FIELD = SdkField
            .<ChatModeConfiguration> builder(MarshallingType.SDK_POJO).memberName("chatModeConfiguration")
            .getter(getter(ConfigurationEvent::chatModeConfiguration)).setter(setter(Builder::chatModeConfiguration))
            .constructor(ChatModeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatModeConfiguration").build())
            .build();

    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("attributeFilter")
            .getter(getter(ConfigurationEvent::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_MODE_FIELD,
            CHAT_MODE_CONFIGURATION_FIELD, ATTRIBUTE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String chatMode;

    private final ChatModeConfiguration chatModeConfiguration;

    private final AttributeFilter attributeFilter;

    protected ConfigurationEvent(BuilderImpl builder) {
        this.chatMode = builder.chatMode;
        this.chatModeConfiguration = builder.chatModeConfiguration;
        this.attributeFilter = builder.attributeFilter;
    }

    /**
     * <p>
     * The chat modes available to an Amazon Q Business end user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this mode is
     * enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business
     * application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from the LLM
     * knowledge, without consulting connected data sources, for a chat request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin
     * controls and guardrails</a>, <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>, and <a
     * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
     * >Conversation settings</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #chatMode} will
     * return {@link ChatMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #chatModeAsString}.
     * </p>
     * 
     * @return The chat modes available to an Amazon Q Business end user.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this mode
     *         is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q
     *         Business application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from the
     *         LLM knowledge, without consulting connected data sources, for a chat request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin controls and
     *         guardrails</a>, <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>, and <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
     *         >Conversation settings</a>.
     * @see ChatMode
     */
    public final ChatMode chatMode() {
        return ChatMode.fromValue(chatMode);
    }

    /**
     * <p>
     * The chat modes available to an Amazon Q Business end user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this mode is
     * enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business
     * application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from the LLM
     * knowledge, without consulting connected data sources, for a chat request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin
     * controls and guardrails</a>, <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>, and <a
     * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
     * >Conversation settings</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #chatMode} will
     * return {@link ChatMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #chatModeAsString}.
     * </p>
     * 
     * @return The chat modes available to an Amazon Q Business end user.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this mode
     *         is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q
     *         Business application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from the
     *         LLM knowledge, without consulting connected data sources, for a chat request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin controls and
     *         guardrails</a>, <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>, and <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
     *         >Conversation settings</a>.
     * @see ChatMode
     */
    public final String chatModeAsString() {
        return chatMode;
    }

    /**
     * Returns the value of the ChatModeConfiguration property for this object.
     * 
     * @return The value of the ChatModeConfiguration property for this object.
     */
    public final ChatModeConfiguration chatModeConfiguration() {
        return chatModeConfiguration;
    }

    /**
     * Returns the value of the AttributeFilter property for this object.
     * 
     * @return The value of the AttributeFilter property for this object.
     */
    public final AttributeFilter attributeFilter() {
        return attributeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chatModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(chatModeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent) obj;
        return Objects.equals(chatModeAsString(), other.chatModeAsString())
                && Objects.equals(chatModeConfiguration(), other.chatModeConfiguration())
                && Objects.equals(attributeFilter(), other.attributeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationEvent").add("ChatMode", chatModeAsString())
                .add("ChatModeConfiguration", chatModeConfiguration()).add("AttributeFilter", attributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chatMode":
            return Optional.ofNullable(clazz.cast(chatModeAsString()));
        case "chatModeConfiguration":
            return Optional.ofNullable(clazz.cast(chatModeConfiguration()));
        case "attributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chatMode", CHAT_MODE_FIELD);
        map.put("chatModeConfiguration", CHAT_MODE_CONFIGURATION_FIELD);
        map.put("attributeFilter", ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationEvent> {
        /**
         * <p>
         * The chat modes available to an Amazon Q Business end user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this mode is
         * enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business
         * application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from the LLM
         * knowledge, without consulting connected data sources, for a chat request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin controls and
         * guardrails</a>, <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>,
         * and <a href=
         * "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
         * >Conversation settings</a>.
         * </p>
         * 
         * @param chatMode
         *        The chat modes available to an Amazon Q Business end user.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this
         *        mode is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q
         *        Business application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from
         *        the LLM knowledge, without consulting connected data sources, for a chat request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin controls and
         *        guardrails</a>, <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>, and <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
         *        >Conversation settings</a>.
         * @see ChatMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatMode
         */
        Builder chatMode(String chatMode);

        /**
         * <p>
         * The chat modes available to an Amazon Q Business end user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this mode is
         * enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q Business
         * application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from the LLM
         * knowledge, without consulting connected data sources, for a chat request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin controls and
         * guardrails</a>, <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>,
         * and <a href=
         * "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
         * >Conversation settings</a>.
         * </p>
         * 
         * @param chatMode
         *        The chat modes available to an Amazon Q Business end user.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RETRIEVAL_MODE</code> - The default chat mode for an Amazon Q Business application. When this
         *        mode is enabled, Amazon Q Business generates responses only from data sources connected to an Amazon Q
         *        Business application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATOR_MODE</code> - By selecting this mode, users can choose to generate responses only from
         *        the LLM knowledge, without consulting connected data sources, for a chat request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLUGIN_MODE</code> - By selecting this mode, users can choose to use plugins in chat.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html">Admin controls and
         *        guardrails</a>, <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html">Plugins</a>, and <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope"
         *        >Conversation settings</a>.
         * @see ChatMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatMode
         */
        Builder chatMode(ChatMode chatMode);

        /**
         * Sets the value of the ChatModeConfiguration property for this object.
         *
         * @param chatModeConfiguration
         *        The new value for the ChatModeConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatModeConfiguration(ChatModeConfiguration chatModeConfiguration);

        /**
         * Sets the value of the ChatModeConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChatModeConfiguration.Builder} avoiding
         * the need to create one manually via {@link ChatModeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatModeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #chatModeConfiguration(ChatModeConfiguration)}.
         * 
         * @param chatModeConfiguration
         *        a consumer that will call methods on {@link ChatModeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatModeConfiguration(ChatModeConfiguration)
         */
        default Builder chatModeConfiguration(Consumer<ChatModeConfiguration.Builder> chatModeConfiguration) {
            return chatModeConfiguration(ChatModeConfiguration.builder().applyMutation(chatModeConfiguration).build());
        }

        /**
         * Sets the value of the AttributeFilter property for this object.
         *
         * @param attributeFilter
         *        The new value for the AttributeFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(AttributeFilter attributeFilter);

        /**
         * Sets the value of the AttributeFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeFilter(AttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(AttributeFilter)
         */
        default Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return attributeFilter(AttributeFilter.builder().applyMutation(attributeFilter).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String chatMode;

        private ChatModeConfiguration chatModeConfiguration;

        private AttributeFilter attributeFilter;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConfigurationEvent model) {
            chatMode(model.chatMode);
            chatModeConfiguration(model.chatModeConfiguration);
            attributeFilter(model.attributeFilter);
        }

        public final String getChatMode() {
            return chatMode;
        }

        public final void setChatMode(String chatMode) {
            this.chatMode = chatMode;
        }

        @Override
        public final Builder chatMode(String chatMode) {
            this.chatMode = chatMode;
            return this;
        }

        @Override
        public final Builder chatMode(ChatMode chatMode) {
            this.chatMode(chatMode == null ? null : chatMode.toString());
            return this;
        }

        public final ChatModeConfiguration.Builder getChatModeConfiguration() {
            return chatModeConfiguration != null ? chatModeConfiguration.toBuilder() : null;
        }

        public final void setChatModeConfiguration(ChatModeConfiguration.BuilderImpl chatModeConfiguration) {
            this.chatModeConfiguration = chatModeConfiguration != null ? chatModeConfiguration.build() : null;
        }

        @Override
        public final Builder chatModeConfiguration(ChatModeConfiguration chatModeConfiguration) {
            this.chatModeConfiguration = chatModeConfiguration;
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        @Override
        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
