/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Rules for retrieving content from data sources connected to a Amazon Q Business application for a specific topic
 * control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentRetrievalRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentRetrievalRule.Builder, ContentRetrievalRule> {
    private static final SdkField<List<EligibleDataSource>> ELIGIBLE_DATA_SOURCES_FIELD = SdkField
            .<List<EligibleDataSource>> builder(MarshallingType.LIST)
            .memberName("eligibleDataSources")
            .getter(getter(ContentRetrievalRule::eligibleDataSources))
            .setter(setter(Builder::eligibleDataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eligibleDataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EligibleDataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(EligibleDataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELIGIBLE_DATA_SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EligibleDataSource> eligibleDataSources;

    private ContentRetrievalRule(BuilderImpl builder) {
        this.eligibleDataSources = builder.eligibleDataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the EligibleDataSources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEligibleDataSources() {
        return eligibleDataSources != null && !(eligibleDataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies data sources in a Amazon Q Business application to use for content generation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEligibleDataSources} method.
     * </p>
     * 
     * @return Specifies data sources in a Amazon Q Business application to use for content generation.
     */
    public final List<EligibleDataSource> eligibleDataSources() {
        return eligibleDataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEligibleDataSources() ? eligibleDataSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentRetrievalRule)) {
            return false;
        }
        ContentRetrievalRule other = (ContentRetrievalRule) obj;
        return hasEligibleDataSources() == other.hasEligibleDataSources()
                && Objects.equals(eligibleDataSources(), other.eligibleDataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentRetrievalRule")
                .add("EligibleDataSources", hasEligibleDataSources() ? eligibleDataSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eligibleDataSources":
            return Optional.ofNullable(clazz.cast(eligibleDataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eligibleDataSources", ELIGIBLE_DATA_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentRetrievalRule, T> g) {
        return obj -> g.apply((ContentRetrievalRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentRetrievalRule> {
        /**
         * <p>
         * Specifies data sources in a Amazon Q Business application to use for content generation.
         * </p>
         * 
         * @param eligibleDataSources
         *        Specifies data sources in a Amazon Q Business application to use for content generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eligibleDataSources(Collection<EligibleDataSource> eligibleDataSources);

        /**
         * <p>
         * Specifies data sources in a Amazon Q Business application to use for content generation.
         * </p>
         * 
         * @param eligibleDataSources
         *        Specifies data sources in a Amazon Q Business application to use for content generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eligibleDataSources(EligibleDataSource... eligibleDataSources);

        /**
         * <p>
         * Specifies data sources in a Amazon Q Business application to use for content generation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.EligibleDataSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.EligibleDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.EligibleDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #eligibleDataSources(List<EligibleDataSource>)}.
         * 
         * @param eligibleDataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.EligibleDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eligibleDataSources(java.util.Collection<EligibleDataSource>)
         */
        Builder eligibleDataSources(Consumer<EligibleDataSource.Builder>... eligibleDataSources);
    }

    static final class BuilderImpl implements Builder {
        private List<EligibleDataSource> eligibleDataSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentRetrievalRule model) {
            eligibleDataSources(model.eligibleDataSources);
        }

        public final List<EligibleDataSource.Builder> getEligibleDataSources() {
            List<EligibleDataSource.Builder> result = EligibleDataSourcesCopier.copyToBuilder(this.eligibleDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEligibleDataSources(Collection<EligibleDataSource.BuilderImpl> eligibleDataSources) {
            this.eligibleDataSources = EligibleDataSourcesCopier.copyFromBuilder(eligibleDataSources);
        }

        @Override
        public final Builder eligibleDataSources(Collection<EligibleDataSource> eligibleDataSources) {
            this.eligibleDataSources = EligibleDataSourcesCopier.copy(eligibleDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eligibleDataSources(EligibleDataSource... eligibleDataSources) {
            eligibleDataSources(Arrays.asList(eligibleDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eligibleDataSources(Consumer<EligibleDataSource.Builder>... eligibleDataSources) {
            eligibleDataSources(Stream.of(eligibleDataSources).map(c -> EligibleDataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContentRetrievalRule build() {
            return new ContentRetrievalRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
