/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIndexRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateIndexRequest.Builder, CreateIndexRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateIndexRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateIndexRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateIndexRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateIndexRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IndexCapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField
            .<IndexCapacityConfiguration> builder(MarshallingType.SDK_POJO).memberName("capacityConfiguration")
            .getter(getter(CreateIndexRequest::capacityConfiguration)).setter(setter(Builder::capacityConfiguration))
            .constructor(IndexCapacityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateIndexRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, TAGS_FIELD, CAPACITY_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String displayName;

    private final String description;

    private final String type;

    private final List<Tag> tags;

    private final IndexCapacityConfiguration capacityConfiguration;

    private final String clientToken;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.type = builder.type;
        this.tags = builder.tags;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application using the index.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application using the index.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A name for the Amazon Q Business index.
     * </p>
     * 
     * @return A name for the Amazon Q Business index.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A description for the Amazon Q Business index.
     * </p>
     * 
     * @return A description for the Amazon Q Business index.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The index type that's suitable for your needs. For more information on what's included in each type of index, see
     * <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q Business
     * tiers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The index type that's suitable for your needs. For more information on what's included in each type of
     *         index, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q Business
     *         tiers</a>.
     * @see IndexType
     */
    public final IndexType type() {
        return IndexType.fromValue(type);
    }

    /**
     * <p>
     * The index type that's suitable for your needs. For more information on what's included in each type of index, see
     * <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q Business
     * tiers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The index type that's suitable for your needs. For more information on what's included in each type of
     *         index, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q Business
     *         tiers</a>.
     * @see IndexType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to
     * the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following
     * symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize the index. You can also use tags to help control
     *         access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of
     *         the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
     * </p>
     * 
     * @return The capacity units you want to provision for your index. You can add and remove capacity to fit your
     *         usage needs.
     */
    public final IndexCapacityConfiguration capacityConfiguration() {
        return capacityConfiguration;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create an index. Multiple calls to the
     * <code>CreateIndex</code> API with the same client token will create only one index.
     * </p>
     * 
     * @return A token that you provide to identify the request to create an index. Multiple calls to the
     *         <code>CreateIndex</code> API with the same client token will create only one index.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(capacityConfiguration(), other.capacityConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIndexRequest").add("ApplicationId", applicationId()).add("DisplayName", displayName())
                .add("Description", description()).add("Type", typeAsString()).add("Tags", hasTags() ? tags() : null)
                .add("CapacityConfiguration", capacityConfiguration()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "capacityConfiguration":
            return Optional.ofNullable(clazz.cast(capacityConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("capacityConfiguration", CAPACITY_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIndexRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application using the index.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application using the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A name for the Amazon Q Business index.
         * </p>
         * 
         * @param displayName
         *        A name for the Amazon Q Business index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A description for the Amazon Q Business index.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Q Business index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The index type that's suitable for your needs. For more information on what's included in each type of index,
         * see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q
         * Business tiers</a>.
         * </p>
         * 
         * @param type
         *        The index type that's suitable for your needs. For more information on what's included in each type of
         *        index, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q
         *        Business tiers</a>.
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(String type);

        /**
         * <p>
         * The index type that's suitable for your needs. For more information on what's included in each type of index,
         * see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q
         * Business tiers</a>.
         * </p>
         * 
         * @param type
         *        The index type that's suitable for your needs. For more information on what's included in each type of
         *        index, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers">Amazon Q
         *        Business tiers</a>.
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(IndexType type);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access
         * to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the
         * following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the index. You can also use tags to help control
         *        access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any
         *        of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access
         * to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the
         * following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the index. You can also use tags to help control
         *        access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any
         *        of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the index. You can also use tags to help control access
         * to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the
         * following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The capacity units you want to provision for your index. You can add and remove capacity to fit your usage
         * needs.
         * </p>
         * 
         * @param capacityConfiguration
         *        The capacity units you want to provision for your index. You can add and remove capacity to fit your
         *        usage needs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration);

        /**
         * <p>
         * The capacity units you want to provision for your index. You can add and remove capacity to fit your usage
         * needs.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexCapacityConfiguration.Builder}
         * avoiding the need to create one manually via {@link IndexCapacityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexCapacityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityConfiguration(IndexCapacityConfiguration)}.
         * 
         * @param capacityConfiguration
         *        a consumer that will call methods on {@link IndexCapacityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityConfiguration(IndexCapacityConfiguration)
         */
        default Builder capacityConfiguration(Consumer<IndexCapacityConfiguration.Builder> capacityConfiguration) {
            return capacityConfiguration(IndexCapacityConfiguration.builder().applyMutation(capacityConfiguration).build());
        }

        /**
         * <p>
         * A token that you provide to identify the request to create an index. Multiple calls to the
         * <code>CreateIndex</code> API with the same client token will create only one index.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create an index. Multiple calls to the
         *        <code>CreateIndex</code> API with the same client token will create only one index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String displayName;

        private String description;

        private String type;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private IndexCapacityConfiguration capacityConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            applicationId(model.applicationId);
            displayName(model.displayName);
            description(model.description);
            type(model.type);
            tags(model.tags);
            capacityConfiguration(model.capacityConfiguration);
            clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IndexType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final IndexCapacityConfiguration.Builder getCapacityConfiguration() {
            return capacityConfiguration != null ? capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(IndexCapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
