/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePluginResponse extends QBusinessResponse implements
        ToCopyableBuilder<CreatePluginResponse.Builder, CreatePluginResponse> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(CreatePluginResponse::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final SdkField<String> PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginArn").getter(getter(CreatePluginResponse::pluginArn)).setter(setter(Builder::pluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginArn").build()).build();

    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildStatus").getter(getter(CreatePluginResponse::buildStatusAsString))
            .setter(setter(Builder::buildStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD,
            PLUGIN_ARN_FIELD, BUILD_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pluginId;

    private final String pluginArn;

    private final String buildStatus;

    private CreatePluginResponse(BuilderImpl builder) {
        super(builder);
        this.pluginId = builder.pluginId;
        this.pluginArn = builder.pluginArn;
        this.buildStatus = builder.buildStatus;
    }

    /**
     * <p>
     * The identifier of the plugin created.
     * </p>
     * 
     * @return The identifier of the plugin created.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a plugin.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a plugin.
     */
    public final String pluginArn() {
        return pluginArn;
    }

    /**
     * <p>
     * The current status of a plugin. A plugin is modified asynchronously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildStatus} will
     * return {@link PluginBuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buildStatusAsString}.
     * </p>
     * 
     * @return The current status of a plugin. A plugin is modified asynchronously.
     * @see PluginBuildStatus
     */
    public final PluginBuildStatus buildStatus() {
        return PluginBuildStatus.fromValue(buildStatus);
    }

    /**
     * <p>
     * The current status of a plugin. A plugin is modified asynchronously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildStatus} will
     * return {@link PluginBuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buildStatusAsString}.
     * </p>
     * 
     * @return The current status of a plugin. A plugin is modified asynchronously.
     * @see PluginBuildStatus
     */
    public final String buildStatusAsString() {
        return buildStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(pluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePluginResponse)) {
            return false;
        }
        CreatePluginResponse other = (CreatePluginResponse) obj;
        return Objects.equals(pluginId(), other.pluginId()) && Objects.equals(pluginArn(), other.pluginArn())
                && Objects.equals(buildStatusAsString(), other.buildStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePluginResponse").add("PluginId", pluginId()).add("PluginArn", pluginArn())
                .add("BuildStatus", buildStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "pluginArn":
            return Optional.ofNullable(clazz.cast(pluginArn()));
        case "buildStatus":
            return Optional.ofNullable(clazz.cast(buildStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("pluginArn", PLUGIN_ARN_FIELD);
        map.put("buildStatus", BUILD_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePluginResponse, T> g) {
        return obj -> g.apply((CreatePluginResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePluginResponse> {
        /**
         * <p>
         * The identifier of the plugin created.
         * </p>
         * 
         * @param pluginId
         *        The identifier of the plugin created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a plugin.
         * </p>
         * 
         * @param pluginArn
         *        The Amazon Resource Name (ARN) of a plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginArn(String pluginArn);

        /**
         * <p>
         * The current status of a plugin. A plugin is modified asynchronously.
         * </p>
         * 
         * @param buildStatus
         *        The current status of a plugin. A plugin is modified asynchronously.
         * @see PluginBuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginBuildStatus
         */
        Builder buildStatus(String buildStatus);

        /**
         * <p>
         * The current status of a plugin. A plugin is modified asynchronously.
         * </p>
         * 
         * @param buildStatus
         *        The current status of a plugin. A plugin is modified asynchronously.
         * @see PluginBuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginBuildStatus
         */
        Builder buildStatus(PluginBuildStatus buildStatus);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String pluginId;

        private String pluginArn;

        private String buildStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePluginResponse model) {
            super(model);
            pluginId(model.pluginId);
            pluginArn(model.pluginArn);
            buildStatus(model.buildStatus);
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getPluginArn() {
            return pluginArn;
        }

        public final void setPluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
        }

        @Override
        public final Builder pluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        public final String getBuildStatus() {
            return buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(PluginBuildStatus buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        @Override
        public CreatePluginResponse build() {
            return new CreatePluginResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
