/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRetrieverRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateRetrieverRequest.Builder, CreateRetrieverRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateRetrieverRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateRetrieverRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateRetrieverRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<RetrieverConfiguration> CONFIGURATION_FIELD = SdkField
            .<RetrieverConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateRetrieverRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RetrieverConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateRetrieverRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateRetrieverRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRetrieverRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            TYPE_FIELD, DISPLAY_NAME_FIELD, CONFIGURATION_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String type;

    private final String displayName;

    private final RetrieverConfiguration configuration;

    private final String roleArn;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateRetrieverRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.type = builder.type;
        this.displayName = builder.displayName;
        this.configuration = builder.configuration;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of your Amazon Q Business application.
     * </p>
     * 
     * @return The identifier of your Amazon Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The type of retriever you are using.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of retriever you are using.
     * @see RetrieverType
     */
    public final RetrieverType type() {
        return RetrieverType.fromValue(type);
    }

    /**
     * <p>
     * The type of retriever you are using.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of retriever you are using.
     * @see RetrieverType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of your retriever.
     * </p>
     * 
     * @return The name of your retriever.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the Configuration property for this object.
     * 
     * @return The value of the Configuration property for this object.
     */
    public final RetrieverConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a
     * Secrets Manager secret.
     * </p>
     * 
     * @return The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in
     *         a Secrets Manager secret.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create your Amazon Q Business application retriever.
     * </p>
     * 
     * @return A token that you provide to identify the request to create your Amazon Q Business application retriever.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control access
     * to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of the
     * following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize the retriever. You can also use tags to help
     *         control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space,
     *         and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRetrieverRequest)) {
            return false;
        }
        CreateRetrieverRequest other = (CreateRetrieverRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRetrieverRequest").add("ApplicationId", applicationId()).add("Type", typeAsString())
                .add("DisplayName", displayName()).add("Configuration", configuration()).add("RoleArn", roleArn())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRetrieverRequest, T> g) {
        return obj -> g.apply((CreateRetrieverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRetrieverRequest> {
        /**
         * <p>
         * The identifier of your Amazon Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The type of retriever you are using.
         * </p>
         * 
         * @param type
         *        The type of retriever you are using.
         * @see RetrieverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of retriever you are using.
         * </p>
         * 
         * @param type
         *        The type of retriever you are using.
         * @see RetrieverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverType
         */
        Builder type(RetrieverType type);

        /**
         * <p>
         * The name of your retriever.
         * </p>
         * 
         * @param displayName
         *        The name of your retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * @param configuration
         *        The new value for the Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RetrieverConfiguration configuration);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetrieverConfiguration.Builder} avoiding
         * the need to create one manually via {@link RetrieverConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieverConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(RetrieverConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RetrieverConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RetrieverConfiguration)
         */
        default Builder configuration(Consumer<RetrieverConfiguration.Builder> configuration) {
            return configuration(RetrieverConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a
         * Secrets Manager secret.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored
         *        in a Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A token that you provide to identify the request to create your Amazon Q Business application retriever.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create your Amazon Q Business application
         *        retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control
         * access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of
         * the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the retriever. You can also use tags to help
         *        control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white
         *        space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control
         * access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of
         * the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the retriever. You can also use tags to help
         *        control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white
         *        space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control
         * access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of
         * the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String type;

        private String displayName;

        private RetrieverConfiguration configuration;

        private String roleArn;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRetrieverRequest model) {
            super(model);
            applicationId(model.applicationId);
            type(model.type);
            displayName(model.displayName);
            configuration(model.configuration);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final RetrieverConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RetrieverConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RetrieverConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRetrieverRequest build() {
            return new CreateRetrieverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
