/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRetrieverResponse extends QBusinessResponse implements
        ToCopyableBuilder<CreateRetrieverResponse.Builder, CreateRetrieverResponse> {
    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverId").getter(getter(CreateRetrieverResponse::retrieverId)).setter(setter(Builder::retrieverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverId").build()).build();

    private static final SdkField<String> RETRIEVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverArn").getter(getter(CreateRetrieverResponse::retrieverArn))
            .setter(setter(Builder::retrieverArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVER_ID_FIELD,
            RETRIEVER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String retrieverId;

    private final String retrieverArn;

    private CreateRetrieverResponse(BuilderImpl builder) {
        super(builder);
        this.retrieverId = builder.retrieverId;
        this.retrieverArn = builder.retrieverArn;
    }

    /**
     * <p>
     * The identifier of the retriever you are using.
     * </p>
     * 
     * @return The identifier of the retriever you are using.
     */
    public final String retrieverId() {
        return retrieverId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role associated with a retriever.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role associated with a retriever.
     */
    public final String retrieverArn() {
        return retrieverArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(retrieverArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRetrieverResponse)) {
            return false;
        }
        CreateRetrieverResponse other = (CreateRetrieverResponse) obj;
        return Objects.equals(retrieverId(), other.retrieverId()) && Objects.equals(retrieverArn(), other.retrieverArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRetrieverResponse").add("RetrieverId", retrieverId()).add("RetrieverArn", retrieverArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retrieverId":
            return Optional.ofNullable(clazz.cast(retrieverId()));
        case "retrieverArn":
            return Optional.ofNullable(clazz.cast(retrieverArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("retrieverId", RETRIEVER_ID_FIELD);
        map.put("retrieverArn", RETRIEVER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRetrieverResponse, T> g) {
        return obj -> g.apply((CreateRetrieverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRetrieverResponse> {
        /**
         * <p>
         * The identifier of the retriever you are using.
         * </p>
         * 
         * @param retrieverId
         *        The identifier of the retriever you are using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverId(String retrieverId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role associated with a retriever.
         * </p>
         * 
         * @param retrieverArn
         *        The Amazon Resource Name (ARN) of an IAM role associated with a retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverArn(String retrieverArn);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String retrieverId;

        private String retrieverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRetrieverResponse model) {
            super(model);
            retrieverId(model.retrieverId);
            retrieverArn(model.retrieverArn);
        }

        public final String getRetrieverId() {
            return retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final String getRetrieverArn() {
            return retrieverArn;
        }

        public final void setRetrieverArn(String retrieverArn) {
            this.retrieverArn = retrieverArn;
        }

        @Override
        public final Builder retrieverArn(String retrieverArn) {
            this.retrieverArn = retrieverArn;
            return this;
        }

        @Override
        public CreateRetrieverResponse build() {
            return new CreateRetrieverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
