/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a data accessor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataAccessor implements SdkPojo, Serializable, ToCopyableBuilder<DataAccessor.Builder, DataAccessor> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(DataAccessor::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DATA_ACCESSOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorId").getter(getter(DataAccessor::dataAccessorId)).setter(setter(Builder::dataAccessorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorId").build()).build();

    private static final SdkField<String> DATA_ACCESSOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorArn").getter(getter(DataAccessor::dataAccessorArn)).setter(setter(Builder::dataAccessorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorArn").build()).build();

    private static final SdkField<String> IDC_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idcApplicationArn").getter(getter(DataAccessor::idcApplicationArn))
            .setter(setter(Builder::idcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcApplicationArn").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(DataAccessor::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DataAccessor::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(DataAccessor::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            DATA_ACCESSOR_ID_FIELD, DATA_ACCESSOR_ARN_FIELD, IDC_APPLICATION_ARN_FIELD, PRINCIPAL_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayName;

    private final String dataAccessorId;

    private final String dataAccessorArn;

    private final String idcApplicationArn;

    private final String principal;

    private final Instant createdAt;

    private final Instant updatedAt;

    private DataAccessor(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.dataAccessorId = builder.dataAccessorId;
        this.dataAccessorArn = builder.dataAccessorArn;
        this.idcApplicationArn = builder.idcApplicationArn;
        this.principal = builder.principal;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The friendly name of the data accessor.
     * </p>
     * 
     * @return The friendly name of the data accessor.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The unique identifier of the data accessor.
     * </p>
     * 
     * @return The unique identifier of the data accessor.
     */
    public final String dataAccessorId() {
        return dataAccessorId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data accessor.
     */
    public final String dataAccessorArn() {
        return dataAccessorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the associated AWS IAM Identity Center application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the associated AWS IAM Identity Center application.
     */
    public final String idcApplicationArn() {
        return idcApplicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * The timestamp when the data accessor was created.
     * </p>
     * 
     * @return The timestamp when the data accessor was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the data accessor was last updated.
     * </p>
     * 
     * @return The timestamp when the data accessor was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(idcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAccessor)) {
            return false;
        }
        DataAccessor other = (DataAccessor) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(dataAccessorId(), other.dataAccessorId())
                && Objects.equals(dataAccessorArn(), other.dataAccessorArn())
                && Objects.equals(idcApplicationArn(), other.idcApplicationArn())
                && Objects.equals(principal(), other.principal()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataAccessor")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataAccessorId", dataAccessorId()).add("DataAccessorArn", dataAccessorArn())
                .add("IdcApplicationArn", idcApplicationArn()).add("Principal", principal()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "dataAccessorId":
            return Optional.ofNullable(clazz.cast(dataAccessorId()));
        case "dataAccessorArn":
            return Optional.ofNullable(clazz.cast(dataAccessorArn()));
        case "idcApplicationArn":
            return Optional.ofNullable(clazz.cast(idcApplicationArn()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("dataAccessorId", DATA_ACCESSOR_ID_FIELD);
        map.put("dataAccessorArn", DATA_ACCESSOR_ARN_FIELD);
        map.put("idcApplicationArn", IDC_APPLICATION_ARN_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAccessor, T> g) {
        return obj -> g.apply((DataAccessor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataAccessor> {
        /**
         * <p>
         * The friendly name of the data accessor.
         * </p>
         * 
         * @param displayName
         *        The friendly name of the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The unique identifier of the data accessor.
         * </p>
         * 
         * @param dataAccessorId
         *        The unique identifier of the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorId(String dataAccessorId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data accessor.
         * </p>
         * 
         * @param dataAccessorArn
         *        The Amazon Resource Name (ARN) of the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorArn(String dataAccessorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the associated AWS IAM Identity Center application.
         * </p>
         * 
         * @param idcApplicationArn
         *        The Amazon Resource Name (ARN) of the associated AWS IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcApplicationArn(String idcApplicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
         * </p>
         * 
         * @param principal
         *        The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The timestamp when the data accessor was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the data accessor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the data accessor was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the data accessor was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String displayName;

        private String dataAccessorId;

        private String dataAccessorArn;

        private String idcApplicationArn;

        private String principal;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAccessor model) {
            displayName(model.displayName);
            dataAccessorId(model.dataAccessorId);
            dataAccessorArn(model.dataAccessorArn);
            idcApplicationArn(model.idcApplicationArn);
            principal(model.principal);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDataAccessorId() {
            return dataAccessorId;
        }

        public final void setDataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
        }

        @Override
        public final Builder dataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        public final String getDataAccessorArn() {
            return dataAccessorArn;
        }

        public final void setDataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
        }

        @Override
        public final Builder dataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
            return this;
        }

        public final String getIdcApplicationArn() {
            return idcApplicationArn;
        }

        public final void setIdcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
        }

        @Override
        public final Builder idcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DataAccessor build() {
            return new DataAccessor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
