/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A document in an Amazon Q Business application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Document implements SdkPojo, Serializable, ToCopyableBuilder<Document.Builder, Document> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Document::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<DocumentAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(Document::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DocumentContent> CONTENT_FIELD = SdkField.<DocumentContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(Document::content)).setter(setter(Builder::content))
            .constructor(DocumentContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(Document::contentTypeAsString)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Document::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField
            .<AccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("accessConfiguration")
            .getter(getter(Document::accessConfiguration)).setter(setter(Builder::accessConfiguration))
            .constructor(AccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessConfiguration").build())
            .build();

    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<DocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("documentEnrichmentConfiguration")
            .getter(getter(Document::documentEnrichmentConfiguration))
            .setter(setter(Builder::documentEnrichmentConfiguration))
            .constructor(DocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration")
                    .build()).build();

    private static final SdkField<MediaExtractionConfiguration> MEDIA_EXTRACTION_CONFIGURATION_FIELD = SdkField
            .<MediaExtractionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("mediaExtractionConfiguration")
            .getter(getter(Document::mediaExtractionConfiguration))
            .setter(setter(Builder::mediaExtractionConfiguration))
            .constructor(MediaExtractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaExtractionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTRIBUTES_FIELD,
            CONTENT_FIELD, CONTENT_TYPE_FIELD, TITLE_FIELD, ACCESS_CONFIGURATION_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD,
            MEDIA_EXTRACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<DocumentAttribute> attributes;

    private final DocumentContent content;

    private final String contentType;

    private final String title;

    private final AccessConfiguration accessConfiguration;

    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private final MediaExtractionConfiguration mediaExtractionConfiguration;

    private Document(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.title = builder.title;
        this.accessConfiguration = builder.accessConfiguration;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.mediaExtractionConfiguration = builder.mediaExtractionConfiguration;
    }

    /**
     * <p>
     * The identifier of the document.
     * </p>
     * 
     * @return The identifier of the document.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
     */
    public final List<DocumentAttribute> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The contents of the document.
     * </p>
     * 
     * @return The contents of the document.
     */
    public final DocumentContent content() {
        return content;
    }

    /**
     * <p>
     * The file type of the document in the Blob field.
     * </p>
     * <p>
     * If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you add
     * the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The file type of the document in the Blob field.</p>
     *         <p>
     *         If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents,
     *         you add the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>)
     *         around the content.
     * @see ContentType
     */
    public final ContentType contentType() {
        return ContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The file type of the document in the Blob field.
     * </p>
     * <p>
     * If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you add
     * the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The file type of the document in the Blob field.</p>
     *         <p>
     *         If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents,
     *         you add the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>)
     *         around the content.
     * @see ContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * The title of the document.
     * </p>
     * 
     * @return The title of the document.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Configuration information for access permission to a document.
     * </p>
     * 
     * @return Configuration information for access permission to a document.
     */
    public final AccessConfiguration accessConfiguration() {
        return accessConfiguration;
    }

    /**
     * <p>
     * The configuration information for altering document metadata and content during the document ingestion process.
     * </p>
     * 
     * @return The configuration information for altering document metadata and content during the document ingestion
     *         process.
     */
    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return documentEnrichmentConfiguration;
    }

    /**
     * <p>
     * The configuration for extracting information from media in the document.
     * </p>
     * 
     * @return The configuration for extracting information from media in the document.
     */
    public final MediaExtractionConfiguration mediaExtractionConfiguration() {
        return mediaExtractionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(mediaExtractionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document) obj;
        return Objects.equals(id(), other.id()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(content(), other.content())
                && Objects.equals(contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(title(), other.title())
                && Objects.equals(accessConfiguration(), other.accessConfiguration())
                && Objects.equals(documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration())
                && Objects.equals(mediaExtractionConfiguration(), other.mediaExtractionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Document").add("Id", id()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("Content", content()).add("ContentType", contentTypeAsString()).add("Title", title())
                .add("AccessConfiguration", accessConfiguration())
                .add("DocumentEnrichmentConfiguration", documentEnrichmentConfiguration())
                .add("MediaExtractionConfiguration", mediaExtractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "accessConfiguration":
            return Optional.ofNullable(clazz.cast(accessConfiguration()));
        case "documentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(documentEnrichmentConfiguration()));
        case "mediaExtractionConfiguration":
            return Optional.ofNullable(clazz.cast(mediaExtractionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("accessConfiguration", ACCESS_CONFIGURATION_FIELD);
        map.put("documentEnrichmentConfiguration", DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD);
        map.put("mediaExtractionConfiguration", MEDIA_EXTRACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Document> {
        /**
         * <p>
         * The identifier of the document.
         * </p>
         * 
         * @param id
         *        The identifier of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
         * </p>
         * 
         * @param attributes
         *        Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<DocumentAttribute> attributes);

        /**
         * <p>
         * Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
         * </p>
         * 
         * @param attributes
         *        Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(DocumentAttribute... attributes);

        /**
         * <p>
         * Custom attributes to apply to the document for refining Amazon Q Business web experience responses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<DocumentAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<DocumentAttribute>)
         */
        Builder attributes(Consumer<DocumentAttribute.Builder>... attributes);

        /**
         * <p>
         * The contents of the document.
         * </p>
         * 
         * @param content
         *        The contents of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(DocumentContent content);

        /**
         * <p>
         * The contents of the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentContent.Builder} avoiding the
         * need to create one manually via {@link DocumentContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(DocumentContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link DocumentContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(DocumentContent)
         */
        default Builder content(Consumer<DocumentContent.Builder> content) {
            return content(DocumentContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The file type of the document in the Blob field.
         * </p>
         * <p>
         * If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you
         * add the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the
         * content.
         * </p>
         * 
         * @param contentType
         *        The file type of the document in the Blob field.</p>
         *        <p>
         *        If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML
         *        documents, you add the <code>HTML</code> start and closing tags (
         *        <code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the content.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The file type of the document in the Blob field.
         * </p>
         * <p>
         * If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you
         * add the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the
         * content.
         * </p>
         * 
         * @param contentType
         *        The file type of the document in the Blob field.</p>
         *        <p>
         *        If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML
         *        documents, you add the <code>HTML</code> start and closing tags (
         *        <code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the content.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(ContentType contentType);

        /**
         * <p>
         * The title of the document.
         * </p>
         * 
         * @param title
         *        The title of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Configuration information for access permission to a document.
         * </p>
         * 
         * @param accessConfiguration
         *        Configuration information for access permission to a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessConfiguration(AccessConfiguration accessConfiguration);

        /**
         * <p>
         * Configuration information for access permission to a document.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessConfiguration.Builder} avoiding the
         * need to create one manually via {@link AccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #accessConfiguration(AccessConfiguration)}.
         * 
         * @param accessConfiguration
         *        a consumer that will call methods on {@link AccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessConfiguration(AccessConfiguration)
         */
        default Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return accessConfiguration(AccessConfiguration.builder().applyMutation(accessConfiguration).build());
        }

        /**
         * <p>
         * The configuration information for altering document metadata and content during the document ingestion
         * process.
         * </p>
         * 
         * @param documentEnrichmentConfiguration
         *        The configuration information for altering document metadata and content during the document ingestion
         *        process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration);

        /**
         * <p>
         * The configuration information for altering document metadata and content during the document ingestion
         * process.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentEnrichmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)}.
         * 
         * @param documentEnrichmentConfiguration
         *        a consumer that will call methods on {@link DocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)
         */
        default Builder documentEnrichmentConfiguration(
                Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return documentEnrichmentConfiguration(DocumentEnrichmentConfiguration.builder()
                    .applyMutation(documentEnrichmentConfiguration).build());
        }

        /**
         * <p>
         * The configuration for extracting information from media in the document.
         * </p>
         * 
         * @param mediaExtractionConfiguration
         *        The configuration for extracting information from media in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration);

        /**
         * <p>
         * The configuration for extracting information from media in the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaExtractionConfiguration.Builder}
         * avoiding the need to create one manually via {@link MediaExtractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaExtractionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaExtractionConfiguration(MediaExtractionConfiguration)}.
         * 
         * @param mediaExtractionConfiguration
         *        a consumer that will call methods on {@link MediaExtractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaExtractionConfiguration(MediaExtractionConfiguration)
         */
        default Builder mediaExtractionConfiguration(Consumer<MediaExtractionConfiguration.Builder> mediaExtractionConfiguration) {
            return mediaExtractionConfiguration(MediaExtractionConfiguration.builder()
                    .applyMutation(mediaExtractionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<DocumentAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private DocumentContent content;

        private String contentType;

        private String title;

        private AccessConfiguration accessConfiguration;

        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private MediaExtractionConfiguration mediaExtractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            id(model.id);
            attributes(model.attributes);
            content(model.content);
            contentType(model.contentType);
            title(model.title);
            accessConfiguration(model.accessConfiguration);
            documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            mediaExtractionConfiguration(model.mediaExtractionConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<DocumentAttribute.Builder> getAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<DocumentAttribute.BuilderImpl> attributes) {
            this.attributes = DocumentAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<DocumentAttribute> attributes) {
            this.attributes = DocumentAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(DocumentAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<DocumentAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DocumentContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(DocumentContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(DocumentContent content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return accessConfiguration != null ? accessConfiguration.toBuilder() : null;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(
                DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final MediaExtractionConfiguration.Builder getMediaExtractionConfiguration() {
            return mediaExtractionConfiguration != null ? mediaExtractionConfiguration.toBuilder() : null;
        }

        public final void setMediaExtractionConfiguration(MediaExtractionConfiguration.BuilderImpl mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration != null ? mediaExtractionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration;
            return this;
        }

        @Override
        public Document build() {
            return new Document(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
