/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for altering document metadata and content during the document ingestion
 * process.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document
 * enrichment</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentEnrichmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentEnrichmentConfiguration.Builder, DocumentEnrichmentConfiguration> {
    private static final SdkField<List<InlineDocumentEnrichmentConfiguration>> INLINE_CONFIGURATIONS_FIELD = SdkField
            .<List<InlineDocumentEnrichmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("inlineConfigurations")
            .getter(getter(DocumentEnrichmentConfiguration::inlineConfigurations))
            .setter(setter(Builder::inlineConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InlineDocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(InlineDocumentEnrichmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HookConfiguration> PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField
            .<HookConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("preExtractionHookConfiguration")
            .getter(getter(DocumentEnrichmentConfiguration::preExtractionHookConfiguration))
            .setter(setter(Builder::preExtractionHookConfiguration))
            .constructor(HookConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preExtractionHookConfiguration")
                    .build()).build();

    private static final SdkField<HookConfiguration> POST_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField
            .<HookConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("postExtractionHookConfiguration")
            .getter(getter(DocumentEnrichmentConfiguration::postExtractionHookConfiguration))
            .setter(setter(Builder::postExtractionHookConfiguration))
            .constructor(HookConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postExtractionHookConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_CONFIGURATIONS_FIELD,
            PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD, POST_EXTRACTION_HOOK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<InlineDocumentEnrichmentConfiguration> inlineConfigurations;

    private final HookConfiguration preExtractionHookConfiguration;

    private final HookConfiguration postExtractionHookConfiguration;

    private DocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.inlineConfigurations = builder.inlineConfigurations;
        this.preExtractionHookConfiguration = builder.preExtractionHookConfiguration;
        this.postExtractionHookConfiguration = builder.postExtractionHookConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InlineConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInlineConfigurations() {
        return inlineConfigurations != null && !(inlineConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information to alter document attributes or metadata fields and content when ingesting documents
     * into Amazon Q Business.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInlineConfigurations} method.
     * </p>
     * 
     * @return Configuration information to alter document attributes or metadata fields and content when ingesting
     *         documents into Amazon Q Business.
     */
    public final List<InlineDocumentEnrichmentConfiguration> inlineConfigurations() {
        return inlineConfigurations;
    }

    /**
     * Returns the value of the PreExtractionHookConfiguration property for this object.
     * 
     * @return The value of the PreExtractionHookConfiguration property for this object.
     */
    public final HookConfiguration preExtractionHookConfiguration() {
        return preExtractionHookConfiguration;
    }

    /**
     * Returns the value of the PostExtractionHookConfiguration property for this object.
     * 
     * @return The value of the PostExtractionHookConfiguration property for this object.
     */
    public final HookConfiguration postExtractionHookConfiguration() {
        return postExtractionHookConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInlineConfigurations() ? inlineConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preExtractionHookConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(postExtractionHookConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentEnrichmentConfiguration)) {
            return false;
        }
        DocumentEnrichmentConfiguration other = (DocumentEnrichmentConfiguration) obj;
        return hasInlineConfigurations() == other.hasInlineConfigurations()
                && Objects.equals(inlineConfigurations(), other.inlineConfigurations())
                && Objects.equals(preExtractionHookConfiguration(), other.preExtractionHookConfiguration())
                && Objects.equals(postExtractionHookConfiguration(), other.postExtractionHookConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentEnrichmentConfiguration")
                .add("InlineConfigurations", hasInlineConfigurations() ? inlineConfigurations() : null)
                .add("PreExtractionHookConfiguration", preExtractionHookConfiguration())
                .add("PostExtractionHookConfiguration", postExtractionHookConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inlineConfigurations":
            return Optional.ofNullable(clazz.cast(inlineConfigurations()));
        case "preExtractionHookConfiguration":
            return Optional.ofNullable(clazz.cast(preExtractionHookConfiguration()));
        case "postExtractionHookConfiguration":
            return Optional.ofNullable(clazz.cast(postExtractionHookConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inlineConfigurations", INLINE_CONFIGURATIONS_FIELD);
        map.put("preExtractionHookConfiguration", PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD);
        map.put("postExtractionHookConfiguration", POST_EXTRACTION_HOOK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((DocumentEnrichmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentEnrichmentConfiguration> {
        /**
         * <p>
         * Configuration information to alter document attributes or metadata fields and content when ingesting
         * documents into Amazon Q Business.
         * </p>
         * 
         * @param inlineConfigurations
         *        Configuration information to alter document attributes or metadata fields and content when ingesting
         *        documents into Amazon Q Business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineConfigurations(Collection<InlineDocumentEnrichmentConfiguration> inlineConfigurations);

        /**
         * <p>
         * Configuration information to alter document attributes or metadata fields and content when ingesting
         * documents into Amazon Q Business.
         * </p>
         * 
         * @param inlineConfigurations
         *        Configuration information to alter document attributes or metadata fields and content when ingesting
         *        documents into Amazon Q Business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineConfigurations(InlineDocumentEnrichmentConfiguration... inlineConfigurations);

        /**
         * <p>
         * Configuration information to alter document attributes or metadata fields and content when ingesting
         * documents into Amazon Q Business.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.InlineDocumentEnrichmentConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.qbusiness.model.InlineDocumentEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.InlineDocumentEnrichmentConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #inlineConfigurations(List<InlineDocumentEnrichmentConfiguration>)}.
         * 
         * @param inlineConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.InlineDocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineConfigurations(java.util.Collection<InlineDocumentEnrichmentConfiguration>)
         */
        Builder inlineConfigurations(Consumer<InlineDocumentEnrichmentConfiguration.Builder>... inlineConfigurations);

        /**
         * Sets the value of the PreExtractionHookConfiguration property for this object.
         *
         * @param preExtractionHookConfiguration
         *        The new value for the PreExtractionHookConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preExtractionHookConfiguration(HookConfiguration preExtractionHookConfiguration);

        /**
         * Sets the value of the PreExtractionHookConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HookConfiguration.Builder} avoiding the
         * need to create one manually via {@link HookConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HookConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #preExtractionHookConfiguration(HookConfiguration)}.
         * 
         * @param preExtractionHookConfiguration
         *        a consumer that will call methods on {@link HookConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preExtractionHookConfiguration(HookConfiguration)
         */
        default Builder preExtractionHookConfiguration(Consumer<HookConfiguration.Builder> preExtractionHookConfiguration) {
            return preExtractionHookConfiguration(HookConfiguration.builder().applyMutation(preExtractionHookConfiguration)
                    .build());
        }

        /**
         * Sets the value of the PostExtractionHookConfiguration property for this object.
         *
         * @param postExtractionHookConfiguration
         *        The new value for the PostExtractionHookConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postExtractionHookConfiguration(HookConfiguration postExtractionHookConfiguration);

        /**
         * Sets the value of the PostExtractionHookConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HookConfiguration.Builder} avoiding the
         * need to create one manually via {@link HookConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HookConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #postExtractionHookConfiguration(HookConfiguration)}.
         * 
         * @param postExtractionHookConfiguration
         *        a consumer that will call methods on {@link HookConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postExtractionHookConfiguration(HookConfiguration)
         */
        default Builder postExtractionHookConfiguration(Consumer<HookConfiguration.Builder> postExtractionHookConfiguration) {
            return postExtractionHookConfiguration(HookConfiguration.builder().applyMutation(postExtractionHookConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<InlineDocumentEnrichmentConfiguration> inlineConfigurations = DefaultSdkAutoConstructList.getInstance();

        private HookConfiguration preExtractionHookConfiguration;

        private HookConfiguration postExtractionHookConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentEnrichmentConfiguration model) {
            inlineConfigurations(model.inlineConfigurations);
            preExtractionHookConfiguration(model.preExtractionHookConfiguration);
            postExtractionHookConfiguration(model.postExtractionHookConfiguration);
        }

        public final List<InlineDocumentEnrichmentConfiguration.Builder> getInlineConfigurations() {
            List<InlineDocumentEnrichmentConfiguration.Builder> result = InlineDocumentEnrichmentConfigurationsCopier
                    .copyToBuilder(this.inlineConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineConfigurations(
                Collection<InlineDocumentEnrichmentConfiguration.BuilderImpl> inlineConfigurations) {
            this.inlineConfigurations = InlineDocumentEnrichmentConfigurationsCopier.copyFromBuilder(inlineConfigurations);
        }

        @Override
        public final Builder inlineConfigurations(Collection<InlineDocumentEnrichmentConfiguration> inlineConfigurations) {
            this.inlineConfigurations = InlineDocumentEnrichmentConfigurationsCopier.copy(inlineConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineConfigurations(InlineDocumentEnrichmentConfiguration... inlineConfigurations) {
            inlineConfigurations(Arrays.asList(inlineConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineConfigurations(Consumer<InlineDocumentEnrichmentConfiguration.Builder>... inlineConfigurations) {
            inlineConfigurations(Stream.of(inlineConfigurations)
                    .map(c -> InlineDocumentEnrichmentConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final HookConfiguration.Builder getPreExtractionHookConfiguration() {
            return preExtractionHookConfiguration != null ? preExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPreExtractionHookConfiguration(HookConfiguration.BuilderImpl preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration != null ? preExtractionHookConfiguration.build()
                    : null;
        }

        @Override
        public final Builder preExtractionHookConfiguration(HookConfiguration preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration;
            return this;
        }

        public final HookConfiguration.Builder getPostExtractionHookConfiguration() {
            return postExtractionHookConfiguration != null ? postExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPostExtractionHookConfiguration(HookConfiguration.BuilderImpl postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration != null ? postExtractionHookConfiguration
                    .build() : null;
        }

        @Override
        public final Builder postExtractionHookConfiguration(HookConfiguration postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration;
            return this;
        }

        @Override
        public DocumentEnrichmentConfiguration build() {
            return new DocumentEnrichmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
