/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataAccessorResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetDataAccessorResponse.Builder, GetDataAccessorResponse> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetDataAccessorResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DATA_ACCESSOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorId").getter(getter(GetDataAccessorResponse::dataAccessorId))
            .setter(setter(Builder::dataAccessorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorId").build()).build();

    private static final SdkField<String> DATA_ACCESSOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorArn").getter(getter(GetDataAccessorResponse::dataAccessorArn))
            .setter(setter(Builder::dataAccessorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorArn").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetDataAccessorResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> IDC_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idcApplicationArn").getter(getter(GetDataAccessorResponse::idcApplicationArn))
            .setter(setter(Builder::idcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcApplicationArn").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(GetDataAccessorResponse::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<List<ActionConfiguration>> ACTION_CONFIGURATIONS_FIELD = SdkField
            .<List<ActionConfiguration>> builder(MarshallingType.LIST)
            .memberName("actionConfigurations")
            .getter(getter(GetDataAccessorResponse::actionConfigurations))
            .setter(setter(Builder::actionConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetDataAccessorResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetDataAccessorResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            DATA_ACCESSOR_ID_FIELD, DATA_ACCESSOR_ARN_FIELD, APPLICATION_ID_FIELD, IDC_APPLICATION_ARN_FIELD, PRINCIPAL_FIELD,
            ACTION_CONFIGURATIONS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String displayName;

    private final String dataAccessorId;

    private final String dataAccessorArn;

    private final String applicationId;

    private final String idcApplicationArn;

    private final String principal;

    private final List<ActionConfiguration> actionConfigurations;

    private final Instant createdAt;

    private final Instant updatedAt;

    private GetDataAccessorResponse(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.dataAccessorId = builder.dataAccessorId;
        this.dataAccessorArn = builder.dataAccessorArn;
        this.applicationId = builder.applicationId;
        this.idcApplicationArn = builder.idcApplicationArn;
        this.principal = builder.principal;
        this.actionConfigurations = builder.actionConfigurations;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The friendly name of the data accessor.
     * </p>
     * 
     * @return The friendly name of the data accessor.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The unique identifier of the data accessor.
     * </p>
     * 
     * @return The unique identifier of the data accessor.
     */
    public final String dataAccessorId() {
        return dataAccessorId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data accessor.
     */
    public final String dataAccessorArn() {
        return dataAccessorArn;
    }

    /**
     * <p>
     * The unique identifier of the Q Business application associated with this data accessor.
     * </p>
     * 
     * @return The unique identifier of the Q Business application associated with this data accessor.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS IAM Identity Center application associated with this data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS IAM Identity Center application associated with this data
     *         accessor.
     */
    public final String idcApplicationArn() {
        return idcApplicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     */
    public final String principal() {
        return principal;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionConfigurations() {
        return actionConfigurations != null && !(actionConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of action configurations specifying the allowed actions and any associated filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionConfigurations} method.
     * </p>
     * 
     * @return The list of action configurations specifying the allowed actions and any associated filters.
     */
    public final List<ActionConfiguration> actionConfigurations() {
        return actionConfigurations;
    }

    /**
     * <p>
     * The timestamp when the data accessor was created.
     * </p>
     * 
     * @return The timestamp when the data accessor was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the data accessor was last updated.
     * </p>
     * 
     * @return The timestamp when the data accessor was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(idcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionConfigurations() ? actionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessorResponse)) {
            return false;
        }
        GetDataAccessorResponse other = (GetDataAccessorResponse) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(dataAccessorId(), other.dataAccessorId())
                && Objects.equals(dataAccessorArn(), other.dataAccessorArn())
                && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(idcApplicationArn(), other.idcApplicationArn())
                && Objects.equals(principal(), other.principal()) && hasActionConfigurations() == other.hasActionConfigurations()
                && Objects.equals(actionConfigurations(), other.actionConfigurations())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataAccessorResponse")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataAccessorId", dataAccessorId()).add("DataAccessorArn", dataAccessorArn())
                .add("ApplicationId", applicationId()).add("IdcApplicationArn", idcApplicationArn())
                .add("Principal", principal())
                .add("ActionConfigurations", hasActionConfigurations() ? actionConfigurations() : null)
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "dataAccessorId":
            return Optional.ofNullable(clazz.cast(dataAccessorId()));
        case "dataAccessorArn":
            return Optional.ofNullable(clazz.cast(dataAccessorArn()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "idcApplicationArn":
            return Optional.ofNullable(clazz.cast(idcApplicationArn()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "actionConfigurations":
            return Optional.ofNullable(clazz.cast(actionConfigurations()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("dataAccessorId", DATA_ACCESSOR_ID_FIELD);
        map.put("dataAccessorArn", DATA_ACCESSOR_ARN_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("idcApplicationArn", IDC_APPLICATION_ARN_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("actionConfigurations", ACTION_CONFIGURATIONS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessorResponse, T> g) {
        return obj -> g.apply((GetDataAccessorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataAccessorResponse> {
        /**
         * <p>
         * The friendly name of the data accessor.
         * </p>
         * 
         * @param displayName
         *        The friendly name of the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The unique identifier of the data accessor.
         * </p>
         * 
         * @param dataAccessorId
         *        The unique identifier of the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorId(String dataAccessorId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data accessor.
         * </p>
         * 
         * @param dataAccessorArn
         *        The Amazon Resource Name (ARN) of the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorArn(String dataAccessorArn);

        /**
         * <p>
         * The unique identifier of the Q Business application associated with this data accessor.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the Q Business application associated with this data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS IAM Identity Center application associated with this data accessor.
         * </p>
         * 
         * @param idcApplicationArn
         *        The Amazon Resource Name (ARN) of the AWS IAM Identity Center application associated with this data
         *        accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcApplicationArn(String idcApplicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
         * </p>
         * 
         * @param principal
         *        The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The list of action configurations specifying the allowed actions and any associated filters.
         * </p>
         * 
         * @param actionConfigurations
         *        The list of action configurations specifying the allowed actions and any associated filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations);

        /**
         * <p>
         * The list of action configurations specifying the allowed actions and any associated filters.
         * </p>
         * 
         * @param actionConfigurations
         *        The list of action configurations specifying the allowed actions and any associated filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfigurations(ActionConfiguration... actionConfigurations);

        /**
         * <p>
         * The list of action configurations specifying the allowed actions and any associated filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #actionConfigurations(List<ActionConfiguration>)}.
         * 
         * @param actionConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionConfigurations(java.util.Collection<ActionConfiguration>)
         */
        Builder actionConfigurations(Consumer<ActionConfiguration.Builder>... actionConfigurations);

        /**
         * <p>
         * The timestamp when the data accessor was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the data accessor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the data accessor was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the data accessor was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String displayName;

        private String dataAccessorId;

        private String dataAccessorArn;

        private String applicationId;

        private String idcApplicationArn;

        private String principal;

        private List<ActionConfiguration> actionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessorResponse model) {
            super(model);
            displayName(model.displayName);
            dataAccessorId(model.dataAccessorId);
            dataAccessorArn(model.dataAccessorArn);
            applicationId(model.applicationId);
            idcApplicationArn(model.idcApplicationArn);
            principal(model.principal);
            actionConfigurations(model.actionConfigurations);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDataAccessorId() {
            return dataAccessorId;
        }

        public final void setDataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
        }

        @Override
        public final Builder dataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        public final String getDataAccessorArn() {
            return dataAccessorArn;
        }

        public final void setDataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
        }

        @Override
        public final Builder dataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIdcApplicationArn() {
            return idcApplicationArn;
        }

        public final void setIdcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
        }

        @Override
        public final Builder idcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final List<ActionConfiguration.Builder> getActionConfigurations() {
            List<ActionConfiguration.Builder> result = ActionConfigurationListCopier.copyToBuilder(this.actionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConfigurations(Collection<ActionConfiguration.BuilderImpl> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copyFromBuilder(actionConfigurations);
        }

        @Override
        public final Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copy(actionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(ActionConfiguration... actionConfigurations) {
            actionConfigurations(Arrays.asList(actionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(Consumer<ActionConfiguration.Builder>... actionConfigurations) {
            actionConfigurations(Stream.of(actionConfigurations).map(c -> ActionConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDataAccessorResponse build() {
            return new GetDataAccessorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
