/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSourceResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetDataSourceResponse.Builder, GetDataSourceResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetDataSourceResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(GetDataSourceResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(GetDataSourceResponse::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceArn").getter(getter(GetDataSourceResponse::dataSourceArn))
            .setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetDataSourceResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetDataSourceResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("configuration").getter(getter(GetDataSourceResponse::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(GetDataSourceResponse::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetDataSourceResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetDataSourceResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetDataSourceResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDataSourceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSchedule").getter(getter(GetDataSourceResponse::syncSchedule)).setter(setter(Builder::syncSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetDataSourceResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetDataSourceResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<DocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("documentEnrichmentConfiguration")
            .getter(getter(GetDataSourceResponse::documentEnrichmentConfiguration))
            .setter(setter(Builder::documentEnrichmentConfiguration))
            .constructor(DocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration")
                    .build()).build();

    private static final SdkField<MediaExtractionConfiguration> MEDIA_EXTRACTION_CONFIGURATION_FIELD = SdkField
            .<MediaExtractionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("mediaExtractionConfiguration")
            .getter(getter(GetDataSourceResponse::mediaExtractionConfiguration))
            .setter(setter(Builder::mediaExtractionConfiguration))
            .constructor(MediaExtractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaExtractionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, DATA_SOURCE_ARN_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD,
            VPC_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SYNC_SCHEDULE_FIELD,
            ROLE_ARN_FIELD, ERROR_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD, MEDIA_EXTRACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String indexId;

    private final String dataSourceId;

    private final String dataSourceArn;

    private final String displayName;

    private final String type;

    private final Document configuration;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String description;

    private final String status;

    private final String syncSchedule;

    private final String roleArn;

    private final ErrorDetail error;

    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private final MediaExtractionConfiguration mediaExtractionConfiguration;

    private GetDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceArn = builder.dataSourceArn;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
        this.status = builder.status;
        this.syncSchedule = builder.syncSchedule;
        this.roleArn = builder.roleArn;
        this.error = builder.error;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.mediaExtractionConfiguration = builder.mediaExtractionConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the index linked to the data source connector.
     * </p>
     * 
     * @return The identifier of the index linked to the data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source connector.
     * </p>
     * 
     * @return The identifier of the data source connector.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data source.
     */
    public final String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * <p>
     * The name for the data source connector.
     * </p>
     * 
     * @return The name for the data source connector.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type of the data source connector. For example, <code>S3</code>.
     * </p>
     * 
     * @return The type of the data source connector. For example, <code>S3</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The details of how the data source connector is configured.
     * </p>
     * 
     * @return The details of how the data source connector is configured.
     */
    public final Document configuration() {
        return configuration;
    }

    /**
     * <p>
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
     * </p>
     * 
     * @return Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * The Unix timestamp when the data source connector was created.
     * </p>
     * 
     * @return The Unix timestamp when the data source connector was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the data source connector was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the data source connector was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The description for the data source connector.
     * </p>
     * 
     * @return The description for the data source connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the data source connector. When the <code>Status</code> field value is <code>FAILED</code>,
     * the <code>ErrorMessage</code> field contains a description of the error that caused the data source connector to
     * fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the data source connector. When the <code>Status</code> field value is
     *         <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused
     *         the data source connector to fail.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the data source connector. When the <code>Status</code> field value is <code>FAILED</code>,
     * the <code>ErrorMessage</code> field contains a description of the error that caused the data source connector to
     * fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the data source connector. When the <code>Status</code> field value is
     *         <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused
     *         the data source connector to fail.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The schedule for Amazon Q Business to update the index.
     * </p>
     * 
     * @return The schedule for Amazon Q Business to update the index.
     */
    public final String syncSchedule() {
        return syncSchedule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role with permission to access the data source and required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role with permission to access the data source and required
     *         resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the data source connector to fail.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the data source connector to fail.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * Returns the value of the DocumentEnrichmentConfiguration property for this object.
     * 
     * @return The value of the DocumentEnrichmentConfiguration property for this object.
     */
    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return documentEnrichmentConfiguration;
    }

    /**
     * <p>
     * The configuration for extracting information from media in documents for the data source.
     * </p>
     * 
     * @return The configuration for extracting information from media in documents for the data source.
     */
    public final MediaExtractionConfiguration mediaExtractionConfiguration() {
        return mediaExtractionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(mediaExtractionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceResponse)) {
            return false;
        }
        GetDataSourceResponse other = (GetDataSourceResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(dataSourceArn(), other.dataSourceArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(type(), other.type())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(syncSchedule(), other.syncSchedule()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(error(), other.error())
                && Objects.equals(documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration())
                && Objects.equals(mediaExtractionConfiguration(), other.mediaExtractionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSourceResponse").add("ApplicationId", applicationId()).add("IndexId", indexId())
                .add("DataSourceId", dataSourceId()).add("DataSourceArn", dataSourceArn()).add("DisplayName", displayName())
                .add("Type", type()).add("Configuration", configuration()).add("VpcConfiguration", vpcConfiguration())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Description", description())
                .add("Status", statusAsString()).add("SyncSchedule", syncSchedule()).add("RoleArn", roleArn())
                .add("Error", error()).add("DocumentEnrichmentConfiguration", documentEnrichmentConfiguration())
                .add("MediaExtractionConfiguration", mediaExtractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "dataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "syncSchedule":
            return Optional.ofNullable(clazz.cast(syncSchedule()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "documentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(documentEnrichmentConfiguration()));
        case "mediaExtractionConfiguration":
            return Optional.ofNullable(clazz.cast(mediaExtractionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("dataSourceArn", DATA_SOURCE_ARN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("syncSchedule", SYNC_SCHEDULE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("documentEnrichmentConfiguration", DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD);
        map.put("mediaExtractionConfiguration", MEDIA_EXTRACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceResponse, T> g) {
        return obj -> g.apply((GetDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSourceResponse> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the index linked to the data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index linked to the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source connector.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data source.
         * </p>
         * 
         * @param dataSourceArn
         *        The Amazon Resource Name (ARN) of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * The name for the data source connector.
         * </p>
         * 
         * @param displayName
         *        The name for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type of the data source connector. For example, <code>S3</code>.
         * </p>
         * 
         * @param type
         *        The type of the data source connector. For example, <code>S3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The details of how the data source connector is configured.
         * </p>
         * 
         * @param configuration
         *        The details of how the data source connector is configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Document configuration);

        /**
         * <p>
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * The Unix timestamp when the data source connector was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the data source connector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the data source connector was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the data source connector was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The description for the data source connector.
         * </p>
         * 
         * @param description
         *        The description for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the data source connector. When the <code>Status</code> field value is
         * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the
         * data source connector to fail.
         * </p>
         * 
         * @param status
         *        The current status of the data source connector. When the <code>Status</code> field value is
         *        <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that
         *        caused the data source connector to fail.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the data source connector. When the <code>Status</code> field value is
         * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the
         * data source connector to fail.
         * </p>
         * 
         * @param status
         *        The current status of the data source connector. When the <code>Status</code> field value is
         *        <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that
         *        caused the data source connector to fail.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);

        /**
         * <p>
         * The schedule for Amazon Q Business to update the index.
         * </p>
         * 
         * @param syncSchedule
         *        The schedule for Amazon Q Business to update the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSchedule(String syncSchedule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role with permission to access the data source and required resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role with permission to access the data source and required
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source connector to fail.
         * </p>
         * 
         * @param error
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the data source connector to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source connector to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * @param documentEnrichmentConfiguration
         *        The new value for the DocumentEnrichmentConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentEnrichmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)}.
         * 
         * @param documentEnrichmentConfiguration
         *        a consumer that will call methods on {@link DocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)
         */
        default Builder documentEnrichmentConfiguration(
                Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return documentEnrichmentConfiguration(DocumentEnrichmentConfiguration.builder()
                    .applyMutation(documentEnrichmentConfiguration).build());
        }

        /**
         * <p>
         * The configuration for extracting information from media in documents for the data source.
         * </p>
         * 
         * @param mediaExtractionConfiguration
         *        The configuration for extracting information from media in documents for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration);

        /**
         * <p>
         * The configuration for extracting information from media in documents for the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaExtractionConfiguration.Builder}
         * avoiding the need to create one manually via {@link MediaExtractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaExtractionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaExtractionConfiguration(MediaExtractionConfiguration)}.
         * 
         * @param mediaExtractionConfiguration
         *        a consumer that will call methods on {@link MediaExtractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaExtractionConfiguration(MediaExtractionConfiguration)
         */
        default Builder mediaExtractionConfiguration(Consumer<MediaExtractionConfiguration.Builder> mediaExtractionConfiguration) {
            return mediaExtractionConfiguration(MediaExtractionConfiguration.builder()
                    .applyMutation(mediaExtractionConfiguration).build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private String dataSourceId;

        private String dataSourceArn;

        private String displayName;

        private String type;

        private Document configuration;

        private DataSourceVpcConfiguration vpcConfiguration;

        private Instant createdAt;

        private Instant updatedAt;

        private String description;

        private String status;

        private String syncSchedule;

        private String roleArn;

        private ErrorDetail error;

        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private MediaExtractionConfiguration mediaExtractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceResponse model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            dataSourceArn(model.dataSourceArn);
            displayName(model.displayName);
            type(model.type);
            configuration(model.configuration);
            vpcConfiguration(model.vpcConfiguration);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            description(model.description);
            status(model.status);
            syncSchedule(model.syncSchedule);
            roleArn(model.roleArn);
            error(model.error);
            documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            mediaExtractionConfiguration(model.mediaExtractionConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Document getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSyncSchedule() {
            return syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(
                DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final MediaExtractionConfiguration.Builder getMediaExtractionConfiguration() {
            return mediaExtractionConfiguration != null ? mediaExtractionConfiguration.toBuilder() : null;
        }

        public final void setMediaExtractionConfiguration(MediaExtractionConfiguration.BuilderImpl mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration != null ? mediaExtractionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration;
            return this;
        }

        @Override
        public GetDataSourceResponse build() {
            return new GetDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
