/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMediaRequest extends QBusinessRequest implements
        ToCopyableBuilder<GetMediaRequest.Builder, GetMediaRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetMediaRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(GetMediaRequest::conversationId)).setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("conversationId").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(GetMediaRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()).build();

    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(GetMediaRequest::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mediaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONVERSATION_ID_FIELD, MESSAGE_ID_FIELD, MEDIA_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String conversationId;

    private final String messageId;

    private final String mediaId;

    private GetMediaRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.conversationId = builder.conversationId;
        this.messageId = builder.messageId;
        this.mediaId = builder.mediaId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business which contains the media object.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business which contains the media object.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business conversation.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business conversation.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business message.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The identifier of the media object. You can find this in the <code>sourceAttributions</code> returned by the
     * <code>Chat</code>, <code>ChatSync</code>, and <code>ListMessages</code> API responses.
     * </p>
     * 
     * @return The identifier of the media object. You can find this in the <code>sourceAttributions</code> returned by
     *         the <code>Chat</code>, <code>ChatSync</code>, and <code>ListMessages</code> API responses.
     */
    public final String mediaId() {
        return mediaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaRequest)) {
            return false;
        }
        GetMediaRequest other = (GetMediaRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(messageId(), other.messageId()) && Objects.equals(mediaId(), other.mediaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMediaRequest").add("ApplicationId", applicationId()).add("ConversationId", conversationId())
                .add("MessageId", messageId()).add("MediaId", mediaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("mediaId", MEDIA_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMediaRequest, T> g) {
        return obj -> g.apply((GetMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMediaRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business which contains the media object.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business which contains the media object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the Amazon Q Business conversation.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the Amazon Q Business conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier of the Amazon Q Business message.
         * </p>
         * 
         * @param messageId
         *        The identifier of the Amazon Q Business message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The identifier of the media object. You can find this in the <code>sourceAttributions</code> returned by the
         * <code>Chat</code>, <code>ChatSync</code>, and <code>ListMessages</code> API responses.
         * </p>
         * 
         * @param mediaId
         *        The identifier of the media object. You can find this in the <code>sourceAttributions</code> returned
         *        by the <code>Chat</code>, <code>ChatSync</code>, and <code>ListMessages</code> API responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String conversationId;

        private String messageId;

        private String mediaId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaRequest model) {
            super(model);
            applicationId(model.applicationId);
            conversationId(model.conversationId);
            messageId(model.messageId);
            mediaId(model.mediaId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMediaRequest build() {
            return new GetMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
