/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMediaResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetMediaResponse.Builder, GetMediaResponse> {
    private static final SdkField<SdkBytes> MEDIA_BYTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("mediaBytes").getter(getter(GetMediaResponse::mediaBytes)).setter(setter(Builder::mediaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaBytes").build()).build();

    private static final SdkField<String> MEDIA_MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaMimeType").getter(getter(GetMediaResponse::mediaMimeType)).setter(setter(Builder::mediaMimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaMimeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_BYTES_FIELD,
            MEDIA_MIME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SdkBytes mediaBytes;

    private final String mediaMimeType;

    private GetMediaResponse(BuilderImpl builder) {
        super(builder);
        this.mediaBytes = builder.mediaBytes;
        this.mediaMimeType = builder.mediaMimeType;
    }

    /**
     * <p>
     * The base64-encoded bytes of the media object.
     * </p>
     * 
     * @return The base64-encoded bytes of the media object.
     */
    public final SdkBytes mediaBytes() {
        return mediaBytes;
    }

    /**
     * <p>
     * The MIME type of the media object (image/png).
     * </p>
     * 
     * @return The MIME type of the media object (image/png).
     */
    public final String mediaMimeType() {
        return mediaMimeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(mediaMimeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaResponse)) {
            return false;
        }
        GetMediaResponse other = (GetMediaResponse) obj;
        return Objects.equals(mediaBytes(), other.mediaBytes()) && Objects.equals(mediaMimeType(), other.mediaMimeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMediaResponse").add("MediaBytes", mediaBytes()).add("MediaMimeType", mediaMimeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaBytes":
            return Optional.ofNullable(clazz.cast(mediaBytes()));
        case "mediaMimeType":
            return Optional.ofNullable(clazz.cast(mediaMimeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mediaBytes", MEDIA_BYTES_FIELD);
        map.put("mediaMimeType", MEDIA_MIME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMediaResponse, T> g) {
        return obj -> g.apply((GetMediaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMediaResponse> {
        /**
         * <p>
         * The base64-encoded bytes of the media object.
         * </p>
         * 
         * @param mediaBytes
         *        The base64-encoded bytes of the media object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaBytes(SdkBytes mediaBytes);

        /**
         * <p>
         * The MIME type of the media object (image/png).
         * </p>
         * 
         * @param mediaMimeType
         *        The MIME type of the media object (image/png).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaMimeType(String mediaMimeType);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private SdkBytes mediaBytes;

        private String mediaMimeType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaResponse model) {
            super(model);
            mediaBytes(model.mediaBytes);
            mediaMimeType(model.mediaMimeType);
        }

        public final ByteBuffer getMediaBytes() {
            return mediaBytes == null ? null : mediaBytes.asByteBuffer();
        }

        public final void setMediaBytes(ByteBuffer mediaBytes) {
            mediaBytes(mediaBytes == null ? null : SdkBytes.fromByteBuffer(mediaBytes));
        }

        @Override
        public final Builder mediaBytes(SdkBytes mediaBytes) {
            this.mediaBytes = mediaBytes;
            return this;
        }

        public final String getMediaMimeType() {
            return mediaMimeType;
        }

        public final void setMediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
        }

        @Override
        public final Builder mediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
            return this;
        }

        @Override
        public GetMediaResponse build() {
            return new GetMediaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
