/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPluginResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetPluginResponse.Builder, GetPluginResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetPluginResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(GetPluginResponse::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetPluginResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetPluginResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverUrl").getter(getter(GetPluginResponse::serverUrl)).setter(setter(Builder::serverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()).build();

    private static final SdkField<PluginAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField
            .<PluginAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("authConfiguration")
            .getter(getter(GetPluginResponse::authConfiguration)).setter(setter(Builder::authConfiguration))
            .constructor(PluginAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()).build();

    private static final SdkField<CustomPluginConfiguration> CUSTOM_PLUGIN_CONFIGURATION_FIELD = SdkField
            .<CustomPluginConfiguration> builder(MarshallingType.SDK_POJO).memberName("customPluginConfiguration")
            .getter(getter(GetPluginResponse::customPluginConfiguration)).setter(setter(Builder::customPluginConfiguration))
            .constructor(CustomPluginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginConfiguration").build())
            .build();

    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildStatus").getter(getter(GetPluginResponse::buildStatusAsString))
            .setter(setter(Builder::buildStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()).build();

    private static final SdkField<String> PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginArn").getter(getter(GetPluginResponse::pluginArn)).setter(setter(Builder::pluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(GetPluginResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetPluginResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetPluginResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            PLUGIN_ID_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, SERVER_URL_FIELD, AUTH_CONFIGURATION_FIELD,
            CUSTOM_PLUGIN_CONFIGURATION_FIELD, BUILD_STATUS_FIELD, PLUGIN_ARN_FIELD, STATE_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String pluginId;

    private final String displayName;

    private final String type;

    private final String serverUrl;

    private final PluginAuthConfiguration authConfiguration;

    private final CustomPluginConfiguration customPluginConfiguration;

    private final String buildStatus;

    private final String pluginArn;

    private final String state;

    private final Instant createdAt;

    private final Instant updatedAt;

    private GetPluginResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.pluginId = builder.pluginId;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.serverUrl = builder.serverUrl;
        this.authConfiguration = builder.authConfiguration;
        this.customPluginConfiguration = builder.customPluginConfiguration;
        this.buildStatus = builder.buildStatus;
        this.pluginArn = builder.pluginArn;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of the application which contains the plugin.
     * </p>
     * 
     * @return The identifier of the application which contains the plugin.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the plugin.
     * </p>
     * 
     * @return The identifier of the plugin.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The name of the plugin.
     * </p>
     * 
     * @return The name of the plugin.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the plugin.
     * @see PluginType
     */
    public final PluginType type() {
        return PluginType.fromValue(type);
    }

    /**
     * <p>
     * The type of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the plugin.
     * @see PluginType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The source URL used for plugin configuration.
     * </p>
     * 
     * @return The source URL used for plugin configuration.
     */
    public final String serverUrl() {
        return serverUrl;
    }

    /**
     * Returns the value of the AuthConfiguration property for this object.
     * 
     * @return The value of the AuthConfiguration property for this object.
     */
    public final PluginAuthConfiguration authConfiguration() {
        return authConfiguration;
    }

    /**
     * <p>
     * Configuration information required to create a custom plugin.
     * </p>
     * 
     * @return Configuration information required to create a custom plugin.
     */
    public final CustomPluginConfiguration customPluginConfiguration() {
        return customPluginConfiguration;
    }

    /**
     * <p>
     * The current status of a plugin. A plugin is modified asynchronously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildStatus} will
     * return {@link PluginBuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buildStatusAsString}.
     * </p>
     * 
     * @return The current status of a plugin. A plugin is modified asynchronously.
     * @see PluginBuildStatus
     */
    public final PluginBuildStatus buildStatus() {
        return PluginBuildStatus.fromValue(buildStatus);
    }

    /**
     * <p>
     * The current status of a plugin. A plugin is modified asynchronously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildStatus} will
     * return {@link PluginBuildStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buildStatusAsString}.
     * </p>
     * 
     * @return The current status of a plugin. A plugin is modified asynchronously.
     * @see PluginBuildStatus
     */
    public final String buildStatusAsString() {
        return buildStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role with permission to access resources needed to create the plugin.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role with permission to access resources needed to create the
     *         plugin.
     */
    public final String pluginArn() {
        return pluginArn;
    }

    /**
     * <p>
     * The current state of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the plugin.
     * @see PluginState
     */
    public final PluginState state() {
        return PluginState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the plugin.
     * @see PluginState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp for when the plugin was created.
     * </p>
     * 
     * @return The timestamp for when the plugin was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp for when the plugin was last updated.
     * </p>
     * 
     * @return The timestamp for when the plugin was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(authConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customPluginConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPluginResponse)) {
            return false;
        }
        GetPluginResponse other = (GetPluginResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(pluginId(), other.pluginId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(serverUrl(), other.serverUrl())
                && Objects.equals(authConfiguration(), other.authConfiguration())
                && Objects.equals(customPluginConfiguration(), other.customPluginConfiguration())
                && Objects.equals(buildStatusAsString(), other.buildStatusAsString())
                && Objects.equals(pluginArn(), other.pluginArn()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPluginResponse").add("ApplicationId", applicationId()).add("PluginId", pluginId())
                .add("DisplayName", displayName()).add("Type", typeAsString()).add("ServerUrl", serverUrl())
                .add("AuthConfiguration", authConfiguration()).add("CustomPluginConfiguration", customPluginConfiguration())
                .add("BuildStatus", buildStatusAsString()).add("PluginArn", pluginArn()).add("State", stateAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "serverUrl":
            return Optional.ofNullable(clazz.cast(serverUrl()));
        case "authConfiguration":
            return Optional.ofNullable(clazz.cast(authConfiguration()));
        case "customPluginConfiguration":
            return Optional.ofNullable(clazz.cast(customPluginConfiguration()));
        case "buildStatus":
            return Optional.ofNullable(clazz.cast(buildStatusAsString()));
        case "pluginArn":
            return Optional.ofNullable(clazz.cast(pluginArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        map.put("customPluginConfiguration", CUSTOM_PLUGIN_CONFIGURATION_FIELD);
        map.put("buildStatus", BUILD_STATUS_FIELD);
        map.put("pluginArn", PLUGIN_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPluginResponse, T> g) {
        return obj -> g.apply((GetPluginResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPluginResponse> {
        /**
         * <p>
         * The identifier of the application which contains the plugin.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application which contains the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the plugin.
         * </p>
         * 
         * @param pluginId
         *        The identifier of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The name of the plugin.
         * </p>
         * 
         * @param displayName
         *        The name of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type of the plugin.
         * </p>
         * 
         * @param type
         *        The type of the plugin.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the plugin.
         * </p>
         * 
         * @param type
         *        The type of the plugin.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder type(PluginType type);

        /**
         * <p>
         * The source URL used for plugin configuration.
         * </p>
         * 
         * @param serverUrl
         *        The source URL used for plugin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverUrl(String serverUrl);

        /**
         * Sets the value of the AuthConfiguration property for this object.
         *
         * @param authConfiguration
         *        The new value for the AuthConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfiguration(PluginAuthConfiguration authConfiguration);

        /**
         * Sets the value of the AuthConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PluginAuthConfiguration.Builder} avoiding
         * the need to create one manually via {@link PluginAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginAuthConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authConfiguration(PluginAuthConfiguration)}.
         * 
         * @param authConfiguration
         *        a consumer that will call methods on {@link PluginAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfiguration(PluginAuthConfiguration)
         */
        default Builder authConfiguration(Consumer<PluginAuthConfiguration.Builder> authConfiguration) {
            return authConfiguration(PluginAuthConfiguration.builder().applyMutation(authConfiguration).build());
        }

        /**
         * <p>
         * Configuration information required to create a custom plugin.
         * </p>
         * 
         * @param customPluginConfiguration
         *        Configuration information required to create a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration);

        /**
         * <p>
         * Configuration information required to create a custom plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPluginConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomPluginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPluginConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customPluginConfiguration(CustomPluginConfiguration)}.
         * 
         * @param customPluginConfiguration
         *        a consumer that will call methods on {@link CustomPluginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPluginConfiguration(CustomPluginConfiguration)
         */
        default Builder customPluginConfiguration(Consumer<CustomPluginConfiguration.Builder> customPluginConfiguration) {
            return customPluginConfiguration(CustomPluginConfiguration.builder().applyMutation(customPluginConfiguration).build());
        }

        /**
         * <p>
         * The current status of a plugin. A plugin is modified asynchronously.
         * </p>
         * 
         * @param buildStatus
         *        The current status of a plugin. A plugin is modified asynchronously.
         * @see PluginBuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginBuildStatus
         */
        Builder buildStatus(String buildStatus);

        /**
         * <p>
         * The current status of a plugin. A plugin is modified asynchronously.
         * </p>
         * 
         * @param buildStatus
         *        The current status of a plugin. A plugin is modified asynchronously.
         * @see PluginBuildStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginBuildStatus
         */
        Builder buildStatus(PluginBuildStatus buildStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role with permission to access resources needed to create the plugin.
         * </p>
         * 
         * @param pluginArn
         *        The Amazon Resource Name (ARN) of the role with permission to access resources needed to create the
         *        plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginArn(String pluginArn);

        /**
         * <p>
         * The current state of the plugin.
         * </p>
         * 
         * @param state
         *        The current state of the plugin.
         * @see PluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the plugin.
         * </p>
         * 
         * @param state
         *        The current state of the plugin.
         * @see PluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginState
         */
        Builder state(PluginState state);

        /**
         * <p>
         * The timestamp for when the plugin was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp for when the plugin was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp for when the plugin was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp for when the plugin was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String pluginId;

        private String displayName;

        private String type;

        private String serverUrl;

        private PluginAuthConfiguration authConfiguration;

        private CustomPluginConfiguration customPluginConfiguration;

        private String buildStatus;

        private String pluginArn;

        private String state;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPluginResponse model) {
            super(model);
            applicationId(model.applicationId);
            pluginId(model.pluginId);
            displayName(model.displayName);
            type(model.type);
            serverUrl(model.serverUrl);
            authConfiguration(model.authConfiguration);
            customPluginConfiguration(model.customPluginConfiguration);
            buildStatus(model.buildStatus);
            pluginArn(model.pluginArn);
            state(model.state);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PluginType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getServerUrl() {
            return serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final PluginAuthConfiguration.Builder getAuthConfiguration() {
            return authConfiguration != null ? authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(PluginAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(PluginAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        public final CustomPluginConfiguration.Builder getCustomPluginConfiguration() {
            return customPluginConfiguration != null ? customPluginConfiguration.toBuilder() : null;
        }

        public final void setCustomPluginConfiguration(CustomPluginConfiguration.BuilderImpl customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration != null ? customPluginConfiguration.build() : null;
        }

        @Override
        public final Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        public final String getBuildStatus() {
            return buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(PluginBuildStatus buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        public final String getPluginArn() {
            return pluginArn;
        }

        public final void setPluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
        }

        @Override
        public final Builder pluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PluginState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetPluginResponse build() {
            return new GetPluginResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
