/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebExperienceResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetWebExperienceResponse.Builder, GetWebExperienceResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetWebExperienceResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceId").getter(getter(GetWebExperienceResponse::webExperienceId))
            .setter(setter(Builder::webExperienceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceId").build()).build();

    private static final SdkField<String> WEB_EXPERIENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceArn").getter(getter(GetWebExperienceResponse::webExperienceArn))
            .setter(setter(Builder::webExperienceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceArn").build()).build();

    private static final SdkField<String> DEFAULT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultEndpoint").getter(getter(GetWebExperienceResponse::defaultEndpoint))
            .setter(setter(Builder::defaultEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultEndpoint").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWebExperienceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetWebExperienceResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetWebExperienceResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(GetWebExperienceResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> SUBTITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subtitle").getter(getter(GetWebExperienceResponse::subtitle)).setter(setter(Builder::subtitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()).build();

    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("welcomeMessage").getter(getter(GetWebExperienceResponse::welcomeMessage))
            .setter(setter(Builder::welcomeMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()).build();

    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samplePromptsControlMode").getter(getter(GetWebExperienceResponse::samplePromptsControlModeAsString))
            .setter(setter(Builder::samplePromptsControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build())
            .build();

    private static final SdkField<List<String>> ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("origins")
            .getter(getter(GetWebExperienceResponse::origins))
            .setter(setter(Builder::origins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetWebExperienceResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField
            .<IdentityProviderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("identityProviderConfiguration")
            .getter(getter(GetWebExperienceResponse::identityProviderConfiguration))
            .setter(setter(Builder::identityProviderConfiguration))
            .constructor(IdentityProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfiguration")
                    .build()).build();

    private static final SdkField<WebExperienceAuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<WebExperienceAuthConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("authenticationConfiguration")
            .getter(getter(GetWebExperienceResponse::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(WebExperienceAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration")
                    .build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetWebExperienceResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<BrowserExtensionConfiguration> BROWSER_EXTENSION_CONFIGURATION_FIELD = SdkField
            .<BrowserExtensionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("browserExtensionConfiguration")
            .getter(getter(GetWebExperienceResponse::browserExtensionConfiguration))
            .setter(setter(Builder::browserExtensionConfiguration))
            .constructor(BrowserExtensionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserExtensionConfiguration")
                    .build()).build();

    private static final SdkField<CustomizationConfiguration> CUSTOMIZATION_CONFIGURATION_FIELD = SdkField
            .<CustomizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("customizationConfiguration")
            .getter(getter(GetWebExperienceResponse::customizationConfiguration))
            .setter(setter(Builder::customizationConfiguration))
            .constructor(CustomizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            WEB_EXPERIENCE_ID_FIELD, WEB_EXPERIENCE_ARN_FIELD, DEFAULT_ENDPOINT_FIELD, STATUS_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, TITLE_FIELD, SUBTITLE_FIELD, WELCOME_MESSAGE_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD,
            ORIGINS_FIELD, ROLE_ARN_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD, AUTHENTICATION_CONFIGURATION_FIELD,
            ERROR_FIELD, BROWSER_EXTENSION_CONFIGURATION_FIELD, CUSTOMIZATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String webExperienceId;

    private final String webExperienceArn;

    private final String defaultEndpoint;

    private final String status;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String title;

    private final String subtitle;

    private final String welcomeMessage;

    private final String samplePromptsControlMode;

    private final List<String> origins;

    private final String roleArn;

    private final IdentityProviderConfiguration identityProviderConfiguration;

    private final WebExperienceAuthConfiguration authenticationConfiguration;

    private final ErrorDetail error;

    private final BrowserExtensionConfiguration browserExtensionConfiguration;

    private final CustomizationConfiguration customizationConfiguration;

    private GetWebExperienceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.webExperienceId = builder.webExperienceId;
        this.webExperienceArn = builder.webExperienceArn;
        this.defaultEndpoint = builder.defaultEndpoint;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.welcomeMessage = builder.welcomeMessage;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.origins = builder.origins;
        this.roleArn = builder.roleArn;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.error = builder.error;
        this.browserExtensionConfiguration = builder.browserExtensionConfiguration;
        this.customizationConfiguration = builder.customizationConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application linked to the web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application linked to the web experience.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business web experience.
     */
    public final String webExperienceId() {
        return webExperienceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q Business web experience and
     * required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q Business web
     *         experience and required resources.
     */
    public final String webExperienceArn() {
        return webExperienceArn;
    }

    /**
     * <p>
     * The endpoint of your Amazon Q Business web experience.
     * </p>
     * 
     * @return The endpoint of your Amazon Q Business web experience.
     */
    public final String defaultEndpoint() {
        return defaultEndpoint;
    }

    /**
     * <p>
     * The current status of the Amazon Q Business web experience. When the <code>Status</code> field value is
     * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the data
     * source connector to fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WebExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Amazon Q Business web experience. When the <code>Status</code> field value is
     *         <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused
     *         the data source connector to fail.
     * @see WebExperienceStatus
     */
    public final WebExperienceStatus status() {
        return WebExperienceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Amazon Q Business web experience. When the <code>Status</code> field value is
     * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the data
     * source connector to fail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WebExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Amazon Q Business web experience. When the <code>Status</code> field value is
     *         <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused
     *         the data source connector to fail.
     * @see WebExperienceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business web experience was last created.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business web experience was last created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business web experience was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business web experience was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The title for your Amazon Q Business web experience.
     * </p>
     * 
     * @return The title for your Amazon Q Business web experience.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The subtitle for your Amazon Q Business web experience.
     * </p>
     * 
     * @return The subtitle for your Amazon Q Business web experience.
     */
    public final String subtitle() {
        return subtitle;
    }

    /**
     * <p>
     * The customized welcome message for end users of an Amazon Q Business web experience.
     * </p>
     * 
     * @return The customized welcome message for end users of an Amazon Q Business web experience.
     */
    public final String welcomeMessage() {
        return welcomeMessage;
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(samplePromptsControlMode);
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final String samplePromptsControlModeAsString() {
        return samplePromptsControlMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Origins property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOrigins() {
        return origins != null && !(origins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets the website domain origins that are allowed to embed the Amazon Q Business web experience.
     * 
     * <pre>
     * <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the base URL for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified). &lt;/p&gt; </code>
     * </pre>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrigins} method.
     * </p>
     * 
     * @return Gets the website domain origins that are allowed to embed the Amazon Q Business web experience.
     * 
     * <pre><code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the base URL for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified). &lt;/p&gt; </code>
     */
    public final List<String> origins() {
        return origins;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role attached to your web experience.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role attached to your web experience.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
     * experience.
     * </p>
     * 
     * @return Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
     *         experience.
     */
    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return identityProviderConfiguration;
    }

    /**
     * <p>
     * The authentication configuration information for your Amazon Q Business web experience.
     * </p>
     * 
     * @return The authentication configuration information for your Amazon Q Business web experience.
     * @deprecated Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity Center
     *             for user management.
     */
    @Deprecated
    public final WebExperienceAuthConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the data source connector to fail.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the data source connector to fail.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * The browser extension configuration for an Amazon Q Business web experience.
     * </p>
     * 
     * @return The browser extension configuration for an Amazon Q Business web experience.
     */
    public final BrowserExtensionConfiguration browserExtensionConfiguration() {
        return browserExtensionConfiguration;
    }

    /**
     * <p>
     * Gets the custom logo, favicon, font, and color used in the Amazon Q web experience.
     * </p>
     * 
     * @return Gets the custom logo, favicon, font, and color used in the Amazon Q web experience.
     */
    public final CustomizationConfiguration customizationConfiguration() {
        return customizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceId());
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(welcomeMessage());
        hashCode = 31 * hashCode + Objects.hashCode(samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrigins() ? origins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(browserExtensionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customizationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebExperienceResponse)) {
            return false;
        }
        GetWebExperienceResponse other = (GetWebExperienceResponse) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(webExperienceId(), other.webExperienceId())
                && Objects.equals(webExperienceArn(), other.webExperienceArn())
                && Objects.equals(defaultEndpoint(), other.defaultEndpoint())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(title(), other.title())
                && Objects.equals(subtitle(), other.subtitle()) && Objects.equals(welcomeMessage(), other.welcomeMessage())
                && Objects.equals(samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString())
                && hasOrigins() == other.hasOrigins() && Objects.equals(origins(), other.origins())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(identityProviderConfiguration(), other.identityProviderConfiguration())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && Objects.equals(error(), other.error())
                && Objects.equals(browserExtensionConfiguration(), other.browserExtensionConfiguration())
                && Objects.equals(customizationConfiguration(), other.customizationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWebExperienceResponse").add("ApplicationId", applicationId())
                .add("WebExperienceId", webExperienceId()).add("WebExperienceArn", webExperienceArn())
                .add("DefaultEndpoint", defaultEndpoint()).add("Status", statusAsString()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Title", title()).add("Subtitle", subtitle())
                .add("WelcomeMessage", welcomeMessage()).add("SamplePromptsControlMode", samplePromptsControlModeAsString())
                .add("Origins", hasOrigins() ? origins() : null).add("RoleArn", roleArn())
                .add("IdentityProviderConfiguration", identityProviderConfiguration())
                .add("AuthenticationConfiguration", authenticationConfiguration()).add("Error", error())
                .add("BrowserExtensionConfiguration", browserExtensionConfiguration())
                .add("CustomizationConfiguration", customizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "webExperienceId":
            return Optional.ofNullable(clazz.cast(webExperienceId()));
        case "webExperienceArn":
            return Optional.ofNullable(clazz.cast(webExperienceArn()));
        case "defaultEndpoint":
            return Optional.ofNullable(clazz.cast(defaultEndpoint()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "welcomeMessage":
            return Optional.ofNullable(clazz.cast(welcomeMessage()));
        case "samplePromptsControlMode":
            return Optional.ofNullable(clazz.cast(samplePromptsControlModeAsString()));
        case "origins":
            return Optional.ofNullable(clazz.cast(origins()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "identityProviderConfiguration":
            return Optional.ofNullable(clazz.cast(identityProviderConfiguration()));
        case "authenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "browserExtensionConfiguration":
            return Optional.ofNullable(clazz.cast(browserExtensionConfiguration()));
        case "customizationConfiguration":
            return Optional.ofNullable(clazz.cast(customizationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("webExperienceId", WEB_EXPERIENCE_ID_FIELD);
        map.put("webExperienceArn", WEB_EXPERIENCE_ARN_FIELD);
        map.put("defaultEndpoint", DEFAULT_ENDPOINT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("subtitle", SUBTITLE_FIELD);
        map.put("welcomeMessage", WELCOME_MESSAGE_FIELD);
        map.put("samplePromptsControlMode", SAMPLE_PROMPTS_CONTROL_MODE_FIELD);
        map.put("origins", ORIGINS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("identityProviderConfiguration", IDENTITY_PROVIDER_CONFIGURATION_FIELD);
        map.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("browserExtensionConfiguration", BROWSER_EXTENSION_CONFIGURATION_FIELD);
        map.put("customizationConfiguration", CUSTOMIZATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWebExperienceResponse, T> g) {
        return obj -> g.apply((GetWebExperienceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWebExperienceResponse> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application linked to the web experience.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application linked to the web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the Amazon Q Business web experience.
         * </p>
         * 
         * @param webExperienceId
         *        The identifier of the Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceId(String webExperienceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q Business web experience
         * and required resources.
         * </p>
         * 
         * @param webExperienceArn
         *        The Amazon Resource Name (ARN) of the role with the permission to access the Amazon Q Business web
         *        experience and required resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceArn(String webExperienceArn);

        /**
         * <p>
         * The endpoint of your Amazon Q Business web experience.
         * </p>
         * 
         * @param defaultEndpoint
         *        The endpoint of your Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEndpoint(String defaultEndpoint);

        /**
         * <p>
         * The current status of the Amazon Q Business web experience. When the <code>Status</code> field value is
         * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the
         * data source connector to fail.
         * </p>
         * 
         * @param status
         *        The current status of the Amazon Q Business web experience. When the <code>Status</code> field value
         *        is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that
         *        caused the data source connector to fail.
         * @see WebExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Amazon Q Business web experience. When the <code>Status</code> field value is
         * <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the
         * data source connector to fail.
         * </p>
         * 
         * @param status
         *        The current status of the Amazon Q Business web experience. When the <code>Status</code> field value
         *        is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that
         *        caused the data source connector to fail.
         * @see WebExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceStatus
         */
        Builder status(WebExperienceStatus status);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business web experience was last created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q Business web experience was last created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business web experience was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q Business web experience was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The title for your Amazon Q Business web experience.
         * </p>
         * 
         * @param title
         *        The title for your Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The subtitle for your Amazon Q Business web experience.
         * </p>
         * 
         * @param subtitle
         *        The subtitle for your Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(String subtitle);

        /**
         * <p>
         * The customized welcome message for end users of an Amazon Q Business web experience.
         * </p>
         * 
         * @param welcomeMessage
         *        The customized welcome message for end users of an Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeMessage(String welcomeMessage);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(String samplePromptsControlMode);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode);

        /**
         * <p>
         * Gets the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         * <pre>
         * <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the base URL for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified). &lt;/p&gt; </code>
         * </pre>
         * 
         * @param origins
         *        Gets the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         *        <pre>
         * 
         *        <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the base URL for accessing a website including
         *        the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if
         *        specified). &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder origins(Collection<String> origins);

        /**
         * <p>
         * Gets the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         * <pre>
         * <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the base URL for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified). &lt;/p&gt; </code>
         * </pre>
         * 
         * @param origins
         *        Gets the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         *        <pre>
         * 
         *        <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the base URL for accessing a website including
         *        the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if
         *        specified). &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder origins(String... origins);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role attached to your web experience.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the service role attached to your web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
         * experience.
         * </p>
         * 
         * @param identityProviderConfiguration
         *        Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business
         *        web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration);

        /**
         * <p>
         * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
         * experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderConfiguration.Builder}
         * avoiding the need to create one manually via {@link IdentityProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProviderConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderConfiguration(IdentityProviderConfiguration)}.
         * 
         * @param identityProviderConfiguration
         *        a consumer that will call methods on {@link IdentityProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfiguration(IdentityProviderConfiguration)
         */
        default Builder identityProviderConfiguration(
                Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return identityProviderConfiguration(IdentityProviderConfiguration.builder()
                    .applyMutation(identityProviderConfiguration).build());
        }

        /**
         * <p>
         * The authentication configuration information for your Amazon Q Business web experience.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration information for your Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity
         *             Center for user management.
         */
        @Deprecated
        Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration information for your Amazon Q Business web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebExperienceAuthConfiguration.Builder}
         * avoiding the need to create one manually via {@link WebExperienceAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebExperienceAuthConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(WebExperienceAuthConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link WebExperienceAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(WebExperienceAuthConfiguration)
         * @deprecated Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity
         *             Center for user management.
         */
        @Deprecated
        default Builder authenticationConfiguration(Consumer<WebExperienceAuthConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(WebExperienceAuthConfiguration.builder()
                    .applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source connector to fail.
         * </p>
         * 
         * @param error
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the data source connector to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a description of the error that caused the data source connector to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The browser extension configuration for an Amazon Q Business web experience.
         * </p>
         * 
         * @param browserExtensionConfiguration
         *        The browser extension configuration for an Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserExtensionConfiguration(BrowserExtensionConfiguration browserExtensionConfiguration);

        /**
         * <p>
         * The browser extension configuration for an Amazon Q Business web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrowserExtensionConfiguration.Builder}
         * avoiding the need to create one manually via {@link BrowserExtensionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrowserExtensionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #browserExtensionConfiguration(BrowserExtensionConfiguration)}.
         * 
         * @param browserExtensionConfiguration
         *        a consumer that will call methods on {@link BrowserExtensionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #browserExtensionConfiguration(BrowserExtensionConfiguration)
         */
        default Builder browserExtensionConfiguration(
                Consumer<BrowserExtensionConfiguration.Builder> browserExtensionConfiguration) {
            return browserExtensionConfiguration(BrowserExtensionConfiguration.builder()
                    .applyMutation(browserExtensionConfiguration).build());
        }

        /**
         * <p>
         * Gets the custom logo, favicon, font, and color used in the Amazon Q web experience.
         * </p>
         * 
         * @param customizationConfiguration
         *        Gets the custom logo, favicon, font, and color used in the Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationConfiguration(CustomizationConfiguration customizationConfiguration);

        /**
         * <p>
         * Gets the custom logo, favicon, font, and color used in the Amazon Q web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customizationConfiguration(CustomizationConfiguration)}.
         * 
         * @param customizationConfiguration
         *        a consumer that will call methods on {@link CustomizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizationConfiguration(CustomizationConfiguration)
         */
        default Builder customizationConfiguration(Consumer<CustomizationConfiguration.Builder> customizationConfiguration) {
            return customizationConfiguration(CustomizationConfiguration.builder().applyMutation(customizationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String webExperienceId;

        private String webExperienceArn;

        private String defaultEndpoint;

        private String status;

        private Instant createdAt;

        private Instant updatedAt;

        private String title;

        private String subtitle;

        private String welcomeMessage;

        private String samplePromptsControlMode;

        private List<String> origins = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private IdentityProviderConfiguration identityProviderConfiguration;

        private WebExperienceAuthConfiguration authenticationConfiguration;

        private ErrorDetail error;

        private BrowserExtensionConfiguration browserExtensionConfiguration;

        private CustomizationConfiguration customizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebExperienceResponse model) {
            super(model);
            applicationId(model.applicationId);
            webExperienceId(model.webExperienceId);
            webExperienceArn(model.webExperienceArn);
            defaultEndpoint(model.defaultEndpoint);
            status(model.status);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            title(model.title);
            subtitle(model.subtitle);
            welcomeMessage(model.welcomeMessage);
            samplePromptsControlMode(model.samplePromptsControlMode);
            origins(model.origins);
            roleArn(model.roleArn);
            identityProviderConfiguration(model.identityProviderConfiguration);
            authenticationConfiguration(model.authenticationConfiguration);
            error(model.error);
            browserExtensionConfiguration(model.browserExtensionConfiguration);
            customizationConfiguration(model.customizationConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getWebExperienceId() {
            return webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        public final String getWebExperienceArn() {
            return webExperienceArn;
        }

        public final void setWebExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
        }

        @Override
        public final Builder webExperienceArn(String webExperienceArn) {
            this.webExperienceArn = webExperienceArn;
            return this;
        }

        public final String getDefaultEndpoint() {
            return defaultEndpoint;
        }

        public final void setDefaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
        }

        @Override
        public final Builder defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WebExperienceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSubtitle() {
            return subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final String getWelcomeMessage() {
            return welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final Collection<String> getOrigins() {
            if (origins instanceof SdkAutoConstructList) {
                return null;
            }
            return origins;
        }

        public final void setOrigins(Collection<String> origins) {
            this.origins = WebExperienceOriginsCopier.copy(origins);
        }

        @Override
        public final Builder origins(Collection<String> origins) {
            this.origins = WebExperienceOriginsCopier.copy(origins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origins(String... origins) {
            origins(Arrays.asList(origins));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return identityProviderConfiguration != null ? identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build()
                    : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        @Deprecated
        public final WebExperienceAuthConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setAuthenticationConfiguration(WebExperienceAuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final BrowserExtensionConfiguration.Builder getBrowserExtensionConfiguration() {
            return browserExtensionConfiguration != null ? browserExtensionConfiguration.toBuilder() : null;
        }

        public final void setBrowserExtensionConfiguration(BrowserExtensionConfiguration.BuilderImpl browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration != null ? browserExtensionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder browserExtensionConfiguration(BrowserExtensionConfiguration browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration;
            return this;
        }

        public final CustomizationConfiguration.Builder getCustomizationConfiguration() {
            return customizationConfiguration != null ? customizationConfiguration.toBuilder() : null;
        }

        public final void setCustomizationConfiguration(CustomizationConfiguration.BuilderImpl customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration != null ? customizationConfiguration.build() : null;
        }

        @Override
        public final Builder customizationConfiguration(CustomizationConfiguration customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration;
            return this;
        }

        @Override
        public GetWebExperienceResponse build() {
            return new GetWebExperienceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
