/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of a group's status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupStatusDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupStatusDetail.Builder, GroupStatusDetail> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GroupStatusDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(GroupStatusDetail::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("errorDetail").getter(getter(GroupStatusDetail::errorDetail)).setter(setter(Builder::errorDetail))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            LAST_UPDATED_AT_FIELD, ERROR_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant lastUpdatedAt;

    private final ErrorDetail errorDetail;

    private GroupStatusDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.errorDetail = builder.errorDetail;
    }

    /**
     * <p>
     * The status of a group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a group.
     * @see GroupStatus
     */
    public final GroupStatus status() {
        return GroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a group.
     * @see GroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The details of an error associated a group status.
     * </p>
     * 
     * @return The details of an error associated a group status.
     */
    public final ErrorDetail errorDetail() {
        return errorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupStatusDetail)) {
            return false;
        }
        GroupStatusDetail other = (GroupStatusDetail) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(errorDetail(), other.errorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupStatusDetail").add("Status", statusAsString()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ErrorDetail", errorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "errorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("errorDetail", ERROR_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupStatusDetail, T> g) {
        return obj -> g.apply((GroupStatusDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupStatusDetail> {
        /**
         * <p>
         * The status of a group.
         * </p>
         * 
         * @param status
         *        The status of a group.
         * @see GroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a group.
         * </p>
         * 
         * @param status
         *        The status of a group.
         * @see GroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupStatus
         */
        Builder status(GroupStatus status);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The Unix timestamp when the Amazon Q Business application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The details of an error associated a group status.
         * </p>
         * 
         * @param errorDetail
         *        The details of an error associated a group status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(ErrorDetail errorDetail);

        /**
         * <p>
         * The details of an error associated a group status.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #errorDetail(ErrorDetail)}.
         * 
         * @param errorDetail
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetail(ErrorDetail)
         */
        default Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return errorDetail(ErrorDetail.builder().applyMutation(errorDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant lastUpdatedAt;

        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupStatusDetail model) {
            status(model.status);
            lastUpdatedAt(model.lastUpdatedAt);
            errorDetail(model.errorDetail);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return errorDetail != null ? errorDetail.toBuilder() : null;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        @Override
        public GroupStatusDetail build() {
            return new GroupStatusDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
