/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDocumentsResponse extends QBusinessResponse implements
        ToCopyableBuilder<ListDocumentsResponse.Builder, ListDocumentsResponse> {
    private static final SdkField<List<DocumentDetails>> DOCUMENT_DETAIL_LIST_FIELD = SdkField
            .<List<DocumentDetails>> builder(MarshallingType.LIST)
            .memberName("documentDetailList")
            .getter(getter(ListDocumentsResponse::documentDetailList))
            .setter(setter(Builder::documentDetailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentDetailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDocumentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_DETAIL_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DocumentDetails> documentDetailList;

    private final String nextToken;

    private ListDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.documentDetailList = builder.documentDetailList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentDetailList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentDetailList() {
        return documentDetailList != null && !(documentDetailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of document details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentDetailList} method.
     * </p>
     * 
     * @return A list of document details.
     */
    public final List<DocumentDetails> documentDetailList() {
        return documentDetailList;
    }

    /**
     * <p>
     * If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon Q Business
     * returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * documents.
     * </p>
     * 
     * @return If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon Q
     *         Business returns a pagination token in the response. You can use this pagination token to retrieve the
     *         next set of documents.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentDetailList() ? documentDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResponse)) {
            return false;
        }
        ListDocumentsResponse other = (ListDocumentsResponse) obj;
        return hasDocumentDetailList() == other.hasDocumentDetailList()
                && Objects.equals(documentDetailList(), other.documentDetailList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDocumentsResponse")
                .add("DocumentDetailList", hasDocumentDetailList() ? documentDetailList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentDetailList":
            return Optional.ofNullable(clazz.cast(documentDetailList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documentDetailList", DOCUMENT_DETAIL_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentsResponse, T> g) {
        return obj -> g.apply((ListDocumentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDocumentsResponse> {
        /**
         * <p>
         * A list of document details.
         * </p>
         * 
         * @param documentDetailList
         *        A list of document details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDetailList(Collection<DocumentDetails> documentDetailList);

        /**
         * <p>
         * A list of document details.
         * </p>
         * 
         * @param documentDetailList
         *        A list of document details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDetailList(DocumentDetails... documentDetailList);

        /**
         * <p>
         * A list of document details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.DocumentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #documentDetailList(List<DocumentDetails>)}.
         * 
         * @param documentDetailList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentDetailList(java.util.Collection<DocumentDetails>)
         */
        Builder documentDetailList(Consumer<DocumentDetails.Builder>... documentDetailList);

        /**
         * <p>
         * If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon Q
         * Business returns a pagination token in the response. You can use this pagination token to retrieve the next
         * set of documents.
         * </p>
         * 
         * @param nextToken
         *        If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon
         *        Q Business returns a pagination token in the response. You can use this pagination token to retrieve
         *        the next set of documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private List<DocumentDetails> documentDetailList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsResponse model) {
            super(model);
            documentDetailList(model.documentDetailList);
            nextToken(model.nextToken);
        }

        public final List<DocumentDetails.Builder> getDocumentDetailList() {
            List<DocumentDetails.Builder> result = DocumentDetailListCopier.copyToBuilder(this.documentDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentDetailList(Collection<DocumentDetails.BuilderImpl> documentDetailList) {
            this.documentDetailList = DocumentDetailListCopier.copyFromBuilder(documentDetailList);
        }

        @Override
        public final Builder documentDetailList(Collection<DocumentDetails> documentDetailList) {
            this.documentDetailList = DocumentDetailListCopier.copy(documentDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentDetailList(DocumentDetails... documentDetailList) {
            documentDetailList(Arrays.asList(documentDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentDetailList(Consumer<DocumentDetails.Builder>... documentDetailList) {
            documentDetailList(Stream.of(documentDetailList).map(c -> DocumentDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDocumentsResponse build() {
            return new ListDocumentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
