/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsRequest extends QBusinessRequest implements
        ToCopyableBuilder<ListGroupsRequest.Builder, ListGroupsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ListGroupsRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(ListGroupsRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<Instant> UPDATED_EARLIER_THAN_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedEarlierThan").getter(getter(ListGroupsRequest::updatedEarlierThan))
            .setter(setter(Builder::updatedEarlierThan))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("updatedEarlierThan").build())
            .build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(ListGroupsRequest::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dataSourceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, UPDATED_EARLIER_THAN_FIELD, DATA_SOURCE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String indexId;

    private final Instant updatedEarlierThan;

    private final String dataSourceId;

    private final String nextToken;

    private final Integer maxResults;

    private ListGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.updatedEarlierThan = builder.updatedEarlierThan;
        this.dataSourceId = builder.dataSourceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the application for getting a list of groups mapped to users.
     * </p>
     * 
     * @return The identifier of the application for getting a list of groups mapped to users.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the index for getting a list of groups mapped to users.
     * </p>
     * 
     * @return The identifier of the index for getting a list of groups mapped to users.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to
     * their groups.
     * </p>
     * 
     * @return The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping
     *         users to their groups.
     */
    public final Instant updatedEarlierThan() {
        return updatedEarlierThan;
    }

    /**
     * <p>
     * The identifier of the data source for getting a list of groups mapped to users.
     * </p>
     * 
     * @return The identifier of the data source for getting a list of groups mapped to users.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more data to retrieve), Amazon Q Business returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of groups that are
     * mapped to users.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more data to retrieve), Amazon Q Business
     *         returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         groups that are mapped to users.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of returned groups that are mapped to users.
     * </p>
     * 
     * @return The maximum number of returned groups that are mapped to users.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedEarlierThan());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsRequest)) {
            return false;
        }
        ListGroupsRequest other = (ListGroupsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(updatedEarlierThan(), other.updatedEarlierThan())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsRequest").add("ApplicationId", applicationId()).add("IndexId", indexId())
                .add("UpdatedEarlierThan", updatedEarlierThan()).add("DataSourceId", dataSourceId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "updatedEarlierThan":
            return Optional.ofNullable(clazz.cast(updatedEarlierThan()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("updatedEarlierThan", UPDATED_EARLIER_THAN_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsRequest, T> g) {
        return obj -> g.apply((ListGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupsRequest> {
        /**
         * <p>
         * The identifier of the application for getting a list of groups mapped to users.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application for getting a list of groups mapped to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the index for getting a list of groups mapped to users.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for getting a list of groups mapped to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users
         * to their groups.
         * </p>
         * 
         * @param updatedEarlierThan
         *        The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for
         *        mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedEarlierThan(Instant updatedEarlierThan);

        /**
         * <p>
         * The identifier of the data source for getting a list of groups mapped to users.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source for getting a list of groups mapped to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * If the previous response was incomplete (because there is more data to retrieve), Amazon Q Business returns a
         * pagination token in the response. You can use this pagination token to retrieve the next set of groups that
         * are mapped to users.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more data to retrieve), Amazon Q Business
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of groups that are mapped to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of returned groups that are mapped to users.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of returned groups that are mapped to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private Instant updatedEarlierThan;

        private String dataSourceId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsRequest model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            updatedEarlierThan(model.updatedEarlierThan);
            dataSourceId(model.dataSourceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Instant getUpdatedEarlierThan() {
            return updatedEarlierThan;
        }

        public final void setUpdatedEarlierThan(Instant updatedEarlierThan) {
            this.updatedEarlierThan = updatedEarlierThan;
        }

        @Override
        public final Builder updatedEarlierThan(Instant updatedEarlierThan) {
            this.updatedEarlierThan = updatedEarlierThan;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupsRequest build() {
            return new ListGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
