/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRetrieversResponse extends QBusinessResponse implements
        ToCopyableBuilder<ListRetrieversResponse.Builder, ListRetrieversResponse> {
    private static final SdkField<List<Retriever>> RETRIEVERS_FIELD = SdkField
            .<List<Retriever>> builder(MarshallingType.LIST)
            .memberName("retrievers")
            .getter(getter(ListRetrieversResponse::retrievers))
            .setter(setter(Builder::retrievers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Retriever> builder(MarshallingType.SDK_POJO)
                                            .constructor(Retriever::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRetrieversResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Retriever> retrievers;

    private final String nextToken;

    private ListRetrieversResponse(BuilderImpl builder) {
        super(builder);
        this.retrievers = builder.retrievers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Retrievers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRetrievers() {
        return retrievers != null && !(retrievers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information for one or more retrievers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetrievers} method.
     * </p>
     * 
     * @return An array of summary information for one or more retrievers.
     */
    public final List<Retriever> retrievers() {
        return retrievers;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Q Business returns this token, which you can use in a later request to list
     * the next set of retrievers.
     * </p>
     * 
     * @return If the response is truncated, Amazon Q Business returns this token, which you can use in a later request
     *         to list the next set of retrievers.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRetrievers() ? retrievers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrieversResponse)) {
            return false;
        }
        ListRetrieversResponse other = (ListRetrieversResponse) obj;
        return hasRetrievers() == other.hasRetrievers() && Objects.equals(retrievers(), other.retrievers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRetrieversResponse").add("Retrievers", hasRetrievers() ? retrievers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retrievers":
            return Optional.ofNullable(clazz.cast(retrievers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("retrievers", RETRIEVERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRetrieversResponse, T> g) {
        return obj -> g.apply((ListRetrieversResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRetrieversResponse> {
        /**
         * <p>
         * An array of summary information for one or more retrievers.
         * </p>
         * 
         * @param retrievers
         *        An array of summary information for one or more retrievers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievers(Collection<Retriever> retrievers);

        /**
         * <p>
         * An array of summary information for one or more retrievers.
         * </p>
         * 
         * @param retrievers
         *        An array of summary information for one or more retrievers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievers(Retriever... retrievers);

        /**
         * <p>
         * An array of summary information for one or more retrievers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Retriever.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.Retriever#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Retriever.Builder#build()} is called immediately and
         * its result is passed to {@link #retrievers(List<Retriever>)}.
         * 
         * @param retrievers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Retriever.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievers(java.util.Collection<Retriever>)
         */
        Builder retrievers(Consumer<Retriever.Builder>... retrievers);

        /**
         * <p>
         * If the response is truncated, Amazon Q Business returns this token, which you can use in a later request to
         * list the next set of retrievers.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Q Business returns this token, which you can use in a later
         *        request to list the next set of retrievers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private List<Retriever> retrievers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrieversResponse model) {
            super(model);
            retrievers(model.retrievers);
            nextToken(model.nextToken);
        }

        public final List<Retriever.Builder> getRetrievers() {
            List<Retriever.Builder> result = RetrieversCopier.copyToBuilder(this.retrievers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievers(Collection<Retriever.BuilderImpl> retrievers) {
            this.retrievers = RetrieversCopier.copyFromBuilder(retrievers);
        }

        @Override
        public final Builder retrievers(Collection<Retriever> retrievers) {
            this.retrievers = RetrieversCopier.copy(retrievers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievers(Retriever... retrievers) {
            retrievers(Arrays.asList(retrievers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievers(Consumer<Retriever.Builder>... retrievers) {
            retrievers(Stream.of(retrievers).map(c -> Retriever.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetrieversResponse build() {
            return new ListRetrieversResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
