/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for extracting information from media in documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaExtractionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaExtractionConfiguration.Builder, MediaExtractionConfiguration> {
    private static final SdkField<ImageExtractionConfiguration> IMAGE_EXTRACTION_CONFIGURATION_FIELD = SdkField
            .<ImageExtractionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("imageExtractionConfiguration")
            .getter(getter(MediaExtractionConfiguration::imageExtractionConfiguration))
            .setter(setter(Builder::imageExtractionConfiguration))
            .constructor(ImageExtractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageExtractionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGE_EXTRACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageExtractionConfiguration imageExtractionConfiguration;

    private MediaExtractionConfiguration(BuilderImpl builder) {
        this.imageExtractionConfiguration = builder.imageExtractionConfiguration;
    }

    /**
     * <p>
     * The configuration for extracting semantic meaning from images in documents. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
     * semantic meaning from images and visuals</a>.
     * </p>
     * 
     * @return The configuration for extracting semantic meaning from images in documents. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">
     *         Extracting semantic meaning from images and visuals</a>.
     */
    public final ImageExtractionConfiguration imageExtractionConfiguration() {
        return imageExtractionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageExtractionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaExtractionConfiguration)) {
            return false;
        }
        MediaExtractionConfiguration other = (MediaExtractionConfiguration) obj;
        return Objects.equals(imageExtractionConfiguration(), other.imageExtractionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaExtractionConfiguration")
                .add("ImageExtractionConfiguration", imageExtractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageExtractionConfiguration":
            return Optional.ofNullable(clazz.cast(imageExtractionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageExtractionConfiguration", IMAGE_EXTRACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaExtractionConfiguration, T> g) {
        return obj -> g.apply((MediaExtractionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaExtractionConfiguration> {
        /**
         * <p>
         * The configuration for extracting semantic meaning from images in documents. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
         * semantic meaning from images and visuals</a>.
         * </p>
         * 
         * @param imageExtractionConfiguration
         *        The configuration for extracting semantic meaning from images in documents. For more information, see
         *        <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">
         *        Extracting semantic meaning from images and visuals</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageExtractionConfiguration(ImageExtractionConfiguration imageExtractionConfiguration);

        /**
         * <p>
         * The configuration for extracting semantic meaning from images in documents. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
         * semantic meaning from images and visuals</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageExtractionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageExtractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageExtractionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #imageExtractionConfiguration(ImageExtractionConfiguration)}.
         * 
         * @param imageExtractionConfiguration
         *        a consumer that will call methods on {@link ImageExtractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageExtractionConfiguration(ImageExtractionConfiguration)
         */
        default Builder imageExtractionConfiguration(Consumer<ImageExtractionConfiguration.Builder> imageExtractionConfiguration) {
            return imageExtractionConfiguration(ImageExtractionConfiguration.builder()
                    .applyMutation(imageExtractionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageExtractionConfiguration imageExtractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaExtractionConfiguration model) {
            imageExtractionConfiguration(model.imageExtractionConfiguration);
        }

        public final ImageExtractionConfiguration.Builder getImageExtractionConfiguration() {
            return imageExtractionConfiguration != null ? imageExtractionConfiguration.toBuilder() : null;
        }

        public final void setImageExtractionConfiguration(ImageExtractionConfiguration.BuilderImpl imageExtractionConfiguration) {
            this.imageExtractionConfiguration = imageExtractionConfiguration != null ? imageExtractionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder imageExtractionConfiguration(ImageExtractionConfiguration imageExtractionConfiguration) {
            this.imageExtractionConfiguration = imageExtractionConfiguration;
            return this;
        }

        @Override
        public MediaExtractionConfiguration build() {
            return new MediaExtractionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
