/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A metadata event for a AI-generated text output message in a Amazon Q Business conversation, containing associated
 * metadata generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetadataEvent implements SdkPojo, Serializable, ToCopyableBuilder<MetadataEvent.Builder, MetadataEvent>,
        ChatOutputStream {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(MetadataEvent::conversationId)).setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userMessageId").getter(getter(MetadataEvent::userMessageId)).setter(setter(Builder::userMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageId").getter(getter(MetadataEvent::systemMessageId))
            .setter(setter(Builder::systemMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()).build();

    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTIONS_FIELD = SdkField
            .<List<SourceAttribution>> builder(MarshallingType.LIST)
            .memberName("sourceAttributions")
            .getter(getter(MetadataEvent::sourceAttributions))
            .setter(setter(Builder::sourceAttributions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttributions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAttribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAttribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FINAL_TEXT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("finalTextMessage").getter(getter(MetadataEvent::finalTextMessage))
            .setter(setter(Builder::finalTextMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalTextMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD,
            USER_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_ID_FIELD, SOURCE_ATTRIBUTIONS_FIELD, FINAL_TEXT_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conversationId;

    private final String userMessageId;

    private final String systemMessageId;

    private final List<SourceAttribution> sourceAttributions;

    private final String finalTextMessage;

    protected MetadataEvent(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.userMessageId = builder.userMessageId;
        this.systemMessageId = builder.systemMessageId;
        this.sourceAttributions = builder.sourceAttributions;
        this.finalTextMessage = builder.finalTextMessage;
    }

    /**
     * <p>
     * The identifier of the conversation with which the generated metadata is associated.
     * </p>
     * 
     * @return The identifier of the conversation with which the generated metadata is associated.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier of an Amazon Q Business end user text input message within the conversation.
     * </p>
     * 
     * @return The identifier of an Amazon Q Business end user text input message within the conversation.
     */
    public final String userMessageId() {
        return userMessageId;
    }

    /**
     * <p>
     * The identifier of an Amazon Q Business AI generated message within the conversation.
     * </p>
     * 
     * @return The identifier of an Amazon Q Business AI generated message within the conversation.
     */
    public final String systemMessageId() {
        return systemMessageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAttributions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceAttributions() {
        return sourceAttributions != null && !(sourceAttributions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source documents used to generate the conversation response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAttributions} method.
     * </p>
     * 
     * @return The source documents used to generate the conversation response.
     */
    public final List<SourceAttribution> sourceAttributions() {
        return sourceAttributions;
    }

    /**
     * <p>
     * The final text output message generated by the system.
     * </p>
     * 
     * @return The final text output message generated by the system.
     */
    public final String finalTextMessage() {
        return finalTextMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAttributions() ? sourceAttributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(finalTextMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataEvent)) {
            return false;
        }
        MetadataEvent other = (MetadataEvent) obj;
        return Objects.equals(conversationId(), other.conversationId()) && Objects.equals(userMessageId(), other.userMessageId())
                && Objects.equals(systemMessageId(), other.systemMessageId())
                && hasSourceAttributions() == other.hasSourceAttributions()
                && Objects.equals(sourceAttributions(), other.sourceAttributions())
                && Objects.equals(finalTextMessage(), other.finalTextMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataEvent").add("ConversationId", conversationId()).add("UserMessageId", userMessageId())
                .add("SystemMessageId", systemMessageId())
                .add("SourceAttributions", hasSourceAttributions() ? sourceAttributions() : null)
                .add("FinalTextMessage", finalTextMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "userMessageId":
            return Optional.ofNullable(clazz.cast(userMessageId()));
        case "systemMessageId":
            return Optional.ofNullable(clazz.cast(systemMessageId()));
        case "sourceAttributions":
            return Optional.ofNullable(clazz.cast(sourceAttributions()));
        case "finalTextMessage":
            return Optional.ofNullable(clazz.cast(finalTextMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final MetadataEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("userMessageId", USER_MESSAGE_ID_FIELD);
        map.put("systemMessageId", SYSTEM_MESSAGE_ID_FIELD);
        map.put("sourceAttributions", SOURCE_ATTRIBUTIONS_FIELD);
        map.put("finalTextMessage", FINAL_TEXT_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataEvent, T> g) {
        return obj -> g.apply((MetadataEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link MetadataEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataEvent> {
        /**
         * <p>
         * The identifier of the conversation with which the generated metadata is associated.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the conversation with which the generated metadata is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier of an Amazon Q Business end user text input message within the conversation.
         * </p>
         * 
         * @param userMessageId
         *        The identifier of an Amazon Q Business end user text input message within the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMessageId(String userMessageId);

        /**
         * <p>
         * The identifier of an Amazon Q Business AI generated message within the conversation.
         * </p>
         * 
         * @param systemMessageId
         *        The identifier of an Amazon Q Business AI generated message within the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageId(String systemMessageId);

        /**
         * <p>
         * The source documents used to generate the conversation response.
         * </p>
         * 
         * @param sourceAttributions
         *        The source documents used to generate the conversation response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions);

        /**
         * <p>
         * The source documents used to generate the conversation response.
         * </p>
         * 
         * @param sourceAttributions
         *        The source documents used to generate the conversation response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAttributions(SourceAttribution... sourceAttributions);

        /**
         * <p>
         * The source documents used to generate the conversation response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAttributions(List<SourceAttribution>)}.
         * 
         * @param sourceAttributions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAttributions(java.util.Collection<SourceAttribution>)
         */
        Builder sourceAttributions(Consumer<SourceAttribution.Builder>... sourceAttributions);

        /**
         * <p>
         * The final text output message generated by the system.
         * </p>
         * 
         * @param finalTextMessage
         *        The final text output message generated by the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalTextMessage(String finalTextMessage);
    }

    protected static class BuilderImpl implements Builder {
        private String conversationId;

        private String userMessageId;

        private String systemMessageId;

        private List<SourceAttribution> sourceAttributions = DefaultSdkAutoConstructList.getInstance();

        private String finalTextMessage;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MetadataEvent model) {
            conversationId(model.conversationId);
            userMessageId(model.userMessageId);
            systemMessageId(model.systemMessageId);
            sourceAttributions(model.sourceAttributions);
            finalTextMessage(model.finalTextMessage);
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getUserMessageId() {
            return userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final String getSystemMessageId() {
            return systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttributions() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttributions(Collection<SourceAttribution.BuilderImpl> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copyFromBuilder(sourceAttributions);
        }

        @Override
        public final Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copy(sourceAttributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(SourceAttribution... sourceAttributions) {
            sourceAttributions(Arrays.asList(sourceAttributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(Consumer<SourceAttribution.Builder>... sourceAttributions) {
            sourceAttributions(Stream.of(sourceAttributions).map(c -> SourceAttribution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFinalTextMessage() {
            return finalTextMessage;
        }

        public final void setFinalTextMessage(String finalTextMessage) {
            this.finalTextMessage = finalTextMessage;
        }

        @Override
        public final Builder finalTextMessage(String finalTextMessage) {
            this.finalTextMessage = finalTextMessage;
            return this;
        }

        @Override
        public MetadataEvent build() {
            return new MetadataEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
