/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2ClientCredentialConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2ClientCredentialConfiguration.Builder, OAuth2ClientCredentialConfiguration> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(OAuth2ClientCredentialConfiguration::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(OAuth2ClientCredentialConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> AUTHORIZATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationUrl").getter(getter(OAuth2ClientCredentialConfiguration::authorizationUrl))
            .setter(setter(Builder::authorizationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationUrl").build()).build();

    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenUrl").getter(getter(OAuth2ClientCredentialConfiguration::tokenUrl))
            .setter(setter(Builder::tokenUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            ROLE_ARN_FIELD, AUTHORIZATION_URL_FIELD, TOKEN_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final String roleArn;

    private final String authorizationUrl;

    private final String tokenUrl;

    private OAuth2ClientCredentialConfiguration(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.roleArn = builder.roleArn;
        this.authorizationUrl = builder.authorizationUrl;
        this.tokenUrl = builder.tokenUrl;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token used for plugin configuration.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token used for plugin
     *         configuration.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0 authentication credentials stored in a
     * Secrets Manager secret.
     * </p>
     * 
     * @return The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0 authentication credentials
     *         stored in a Secrets Manager secret.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The redirect URL required by the OAuth 2.0 protocol for Amazon Q Business to authenticate a plugin user through a
     * third party authentication server.
     * </p>
     * 
     * @return The redirect URL required by the OAuth 2.0 protocol for Amazon Q Business to authenticate a plugin user
     *         through a third party authentication server.
     */
    public final String authorizationUrl() {
        return authorizationUrl;
    }

    /**
     * <p>
     * The URL required by the OAuth 2.0 protocol to exchange an end user authorization code for an access token.
     * </p>
     * 
     * @return The URL required by the OAuth 2.0 protocol to exchange an end user authorization code for an access
     *         token.
     */
    public final String tokenUrl() {
        return tokenUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(tokenUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2ClientCredentialConfiguration)) {
            return false;
        }
        OAuth2ClientCredentialConfiguration other = (OAuth2ClientCredentialConfiguration) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(authorizationUrl(), other.authorizationUrl()) && Objects.equals(tokenUrl(), other.tokenUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2ClientCredentialConfiguration").add("SecretArn", secretArn()).add("RoleArn", roleArn())
                .add("AuthorizationUrl", authorizationUrl()).add("TokenUrl", tokenUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "authorizationUrl":
            return Optional.ofNullable(clazz.cast(authorizationUrl()));
        case "tokenUrl":
            return Optional.ofNullable(clazz.cast(tokenUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("secretArn", SECRET_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("authorizationUrl", AUTHORIZATION_URL_FIELD);
        map.put("tokenUrl", TOKEN_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2ClientCredentialConfiguration, T> g) {
        return obj -> g.apply((OAuth2ClientCredentialConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2ClientCredentialConfiguration> {
        /**
         * <p>
         * The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token used for plugin
         * configuration.
         * </p>
         * 
         * @param secretArn
         *        The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token used for plugin
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0 authentication credentials stored in
         * a Secrets Manager secret.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0 authentication credentials
         *        stored in a Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The redirect URL required by the OAuth 2.0 protocol for Amazon Q Business to authenticate a plugin user
         * through a third party authentication server.
         * </p>
         * 
         * @param authorizationUrl
         *        The redirect URL required by the OAuth 2.0 protocol for Amazon Q Business to authenticate a plugin
         *        user through a third party authentication server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationUrl(String authorizationUrl);

        /**
         * <p>
         * The URL required by the OAuth 2.0 protocol to exchange an end user authorization code for an access token.
         * </p>
         * 
         * @param tokenUrl
         *        The URL required by the OAuth 2.0 protocol to exchange an end user authorization code for an access
         *        token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrl(String tokenUrl);
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private String roleArn;

        private String authorizationUrl;

        private String tokenUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2ClientCredentialConfiguration model) {
            secretArn(model.secretArn);
            roleArn(model.roleArn);
            authorizationUrl(model.authorizationUrl);
            tokenUrl(model.tokenUrl);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getAuthorizationUrl() {
            return authorizationUrl;
        }

        public final void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        @Override
        public final Builder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public final String getTokenUrl() {
            return tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        @Override
        public OAuth2ClientCredentialConfiguration build() {
            return new OAuth2ClientCredentialConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
