/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for the retriever used for your Amazon Q Business application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Retriever implements SdkPojo, Serializable, ToCopyableBuilder<Retriever.Builder, Retriever> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(Retriever::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverId").getter(getter(Retriever::retrieverId)).setter(setter(Builder::retrieverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Retriever::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Retriever::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Retriever::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            RETRIEVER_ID_FIELD, TYPE_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String retrieverId;

    private final String type;

    private final String status;

    private final String displayName;

    private Retriever(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.retrieverId = builder.retrieverId;
        this.type = builder.type;
        this.status = builder.status;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application using the retriever.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application using the retriever.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the retriever used by your Amazon Q Business application.
     * </p>
     * 
     * @return The identifier of the retriever used by your Amazon Q Business application.
     */
    public final String retrieverId() {
        return retrieverId;
    }

    /**
     * <p>
     * The type of your retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of your retriever.
     * @see RetrieverType
     */
    public final RetrieverType type() {
        return RetrieverType.fromValue(type);
    }

    /**
     * <p>
     * The type of your retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of your retriever.
     * @see RetrieverType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of your retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrieverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your retriever.
     * @see RetrieverStatus
     */
    public final RetrieverStatus status() {
        return RetrieverStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of your retriever.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrieverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your retriever.
     * @see RetrieverStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of your retriever.
     * </p>
     * 
     * @return The name of your retriever.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Retriever)) {
            return false;
        }
        Retriever other = (Retriever) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(retrieverId(), other.retrieverId())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Retriever").add("ApplicationId", applicationId()).add("RetrieverId", retrieverId())
                .add("Type", typeAsString()).add("Status", statusAsString()).add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "retrieverId":
            return Optional.ofNullable(clazz.cast(retrieverId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("retrieverId", RETRIEVER_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Retriever, T> g) {
        return obj -> g.apply((Retriever) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Retriever> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application using the retriever.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application using the retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the retriever used by your Amazon Q Business application.
         * </p>
         * 
         * @param retrieverId
         *        The identifier of the retriever used by your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverId(String retrieverId);

        /**
         * <p>
         * The type of your retriever.
         * </p>
         * 
         * @param type
         *        The type of your retriever.
         * @see RetrieverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of your retriever.
         * </p>
         * 
         * @param type
         *        The type of your retriever.
         * @see RetrieverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverType
         */
        Builder type(RetrieverType type);

        /**
         * <p>
         * The status of your retriever.
         * </p>
         * 
         * @param status
         *        The status of your retriever.
         * @see RetrieverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of your retriever.
         * </p>
         * 
         * @param status
         *        The status of your retriever.
         * @see RetrieverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieverStatus
         */
        Builder status(RetrieverStatus status);

        /**
         * <p>
         * The name of your retriever.
         * </p>
         * 
         * @param displayName
         *        The name of your retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String retrieverId;

        private String type;

        private String status;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(Retriever model) {
            applicationId(model.applicationId);
            retrieverId(model.retrieverId);
            type(model.type);
            status(model.status);
            displayName(model.displayName);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRetrieverId() {
            return retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrieverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Retriever build() {
            return new Retriever(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
