/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a retriever as the content source for a search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieverContentSource implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrieverContentSource.Builder, RetrieverContentSource> {
    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverId").getter(getter(RetrieverContentSource::retrieverId)).setter(setter(Builder::retrieverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String retrieverId;

    private RetrieverContentSource(BuilderImpl builder) {
        this.retrieverId = builder.retrieverId;
    }

    /**
     * <p>
     * The unique identifier of the retriever to use as the content source.
     * </p>
     * 
     * @return The unique identifier of the retriever to use as the content source.
     */
    public final String retrieverId() {
        return retrieverId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retrieverId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieverContentSource)) {
            return false;
        }
        RetrieverContentSource other = (RetrieverContentSource) obj;
        return Objects.equals(retrieverId(), other.retrieverId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieverContentSource").add("RetrieverId", retrieverId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retrieverId":
            return Optional.ofNullable(clazz.cast(retrieverId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("retrieverId", RETRIEVER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieverContentSource, T> g) {
        return obj -> g.apply((RetrieverContentSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrieverContentSource> {
        /**
         * <p>
         * The unique identifier of the retriever to use as the content source.
         * </p>
         * 
         * @param retrieverId
         *        The unique identifier of the retriever to use as the content source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverId(String retrieverId);
    }

    static final class BuilderImpl implements Builder {
        private String retrieverId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieverContentSource model) {
            retrieverId(model.retrieverId);
        }

        public final String getRetrieverId() {
            return retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        @Override
        public RetrieverContentSource build() {
            return new RetrieverContentSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
