/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information about a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleConfiguration.Builder, RuleConfiguration> {
    private static final SdkField<ContentBlockerRule> CONTENT_BLOCKER_RULE_FIELD = SdkField
            .<ContentBlockerRule> builder(MarshallingType.SDK_POJO).memberName("contentBlockerRule")
            .getter(getter(RuleConfiguration::contentBlockerRule)).setter(setter(Builder::contentBlockerRule))
            .constructor(ContentBlockerRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentBlockerRule").build())
            .build();

    private static final SdkField<ContentRetrievalRule> CONTENT_RETRIEVAL_RULE_FIELD = SdkField
            .<ContentRetrievalRule> builder(MarshallingType.SDK_POJO).memberName("contentRetrievalRule")
            .getter(getter(RuleConfiguration::contentRetrievalRule)).setter(setter(Builder::contentRetrievalRule))
            .constructor(ContentRetrievalRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentRetrievalRule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_BLOCKER_RULE_FIELD,
            CONTENT_RETRIEVAL_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContentBlockerRule contentBlockerRule;

    private final ContentRetrievalRule contentRetrievalRule;

    private final Type type;

    private RuleConfiguration(BuilderImpl builder) {
        this.contentBlockerRule = builder.contentBlockerRule;
        this.contentRetrievalRule = builder.contentRetrievalRule;
        this.type = builder.type;
    }

    /**
     * <p>
     * A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
     * </p>
     * 
     * @return A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
     */
    public final ContentBlockerRule contentBlockerRule() {
        return contentBlockerRule;
    }

    /**
     * Returns the value of the ContentRetrievalRule property for this object.
     * 
     * @return The value of the ContentRetrievalRule property for this object.
     */
    public final ContentRetrievalRule contentRetrievalRule() {
        return contentRetrievalRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentBlockerRule());
        hashCode = 31 * hashCode + Objects.hashCode(contentRetrievalRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleConfiguration)) {
            return false;
        }
        RuleConfiguration other = (RuleConfiguration) obj;
        return Objects.equals(contentBlockerRule(), other.contentBlockerRule())
                && Objects.equals(contentRetrievalRule(), other.contentRetrievalRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleConfiguration").add("ContentBlockerRule", contentBlockerRule())
                .add("ContentRetrievalRule", contentRetrievalRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentBlockerRule":
            return Optional.ofNullable(clazz.cast(contentBlockerRule()));
        case "contentRetrievalRule":
            return Optional.ofNullable(clazz.cast(contentRetrievalRule()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contentBlockerRule()} initialized to the given value.
     *
     * <p>
     * A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
     * </p>
     * 
     * @param contentBlockerRule
     *        A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
     */
    public static RuleConfiguration fromContentBlockerRule(ContentBlockerRule contentBlockerRule) {
        return builder().contentBlockerRule(contentBlockerRule).build();
    }

    /**
     * Create an instance of this class with {@link #contentBlockerRule()} initialized to the given value.
     *
     * <p>
     * A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
     * </p>
     * 
     * @param contentBlockerRule
     *        A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
     */
    public static RuleConfiguration fromContentBlockerRule(Consumer<ContentBlockerRule.Builder> contentBlockerRule) {
        ContentBlockerRule.Builder builder = ContentBlockerRule.builder();
        contentBlockerRule.accept(builder);
        return fromContentBlockerRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #contentRetrievalRule()} initialized to the given value.
     *
     * Sets the value of the ContentRetrievalRule property for this object.
     *
     * @param contentRetrievalRule
     *        The new value for the ContentRetrievalRule property for this object.
     */
    public static RuleConfiguration fromContentRetrievalRule(ContentRetrievalRule contentRetrievalRule) {
        return builder().contentRetrievalRule(contentRetrievalRule).build();
    }

    /**
     * Create an instance of this class with {@link #contentRetrievalRule()} initialized to the given value.
     *
     * Sets the value of the ContentRetrievalRule property for this object.
     *
     * @param contentRetrievalRule
     *        The new value for the ContentRetrievalRule property for this object.
     */
    public static RuleConfiguration fromContentRetrievalRule(Consumer<ContentRetrievalRule.Builder> contentRetrievalRule) {
        ContentRetrievalRule.Builder builder = ContentRetrievalRule.builder();
        contentRetrievalRule.accept(builder);
        return fromContentRetrievalRule(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentBlockerRule", CONTENT_BLOCKER_RULE_FIELD);
        map.put("contentRetrievalRule", CONTENT_RETRIEVAL_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleConfiguration, T> g) {
        return obj -> g.apply((RuleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleConfiguration> {
        /**
         * <p>
         * A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
         * </p>
         * 
         * @param contentBlockerRule
         *        A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentBlockerRule(ContentBlockerRule contentBlockerRule);

        /**
         * <p>
         * A rule for configuring how Amazon Q Business responds when it encounters a a blocked topic.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentBlockerRule.Builder} avoiding the
         * need to create one manually via {@link ContentBlockerRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentBlockerRule.Builder#build()} is called immediately and its
         * result is passed to {@link #contentBlockerRule(ContentBlockerRule)}.
         * 
         * @param contentBlockerRule
         *        a consumer that will call methods on {@link ContentBlockerRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentBlockerRule(ContentBlockerRule)
         */
        default Builder contentBlockerRule(Consumer<ContentBlockerRule.Builder> contentBlockerRule) {
            return contentBlockerRule(ContentBlockerRule.builder().applyMutation(contentBlockerRule).build());
        }

        /**
         * Sets the value of the ContentRetrievalRule property for this object.
         *
         * @param contentRetrievalRule
         *        The new value for the ContentRetrievalRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentRetrievalRule(ContentRetrievalRule contentRetrievalRule);

        /**
         * Sets the value of the ContentRetrievalRule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContentRetrievalRule.Builder} avoiding
         * the need to create one manually via {@link ContentRetrievalRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentRetrievalRule.Builder#build()} is called immediately and
         * its result is passed to {@link #contentRetrievalRule(ContentRetrievalRule)}.
         * 
         * @param contentRetrievalRule
         *        a consumer that will call methods on {@link ContentRetrievalRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentRetrievalRule(ContentRetrievalRule)
         */
        default Builder contentRetrievalRule(Consumer<ContentRetrievalRule.Builder> contentRetrievalRule) {
            return contentRetrievalRule(ContentRetrievalRule.builder().applyMutation(contentRetrievalRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContentBlockerRule contentBlockerRule;

        private ContentRetrievalRule contentRetrievalRule;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleConfiguration model) {
            contentBlockerRule(model.contentBlockerRule);
            contentRetrievalRule(model.contentRetrievalRule);
        }

        public final ContentBlockerRule.Builder getContentBlockerRule() {
            return contentBlockerRule != null ? contentBlockerRule.toBuilder() : null;
        }

        public final void setContentBlockerRule(ContentBlockerRule.BuilderImpl contentBlockerRule) {
            Object oldValue = this.contentBlockerRule;
            this.contentBlockerRule = contentBlockerRule != null ? contentBlockerRule.build() : null;
            handleUnionValueChange(Type.CONTENT_BLOCKER_RULE, oldValue, this.contentBlockerRule);
        }

        @Override
        public final Builder contentBlockerRule(ContentBlockerRule contentBlockerRule) {
            Object oldValue = this.contentBlockerRule;
            this.contentBlockerRule = contentBlockerRule;
            handleUnionValueChange(Type.CONTENT_BLOCKER_RULE, oldValue, this.contentBlockerRule);
            return this;
        }

        public final ContentRetrievalRule.Builder getContentRetrievalRule() {
            return contentRetrievalRule != null ? contentRetrievalRule.toBuilder() : null;
        }

        public final void setContentRetrievalRule(ContentRetrievalRule.BuilderImpl contentRetrievalRule) {
            Object oldValue = this.contentRetrievalRule;
            this.contentRetrievalRule = contentRetrievalRule != null ? contentRetrievalRule.build() : null;
            handleUnionValueChange(Type.CONTENT_RETRIEVAL_RULE, oldValue, this.contentRetrievalRule);
        }

        @Override
        public final Builder contentRetrievalRule(ContentRetrievalRule contentRetrievalRule) {
            Object oldValue = this.contentRetrievalRule;
            this.contentRetrievalRule = contentRetrievalRule;
            handleUnionValueChange(Type.CONTENT_RETRIEVAL_RULE, oldValue, this.contentRetrievalRule);
            return this;
        }

        @Override
        public RuleConfiguration build() {
            return new RuleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleConfiguration#type()
     */
    public enum Type {
        CONTENT_BLOCKER_RULE,

        CONTENT_RETRIEVAL_RULE,

        UNKNOWN_TO_SDK_VERSION
    }
}
