/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the SAML 2.0 compliant identity provider (IdP) configuration information Amazon Q Business needs to deploy a
 * Amazon Q Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SamlConfiguration.Builder, SamlConfiguration> {
    private static final SdkField<String> METADATA_XML_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataXML").getter(getter(SamlConfiguration::metadataXML)).setter(setter(Builder::metadataXML))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataXML").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(SamlConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> USER_ID_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userIdAttribute").getter(getter(SamlConfiguration::userIdAttribute))
            .setter(setter(Builder::userIdAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdAttribute").build()).build();

    private static final SdkField<String> USER_GROUP_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userGroupAttribute").getter(getter(SamlConfiguration::userGroupAttribute))
            .setter(setter(Builder::userGroupAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userGroupAttribute").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_XML_FIELD,
            ROLE_ARN_FIELD, USER_ID_ATTRIBUTE_FIELD, USER_GROUP_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metadataXML;

    private final String roleArn;

    private final String userIdAttribute;

    private final String userGroupAttribute;

    private SamlConfiguration(BuilderImpl builder) {
        this.metadataXML = builder.metadataXML;
        this.roleArn = builder.roleArn;
        this.userIdAttribute = builder.userIdAttribute;
        this.userGroupAttribute = builder.userGroupAttribute;
    }

    /**
     * <p>
     * The metadata XML that your IdP generated.
     * </p>
     * 
     * @return The metadata XML that your IdP generated.
     */
    public final String metadataXML() {
        return metadataXML;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role assumed by users when they authenticate into their Amazon Q
     * Business web experience, containing the relevant Amazon Q Business permissions for conversing with Amazon Q
     * Business.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role assumed by users when they authenticate into their Amazon Q
     *         Business web experience, containing the relevant Amazon Q Business permissions for conversing with Amazon
     *         Q Business.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The user attribute name in your IdP that maps to the user email.
     * </p>
     * 
     * @return The user attribute name in your IdP that maps to the user email.
     */
    public final String userIdAttribute() {
        return userIdAttribute;
    }

    /**
     * <p>
     * The group attribute name in your IdP that maps to user groups.
     * </p>
     * 
     * @return The group attribute name in your IdP that maps to user groups.
     */
    public final String userGroupAttribute() {
        return userGroupAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataXML());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(userIdAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlConfiguration)) {
            return false;
        }
        SamlConfiguration other = (SamlConfiguration) obj;
        return Objects.equals(metadataXML(), other.metadataXML()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(userIdAttribute(), other.userIdAttribute())
                && Objects.equals(userGroupAttribute(), other.userGroupAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamlConfiguration").add("MetadataXML", metadataXML()).add("RoleArn", roleArn())
                .add("UserIdAttribute", userIdAttribute()).add("UserGroupAttribute", userGroupAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataXML":
            return Optional.ofNullable(clazz.cast(metadataXML()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "userIdAttribute":
            return Optional.ofNullable(clazz.cast(userIdAttribute()));
        case "userGroupAttribute":
            return Optional.ofNullable(clazz.cast(userGroupAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataXML", METADATA_XML_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("userIdAttribute", USER_ID_ATTRIBUTE_FIELD);
        map.put("userGroupAttribute", USER_GROUP_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamlConfiguration, T> g) {
        return obj -> g.apply((SamlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamlConfiguration> {
        /**
         * <p>
         * The metadata XML that your IdP generated.
         * </p>
         * 
         * @param metadataXML
         *        The metadata XML that your IdP generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataXML(String metadataXML);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role assumed by users when they authenticate into their Amazon Q
         * Business web experience, containing the relevant Amazon Q Business permissions for conversing with Amazon Q
         * Business.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role assumed by users when they authenticate into their
         *        Amazon Q Business web experience, containing the relevant Amazon Q Business permissions for conversing
         *        with Amazon Q Business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The user attribute name in your IdP that maps to the user email.
         * </p>
         * 
         * @param userIdAttribute
         *        The user attribute name in your IdP that maps to the user email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdAttribute(String userIdAttribute);

        /**
         * <p>
         * The group attribute name in your IdP that maps to user groups.
         * </p>
         * 
         * @param userGroupAttribute
         *        The group attribute name in your IdP that maps to user groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupAttribute(String userGroupAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String metadataXML;

        private String roleArn;

        private String userIdAttribute;

        private String userGroupAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlConfiguration model) {
            metadataXML(model.metadataXML);
            roleArn(model.roleArn);
            userIdAttribute(model.userIdAttribute);
            userGroupAttribute(model.userGroupAttribute);
        }

        public final String getMetadataXML() {
            return metadataXML;
        }

        public final void setMetadataXML(String metadataXML) {
            this.metadataXML = metadataXML;
        }

        @Override
        public final Builder metadataXML(String metadataXML) {
            this.metadataXML = metadataXML;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getUserIdAttribute() {
            return userIdAttribute;
        }

        public final void setUserIdAttribute(String userIdAttribute) {
            this.userIdAttribute = userIdAttribute;
        }

        @Override
        public final Builder userIdAttribute(String userIdAttribute) {
            this.userIdAttribute = userIdAttribute;
            return this;
        }

        public final String getUserGroupAttribute() {
            return userGroupAttribute;
        }

        public final void setUserGroupAttribute(String userGroupAttribute) {
            this.userGroupAttribute = userGroupAttribute;
        }

        @Override
        public final Builder userGroupAttribute(String userGroupAttribute) {
            this.userGroupAttribute = userGroupAttribute;
            return this;
        }

        @Override
        public SamlConfiguration build() {
            return new SamlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
