/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on boosting <code>STRING_LIST</code> type document attributes.
 * </p>
 * <note>
 * <p>
 * For <code>STRING</code> and <code>STRING_LIST</code> type document attributes to be used for boosting on the console
 * and the API, they must be enabled for search using the <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html"
 * >DocumentAttributeConfiguration</a> object of the <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html">UpdateIndex</a> API. If you
 * haven't enabled searching on these attributes, you can't boost attributes of these data types on either the console
 * or the API.
 * </p>
 * </note>
 * <p>
 * For more information on how boosting document attributes work in Amazon Q Business, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html">Boosting using document
 * attributes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringListAttributeBoostingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StringListAttributeBoostingConfiguration.Builder, StringListAttributeBoostingConfiguration> {
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("boostingLevel").getter(getter(StringListAttributeBoostingConfiguration::boostingLevelAsString))
            .setter(setter(Builder::boostingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String boostingLevel;

    private StringListAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingLevel = builder.boostingLevel;
    }

    /**
     * <p>
     * Specifies how much a document attribute is boosted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingLevel}
     * will return {@link DocumentAttributeBoostingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #boostingLevelAsString}.
     * </p>
     * 
     * @return Specifies how much a document attribute is boosted.
     * @see DocumentAttributeBoostingLevel
     */
    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(boostingLevel);
    }

    /**
     * <p>
     * Specifies how much a document attribute is boosted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #boostingLevel}
     * will return {@link DocumentAttributeBoostingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #boostingLevelAsString}.
     * </p>
     * 
     * @return Specifies how much a document attribute is boosted.
     * @see DocumentAttributeBoostingLevel
     */
    public final String boostingLevelAsString() {
        return boostingLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boostingLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringListAttributeBoostingConfiguration)) {
            return false;
        }
        StringListAttributeBoostingConfiguration other = (StringListAttributeBoostingConfiguration) obj;
        return Objects.equals(boostingLevelAsString(), other.boostingLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringListAttributeBoostingConfiguration").add("BoostingLevel", boostingLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "boostingLevel":
            return Optional.ofNullable(clazz.cast(boostingLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("boostingLevel", BOOSTING_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringListAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((StringListAttributeBoostingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringListAttributeBoostingConfiguration> {
        /**
         * <p>
         * Specifies how much a document attribute is boosted.
         * </p>
         * 
         * @param boostingLevel
         *        Specifies how much a document attribute is boosted.
         * @see DocumentAttributeBoostingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeBoostingLevel
         */
        Builder boostingLevel(String boostingLevel);

        /**
         * <p>
         * Specifies how much a document attribute is boosted.
         * </p>
         * 
         * @param boostingLevel
         *        Specifies how much a document attribute is boosted.
         * @see DocumentAttributeBoostingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeBoostingLevel
         */
        Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel);
    }

    static final class BuilderImpl implements Builder {
        private String boostingLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(StringListAttributeBoostingConfiguration model) {
            boostingLevel(model.boostingLevel);
        }

        public final String getBoostingLevel() {
            return boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        @Override
        public StringListAttributeBoostingConfiguration build() {
            return new StringListAttributeBoostingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
