/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a text extract in a chat response that can be attributed to a source document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextSegment implements SdkPojo, Serializable, ToCopyableBuilder<TextSegment.Builder, TextSegment> {
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("beginOffset").getter(getter(TextSegment::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endOffset").getter(getter(TextSegment::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOffset").build()).build();

    private static final SdkField<SnippetExcerpt> SNIPPET_EXCERPT_FIELD = SdkField
            .<SnippetExcerpt> builder(MarshallingType.SDK_POJO).memberName("snippetExcerpt")
            .getter(getter(TextSegment::snippetExcerpt)).setter(setter(Builder::snippetExcerpt))
            .constructor(SnippetExcerpt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snippetExcerpt").build()).build();

    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(TextSegment::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()).build();

    private static final SdkField<String> MEDIA_MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaMimeType").getter(getter(TextSegment::mediaMimeType)).setter(setter(Builder::mediaMimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaMimeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_FIELD,
            END_OFFSET_FIELD, SNIPPET_EXCERPT_FIELD, MEDIA_ID_FIELD, MEDIA_MIME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final SnippetExcerpt snippetExcerpt;

    private final String mediaId;

    private final String mediaMimeType;

    private TextSegment(BuilderImpl builder) {
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.snippetExcerpt = builder.snippetExcerpt;
        this.mediaId = builder.mediaId;
        this.mediaMimeType = builder.mediaMimeType;
    }

    /**
     * <p>
     * The zero-based location in the response string where the source attribution starts.
     * </p>
     * 
     * @return The zero-based location in the response string where the source attribution starts.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The zero-based location in the response string where the source attribution ends.
     * </p>
     * 
     * @return The zero-based location in the response string where the source attribution ends.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon Q Business
     * chat response.
     * </p>
     * 
     * @return The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon Q
     *         Business chat response.
     */
    public final SnippetExcerpt snippetExcerpt() {
        return snippetExcerpt;
    }

    /**
     * <p>
     * The identifier of the media object associated with the text segment in the source attribution.
     * </p>
     * 
     * @return The identifier of the media object associated with the text segment in the source attribution.
     */
    public final String mediaId() {
        return mediaId;
    }

    /**
     * <p>
     * The MIME type (image/png) of the media object associated with the text segment in the source attribution.
     * </p>
     * 
     * @return The MIME type (image/png) of the media object associated with the text segment in the source attribution.
     */
    public final String mediaMimeType() {
        return mediaMimeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(snippetExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaMimeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextSegment)) {
            return false;
        }
        TextSegment other = (TextSegment) obj;
        return Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && Objects.equals(snippetExcerpt(), other.snippetExcerpt()) && Objects.equals(mediaId(), other.mediaId())
                && Objects.equals(mediaMimeType(), other.mediaMimeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextSegment").add("BeginOffset", beginOffset()).add("EndOffset", endOffset())
                .add("SnippetExcerpt", snippetExcerpt()).add("MediaId", mediaId()).add("MediaMimeType", mediaMimeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "beginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "endOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "snippetExcerpt":
            return Optional.ofNullable(clazz.cast(snippetExcerpt()));
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        case "mediaMimeType":
            return Optional.ofNullable(clazz.cast(mediaMimeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("beginOffset", BEGIN_OFFSET_FIELD);
        map.put("endOffset", END_OFFSET_FIELD);
        map.put("snippetExcerpt", SNIPPET_EXCERPT_FIELD);
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("mediaMimeType", MEDIA_MIME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextSegment, T> g) {
        return obj -> g.apply((TextSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextSegment> {
        /**
         * <p>
         * The zero-based location in the response string where the source attribution starts.
         * </p>
         * 
         * @param beginOffset
         *        The zero-based location in the response string where the source attribution starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The zero-based location in the response string where the source attribution ends.
         * </p>
         * 
         * @param endOffset
         *        The zero-based location in the response string where the source attribution ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon Q
         * Business chat response.
         * </p>
         * 
         * @param snippetExcerpt
         *        The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon
         *        Q Business chat response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snippetExcerpt(SnippetExcerpt snippetExcerpt);

        /**
         * <p>
         * The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon Q
         * Business chat response.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnippetExcerpt.Builder} avoiding the need
         * to create one manually via {@link SnippetExcerpt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnippetExcerpt.Builder#build()} is called immediately and its
         * result is passed to {@link #snippetExcerpt(SnippetExcerpt)}.
         * 
         * @param snippetExcerpt
         *        a consumer that will call methods on {@link SnippetExcerpt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snippetExcerpt(SnippetExcerpt)
         */
        default Builder snippetExcerpt(Consumer<SnippetExcerpt.Builder> snippetExcerpt) {
            return snippetExcerpt(SnippetExcerpt.builder().applyMutation(snippetExcerpt).build());
        }

        /**
         * <p>
         * The identifier of the media object associated with the text segment in the source attribution.
         * </p>
         * 
         * @param mediaId
         *        The identifier of the media object associated with the text segment in the source attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        /**
         * <p>
         * The MIME type (image/png) of the media object associated with the text segment in the source attribution.
         * </p>
         * 
         * @param mediaMimeType
         *        The MIME type (image/png) of the media object associated with the text segment in the source
         *        attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaMimeType(String mediaMimeType);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffset;

        private Integer endOffset;

        private SnippetExcerpt snippetExcerpt;

        private String mediaId;

        private String mediaMimeType;

        private BuilderImpl() {
        }

        private BuilderImpl(TextSegment model) {
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            snippetExcerpt(model.snippetExcerpt);
            mediaId(model.mediaId);
            mediaMimeType(model.mediaMimeType);
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final SnippetExcerpt.Builder getSnippetExcerpt() {
            return snippetExcerpt != null ? snippetExcerpt.toBuilder() : null;
        }

        public final void setSnippetExcerpt(SnippetExcerpt.BuilderImpl snippetExcerpt) {
            this.snippetExcerpt = snippetExcerpt != null ? snippetExcerpt.build() : null;
        }

        @Override
        public final Builder snippetExcerpt(SnippetExcerpt snippetExcerpt) {
            this.snippetExcerpt = snippetExcerpt;
            return this;
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getMediaMimeType() {
            return mediaMimeType;
        }

        public final void setMediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
        }

        @Override
        public final Builder mediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
            return this;
        }

        @Override
        public TextSegment build() {
            return new TextSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
