/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataAccessorRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateDataAccessorRequest.Builder, UpdateDataAccessorRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateDataAccessorRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DATA_ACCESSOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorId").getter(getter(UpdateDataAccessorRequest::dataAccessorId))
            .setter(setter(Builder::dataAccessorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataAccessorId").build()).build();

    private static final SdkField<List<ActionConfiguration>> ACTION_CONFIGURATIONS_FIELD = SdkField
            .<List<ActionConfiguration>> builder(MarshallingType.LIST)
            .memberName("actionConfigurations")
            .getter(getter(UpdateDataAccessorRequest::actionConfigurations))
            .setter(setter(Builder::actionConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateDataAccessorRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DATA_ACCESSOR_ID_FIELD, ACTION_CONFIGURATIONS_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String dataAccessorId;

    private final List<ActionConfiguration> actionConfigurations;

    private final String displayName;

    private UpdateDataAccessorRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataAccessorId = builder.dataAccessorId;
        this.actionConfigurations = builder.actionConfigurations;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The unique identifier of the Q Business application.
     * </p>
     * 
     * @return The unique identifier of the Q Business application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier of the data accessor to update.
     * </p>
     * 
     * @return The unique identifier of the data accessor to update.
     */
    public final String dataAccessorId() {
        return dataAccessorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionConfigurations() {
        return actionConfigurations != null && !(actionConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of action configurations specifying the allowed actions and any associated filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionConfigurations} method.
     * </p>
     * 
     * @return The updated list of action configurations specifying the allowed actions and any associated filters.
     */
    public final List<ActionConfiguration> actionConfigurations() {
        return actionConfigurations;
    }

    /**
     * <p>
     * The updated friendly name for the data accessor.
     * </p>
     * 
     * @return The updated friendly name for the data accessor.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionConfigurations() ? actionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataAccessorRequest)) {
            return false;
        }
        UpdateDataAccessorRequest other = (UpdateDataAccessorRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(dataAccessorId(), other.dataAccessorId())
                && hasActionConfigurations() == other.hasActionConfigurations()
                && Objects.equals(actionConfigurations(), other.actionConfigurations())
                && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataAccessorRequest").add("ApplicationId", applicationId())
                .add("DataAccessorId", dataAccessorId())
                .add("ActionConfigurations", hasActionConfigurations() ? actionConfigurations() : null)
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "dataAccessorId":
            return Optional.ofNullable(clazz.cast(dataAccessorId()));
        case "actionConfigurations":
            return Optional.ofNullable(clazz.cast(actionConfigurations()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("dataAccessorId", DATA_ACCESSOR_ID_FIELD);
        map.put("actionConfigurations", ACTION_CONFIGURATIONS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataAccessorRequest, T> g) {
        return obj -> g.apply((UpdateDataAccessorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataAccessorRequest> {
        /**
         * <p>
         * The unique identifier of the Q Business application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier of the data accessor to update.
         * </p>
         * 
         * @param dataAccessorId
         *        The unique identifier of the data accessor to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorId(String dataAccessorId);

        /**
         * <p>
         * The updated list of action configurations specifying the allowed actions and any associated filters.
         * </p>
         * 
         * @param actionConfigurations
         *        The updated list of action configurations specifying the allowed actions and any associated filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations);

        /**
         * <p>
         * The updated list of action configurations specifying the allowed actions and any associated filters.
         * </p>
         * 
         * @param actionConfigurations
         *        The updated list of action configurations specifying the allowed actions and any associated filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfigurations(ActionConfiguration... actionConfigurations);

        /**
         * <p>
         * The updated list of action configurations specifying the allowed actions and any associated filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #actionConfigurations(List<ActionConfiguration>)}.
         * 
         * @param actionConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.ActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionConfigurations(java.util.Collection<ActionConfiguration>)
         */
        Builder actionConfigurations(Consumer<ActionConfiguration.Builder>... actionConfigurations);

        /**
         * <p>
         * The updated friendly name for the data accessor.
         * </p>
         * 
         * @param displayName
         *        The updated friendly name for the data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String dataAccessorId;

        private List<ActionConfiguration> actionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataAccessorRequest model) {
            super(model);
            applicationId(model.applicationId);
            dataAccessorId(model.dataAccessorId);
            actionConfigurations(model.actionConfigurations);
            displayName(model.displayName);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataAccessorId() {
            return dataAccessorId;
        }

        public final void setDataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
        }

        @Override
        public final Builder dataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        public final List<ActionConfiguration.Builder> getActionConfigurations() {
            List<ActionConfiguration.Builder> result = ActionConfigurationListCopier.copyToBuilder(this.actionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConfigurations(Collection<ActionConfiguration.BuilderImpl> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copyFromBuilder(actionConfigurations);
        }

        @Override
        public final Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copy(actionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(ActionConfiguration... actionConfigurations) {
            actionConfigurations(Arrays.asList(actionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(Consumer<ActionConfiguration.Builder>... actionConfigurations) {
            actionConfigurations(Stream.of(actionConfigurations).map(c -> ActionConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataAccessorRequest build() {
            return new UpdateDataAccessorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
