/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateUserRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(UpdateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final SdkField<List<UserAlias>> USER_ALIASES_TO_UPDATE_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliasesToUpdate")
            .getter(getter(UpdateUserRequest::userAliasesToUpdate))
            .setter(setter(Builder::userAliasesToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesToUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UserAlias>> USER_ALIASES_TO_DELETE_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliasesToDelete")
            .getter(getter(UpdateUserRequest::userAliasesToDelete))
            .setter(setter(Builder::userAliasesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            USER_ID_FIELD, USER_ALIASES_TO_UPDATE_FIELD, USER_ALIASES_TO_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String userId;

    private final List<UserAlias> userAliasesToUpdate;

    private final List<UserAlias> userAliasesToDelete;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.userAliasesToUpdate = builder.userAliasesToUpdate;
        this.userAliasesToDelete = builder.userAliasesToDelete;
    }

    /**
     * <p>
     * The identifier of the application the user is attached to.
     * </p>
     * 
     * @return The identifier of the application the user is attached to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The email id attached to the user.
     * </p>
     * 
     * @return The email id attached to the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliasesToUpdate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliasesToUpdate() {
        return userAliasesToUpdate != null && !(userAliasesToUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user aliases attached to the user id that are to be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliasesToUpdate} method.
     * </p>
     * 
     * @return The user aliases attached to the user id that are to be updated.
     */
    public final List<UserAlias> userAliasesToUpdate() {
        return userAliasesToUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliasesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliasesToDelete() {
        return userAliasesToDelete != null && !(userAliasesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user aliases attached to the user id that are to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliasesToDelete} method.
     * </p>
     * 
     * @return The user aliases attached to the user id that are to be deleted.
     */
    public final List<UserAlias> userAliasesToDelete() {
        return userAliasesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliasesToUpdate() ? userAliasesToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliasesToDelete() ? userAliasesToDelete() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(userId(), other.userId())
                && hasUserAliasesToUpdate() == other.hasUserAliasesToUpdate()
                && Objects.equals(userAliasesToUpdate(), other.userAliasesToUpdate())
                && hasUserAliasesToDelete() == other.hasUserAliasesToDelete()
                && Objects.equals(userAliasesToDelete(), other.userAliasesToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest").add("ApplicationId", applicationId()).add("UserId", userId())
                .add("UserAliasesToUpdate", hasUserAliasesToUpdate() ? userAliasesToUpdate() : null)
                .add("UserAliasesToDelete", hasUserAliasesToDelete() ? userAliasesToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userAliasesToUpdate":
            return Optional.ofNullable(clazz.cast(userAliasesToUpdate()));
        case "userAliasesToDelete":
            return Optional.ofNullable(clazz.cast(userAliasesToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("userAliasesToUpdate", USER_ALIASES_TO_UPDATE_FIELD);
        map.put("userAliasesToDelete", USER_ALIASES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The identifier of the application the user is attached to.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application the user is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The email id attached to the user.
         * </p>
         * 
         * @param userId
         *        The email id attached to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The user aliases attached to the user id that are to be updated.
         * </p>
         * 
         * @param userAliasesToUpdate
         *        The user aliases attached to the user id that are to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesToUpdate(Collection<UserAlias> userAliasesToUpdate);

        /**
         * <p>
         * The user aliases attached to the user id that are to be updated.
         * </p>
         * 
         * @param userAliasesToUpdate
         *        The user aliases attached to the user id that are to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesToUpdate(UserAlias... userAliasesToUpdate);

        /**
         * <p>
         * The user aliases attached to the user id that are to be updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliasesToUpdate(List<UserAlias>)}.
         * 
         * @param userAliasesToUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliasesToUpdate(java.util.Collection<UserAlias>)
         */
        Builder userAliasesToUpdate(Consumer<UserAlias.Builder>... userAliasesToUpdate);

        /**
         * <p>
         * The user aliases attached to the user id that are to be deleted.
         * </p>
         * 
         * @param userAliasesToDelete
         *        The user aliases attached to the user id that are to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesToDelete(Collection<UserAlias> userAliasesToDelete);

        /**
         * <p>
         * The user aliases attached to the user id that are to be deleted.
         * </p>
         * 
         * @param userAliasesToDelete
         *        The user aliases attached to the user id that are to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliasesToDelete(UserAlias... userAliasesToDelete);

        /**
         * <p>
         * The user aliases attached to the user id that are to be deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliasesToDelete(List<UserAlias>)}.
         * 
         * @param userAliasesToDelete
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliasesToDelete(java.util.Collection<UserAlias>)
         */
        Builder userAliasesToDelete(Consumer<UserAlias.Builder>... userAliasesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String userId;

        private List<UserAlias> userAliasesToUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<UserAlias> userAliasesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            applicationId(model.applicationId);
            userId(model.userId);
            userAliasesToUpdate(model.userAliasesToUpdate);
            userAliasesToDelete(model.userAliasesToDelete);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<UserAlias.Builder> getUserAliasesToUpdate() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesToUpdate(Collection<UserAlias.BuilderImpl> userAliasesToUpdate) {
            this.userAliasesToUpdate = UserAliasesCopier.copyFromBuilder(userAliasesToUpdate);
        }

        @Override
        public final Builder userAliasesToUpdate(Collection<UserAlias> userAliasesToUpdate) {
            this.userAliasesToUpdate = UserAliasesCopier.copy(userAliasesToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToUpdate(UserAlias... userAliasesToUpdate) {
            userAliasesToUpdate(Arrays.asList(userAliasesToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToUpdate(Consumer<UserAlias.Builder>... userAliasesToUpdate) {
            userAliasesToUpdate(Stream.of(userAliasesToUpdate).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UserAlias.Builder> getUserAliasesToDelete() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesToDelete(Collection<UserAlias.BuilderImpl> userAliasesToDelete) {
            this.userAliasesToDelete = UserAliasesCopier.copyFromBuilder(userAliasesToDelete);
        }

        @Override
        public final Builder userAliasesToDelete(Collection<UserAlias> userAliasesToDelete) {
            this.userAliasesToDelete = UserAliasesCopier.copy(userAliasesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToDelete(UserAlias... userAliasesToDelete) {
            userAliasesToDelete(Arrays.asList(userAliasesToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToDelete(Consumer<UserAlias.Builder>... userAliasesToDelete) {
            userAliasesToDelete(Stream.of(userAliasesToDelete).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
