/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebExperienceRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateWebExperienceRequest.Builder, UpdateWebExperienceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateWebExperienceRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceId").getter(getter(UpdateWebExperienceRequest::webExperienceId))
            .setter(setter(Builder::webExperienceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("webExperienceId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateWebExperienceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<WebExperienceAuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<WebExperienceAuthConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("authenticationConfiguration")
            .getter(getter(UpdateWebExperienceRequest::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(WebExperienceAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration")
                    .build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(UpdateWebExperienceRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> SUBTITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subtitle").getter(getter(UpdateWebExperienceRequest::subtitle)).setter(setter(Builder::subtitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()).build();

    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("welcomeMessage").getter(getter(UpdateWebExperienceRequest::welcomeMessage))
            .setter(setter(Builder::welcomeMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()).build();

    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samplePromptsControlMode").getter(getter(UpdateWebExperienceRequest::samplePromptsControlModeAsString))
            .setter(setter(Builder::samplePromptsControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build())
            .build();

    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField
            .<IdentityProviderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("identityProviderConfiguration")
            .getter(getter(UpdateWebExperienceRequest::identityProviderConfiguration))
            .setter(setter(Builder::identityProviderConfiguration))
            .constructor(IdentityProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfiguration")
                    .build()).build();

    private static final SdkField<List<String>> ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("origins")
            .getter(getter(UpdateWebExperienceRequest::origins))
            .setter(setter(Builder::origins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BrowserExtensionConfiguration> BROWSER_EXTENSION_CONFIGURATION_FIELD = SdkField
            .<BrowserExtensionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("browserExtensionConfiguration")
            .getter(getter(UpdateWebExperienceRequest::browserExtensionConfiguration))
            .setter(setter(Builder::browserExtensionConfiguration))
            .constructor(BrowserExtensionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserExtensionConfiguration")
                    .build()).build();

    private static final SdkField<CustomizationConfiguration> CUSTOMIZATION_CONFIGURATION_FIELD = SdkField
            .<CustomizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("customizationConfiguration")
            .getter(getter(UpdateWebExperienceRequest::customizationConfiguration))
            .setter(setter(Builder::customizationConfiguration))
            .constructor(CustomizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            WEB_EXPERIENCE_ID_FIELD, ROLE_ARN_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, TITLE_FIELD, SUBTITLE_FIELD,
            WELCOME_MESSAGE_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD, ORIGINS_FIELD,
            BROWSER_EXTENSION_CONFIGURATION_FIELD, CUSTOMIZATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String webExperienceId;

    private final String roleArn;

    private final WebExperienceAuthConfiguration authenticationConfiguration;

    private final String title;

    private final String subtitle;

    private final String welcomeMessage;

    private final String samplePromptsControlMode;

    private final IdentityProviderConfiguration identityProviderConfiguration;

    private final List<String> origins;

    private final BrowserExtensionConfiguration browserExtensionConfiguration;

    private final CustomizationConfiguration customizationConfiguration;

    private UpdateWebExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.webExperienceId = builder.webExperienceId;
        this.roleArn = builder.roleArn;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.welcomeMessage = builder.welcomeMessage;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
        this.origins = builder.origins;
        this.browserExtensionConfiguration = builder.browserExtensionConfiguration;
        this.customizationConfiguration = builder.customizationConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application attached to the web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application attached to the web experience.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business web experience.
     */
    public final String webExperienceId() {
        return webExperienceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role with permission to access the Amazon Q Business web experience and
     * required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role with permission to access the Amazon Q Business web experience
     *         and required resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The authentication configuration of the Amazon Q Business web experience.
     * </p>
     * 
     * @return The authentication configuration of the Amazon Q Business web experience.
     * @deprecated Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity Center
     *             for user management.
     */
    @Deprecated
    public final WebExperienceAuthConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * The title of the Amazon Q Business web experience.
     * </p>
     * 
     * @return The title of the Amazon Q Business web experience.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The subtitle of the Amazon Q Business web experience.
     * </p>
     * 
     * @return The subtitle of the Amazon Q Business web experience.
     */
    public final String subtitle() {
        return subtitle;
    }

    /**
     * <p>
     * A customized welcome message for an end user in an Amazon Q Business web experience.
     * </p>
     * 
     * @return A customized welcome message for an end user in an Amazon Q Business web experience.
     */
    public final String welcomeMessage() {
        return welcomeMessage;
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(samplePromptsControlMode);
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final String samplePromptsControlModeAsString() {
        return samplePromptsControlMode;
    }

    /**
     * <p>
     * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
     * experience.
     * </p>
     * 
     * @return Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
     *         experience.
     */
    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return identityProviderConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Origins property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOrigins() {
        return origins != null && !(origins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates the website domain origins that are allowed to embed the Amazon Q Business web experience.
     * 
     * <pre>
     * <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the &lt;i&gt;base URL&lt;/i&gt; for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified).&lt;/p&gt; &lt;note&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;Any values except &lt;code&gt;null&lt;/code&gt; submitted as part of this update will replace all previous values.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You must only submit a &lt;i&gt;base URL&lt;/i&gt; and not a full path. For example, &lt;code&gt;https://docs.aws.amazon.com&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code>
     * </pre>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrigins} method.
     * </p>
     * 
     * @return Updates the website domain origins that are allowed to embed the Amazon Q Business web experience.
     * 
     * <pre><code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the &lt;i&gt;base URL&lt;/i&gt; for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified).&lt;/p&gt; &lt;note&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;Any values except &lt;code&gt;null&lt;/code&gt; submitted as part of this update will replace all previous values.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You must only submit a &lt;i&gt;base URL&lt;/i&gt; and not a full path. For example, &lt;code&gt;https://docs.aws.amazon.com&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code>
     */
    public final List<String> origins() {
        return origins;
    }

    /**
     * <p>
     * The browser extension configuration for an Amazon Q Business web experience.
     * </p>
     * <note>
     * <p>
     * For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP administrator
     * must add the browser extension sign-in redirect URLs to the IdP application. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html">Configure external OIDC
     * identity provider for your browser extensions.</a>.
     * </p>
     * </note>
     * 
     * @return The browser extension configuration for an Amazon Q Business web experience.</p> <note>
     *         <p>
     *         For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP
     *         administrator must add the browser extension sign-in redirect URLs to the IdP application. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html">Configure external
     *         OIDC identity provider for your browser extensions.</a>.
     *         </p>
     */
    public final BrowserExtensionConfiguration browserExtensionConfiguration() {
        return browserExtensionConfiguration;
    }

    /**
     * <p>
     * Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
     * </p>
     * 
     * @return Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
     */
    public final CustomizationConfiguration customizationConfiguration() {
        return customizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(welcomeMessage());
        hashCode = 31 * hashCode + Objects.hashCode(samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrigins() ? origins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(browserExtensionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customizationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebExperienceRequest)) {
            return false;
        }
        UpdateWebExperienceRequest other = (UpdateWebExperienceRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(webExperienceId(), other.webExperienceId()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && Objects.equals(title(), other.title()) && Objects.equals(subtitle(), other.subtitle())
                && Objects.equals(welcomeMessage(), other.welcomeMessage())
                && Objects.equals(samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString())
                && Objects.equals(identityProviderConfiguration(), other.identityProviderConfiguration())
                && hasOrigins() == other.hasOrigins() && Objects.equals(origins(), other.origins())
                && Objects.equals(browserExtensionConfiguration(), other.browserExtensionConfiguration())
                && Objects.equals(customizationConfiguration(), other.customizationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWebExperienceRequest").add("ApplicationId", applicationId())
                .add("WebExperienceId", webExperienceId()).add("RoleArn", roleArn())
                .add("AuthenticationConfiguration", authenticationConfiguration()).add("Title", title())
                .add("Subtitle", subtitle()).add("WelcomeMessage", welcomeMessage())
                .add("SamplePromptsControlMode", samplePromptsControlModeAsString())
                .add("IdentityProviderConfiguration", identityProviderConfiguration())
                .add("Origins", hasOrigins() ? origins() : null)
                .add("BrowserExtensionConfiguration", browserExtensionConfiguration())
                .add("CustomizationConfiguration", customizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "webExperienceId":
            return Optional.ofNullable(clazz.cast(webExperienceId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "authenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "welcomeMessage":
            return Optional.ofNullable(clazz.cast(welcomeMessage()));
        case "samplePromptsControlMode":
            return Optional.ofNullable(clazz.cast(samplePromptsControlModeAsString()));
        case "identityProviderConfiguration":
            return Optional.ofNullable(clazz.cast(identityProviderConfiguration()));
        case "origins":
            return Optional.ofNullable(clazz.cast(origins()));
        case "browserExtensionConfiguration":
            return Optional.ofNullable(clazz.cast(browserExtensionConfiguration()));
        case "customizationConfiguration":
            return Optional.ofNullable(clazz.cast(customizationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("webExperienceId", WEB_EXPERIENCE_ID_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("subtitle", SUBTITLE_FIELD);
        map.put("welcomeMessage", WELCOME_MESSAGE_FIELD);
        map.put("samplePromptsControlMode", SAMPLE_PROMPTS_CONTROL_MODE_FIELD);
        map.put("identityProviderConfiguration", IDENTITY_PROVIDER_CONFIGURATION_FIELD);
        map.put("origins", ORIGINS_FIELD);
        map.put("browserExtensionConfiguration", BROWSER_EXTENSION_CONFIGURATION_FIELD);
        map.put("customizationConfiguration", CUSTOMIZATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebExperienceRequest, T> g) {
        return obj -> g.apply((UpdateWebExperienceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebExperienceRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application attached to the web experience.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application attached to the web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the Amazon Q Business web experience.
         * </p>
         * 
         * @param webExperienceId
         *        The identifier of the Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceId(String webExperienceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role with permission to access the Amazon Q Business web experience and
         * required resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role with permission to access the Amazon Q Business web
         *        experience and required resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The authentication configuration of the Amazon Q Business web experience.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration of the Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity
         *             Center for user management.
         */
        @Deprecated
        Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration of the Amazon Q Business web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebExperienceAuthConfiguration.Builder}
         * avoiding the need to create one manually via {@link WebExperienceAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebExperienceAuthConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(WebExperienceAuthConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link WebExperienceAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(WebExperienceAuthConfiguration)
         * @deprecated Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity
         *             Center for user management.
         */
        @Deprecated
        default Builder authenticationConfiguration(Consumer<WebExperienceAuthConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(WebExperienceAuthConfiguration.builder()
                    .applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * The title of the Amazon Q Business web experience.
         * </p>
         * 
         * @param title
         *        The title of the Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The subtitle of the Amazon Q Business web experience.
         * </p>
         * 
         * @param subtitle
         *        The subtitle of the Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(String subtitle);

        /**
         * <p>
         * A customized welcome message for an end user in an Amazon Q Business web experience.
         * </p>
         * 
         * @param welcomeMessage
         *        A customized welcome message for an end user in an Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeMessage(String welcomeMessage);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(String samplePromptsControlMode);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode);

        /**
         * <p>
         * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
         * experience.
         * </p>
         * 
         * @param identityProviderConfiguration
         *        Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business
         *        web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration);

        /**
         * <p>
         * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web
         * experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderConfiguration.Builder}
         * avoiding the need to create one manually via {@link IdentityProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProviderConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderConfiguration(IdentityProviderConfiguration)}.
         * 
         * @param identityProviderConfiguration
         *        a consumer that will call methods on {@link IdentityProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfiguration(IdentityProviderConfiguration)
         */
        default Builder identityProviderConfiguration(
                Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return identityProviderConfiguration(IdentityProviderConfiguration.builder()
                    .applyMutation(identityProviderConfiguration).build());
        }

        /**
         * <p>
         * Updates the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         * <pre>
         * <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the &lt;i&gt;base URL&lt;/i&gt; for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified).&lt;/p&gt; &lt;note&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;Any values except &lt;code&gt;null&lt;/code&gt; submitted as part of this update will replace all previous values.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You must only submit a &lt;i&gt;base URL&lt;/i&gt; and not a full path. For example, &lt;code&gt;https://docs.aws.amazon.com&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code>
         * </pre>
         * 
         * @param origins
         *        Updates the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         *        <pre>
         * 
         *        <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the &lt;i&gt;base URL&lt;/i&gt; for accessing a
         *        website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port
         *        number (if specified).&lt;/p&gt; &lt;note&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;Any values except
         *        &lt;code&gt;null&lt;/code&gt; submitted as part of this update will replace all previous
         *        values.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You must only submit a &lt;i&gt;base URL&lt;/i&gt;
         *        and not a full path. For example, &lt;code&gt;https://docs.aws.amazon.com&lt;/code&gt;.&lt;/p&gt;
         *        &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code> @return Returns a reference to this object so that
         *        method calls can be chained together.
         */
        Builder origins(Collection<String> origins);

        /**
         * <p>
         * Updates the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         * <pre>
         * <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the &lt;i&gt;base URL&lt;/i&gt; for accessing a website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port number (if specified).&lt;/p&gt; &lt;note&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;Any values except &lt;code&gt;null&lt;/code&gt; submitted as part of this update will replace all previous values.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You must only submit a &lt;i&gt;base URL&lt;/i&gt; and not a full path. For example, &lt;code&gt;https://docs.aws.amazon.com&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code>
         * </pre>
         * 
         * @param origins
         *        Updates the website domain origins that are allowed to embed the Amazon Q Business web experience.
         * 
         *        <pre>
         * 
         *        <code> The &lt;i&gt;domain origin&lt;/i&gt; refers to the &lt;i&gt;base URL&lt;/i&gt; for accessing a
         *        website including the protocol (&lt;code&gt;http/https&lt;/code&gt;), the domain name, and the port
         *        number (if specified).&lt;/p&gt; &lt;note&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;Any values except
         *        &lt;code&gt;null&lt;/code&gt; submitted as part of this update will replace all previous
         *        values.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You must only submit a &lt;i&gt;base URL&lt;/i&gt;
         *        and not a full path. For example, &lt;code&gt;https://docs.aws.amazon.com&lt;/code&gt;.&lt;/p&gt;
         *        &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code> @return Returns a reference to this object so that
         *        method calls can be chained together.
         */
        Builder origins(String... origins);

        /**
         * <p>
         * The browser extension configuration for an Amazon Q Business web experience.
         * </p>
         * <note>
         * <p>
         * For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP
         * administrator must add the browser extension sign-in redirect URLs to the IdP application. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html">Configure external
         * OIDC identity provider for your browser extensions.</a>.
         * </p>
         * </note>
         * 
         * @param browserExtensionConfiguration
         *        The browser extension configuration for an Amazon Q Business web experience.</p> <note>
         *        <p>
         *        For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP
         *        administrator must add the browser extension sign-in redirect URLs to the IdP application. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html">Configure
         *        external OIDC identity provider for your browser extensions.</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserExtensionConfiguration(BrowserExtensionConfiguration browserExtensionConfiguration);

        /**
         * <p>
         * The browser extension configuration for an Amazon Q Business web experience.
         * </p>
         * <note>
         * <p>
         * For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP
         * administrator must add the browser extension sign-in redirect URLs to the IdP application. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html">Configure external
         * OIDC identity provider for your browser extensions.</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link BrowserExtensionConfiguration.Builder} avoiding the need to create one manually via
         * {@link BrowserExtensionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrowserExtensionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #browserExtensionConfiguration(BrowserExtensionConfiguration)}.
         * 
         * @param browserExtensionConfiguration
         *        a consumer that will call methods on {@link BrowserExtensionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #browserExtensionConfiguration(BrowserExtensionConfiguration)
         */
        default Builder browserExtensionConfiguration(
                Consumer<BrowserExtensionConfiguration.Builder> browserExtensionConfiguration) {
            return browserExtensionConfiguration(BrowserExtensionConfiguration.builder()
                    .applyMutation(browserExtensionConfiguration).build());
        }

        /**
         * <p>
         * Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
         * </p>
         * 
         * @param customizationConfiguration
         *        Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizationConfiguration(CustomizationConfiguration customizationConfiguration);

        /**
         * <p>
         * Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customizationConfiguration(CustomizationConfiguration)}.
         * 
         * @param customizationConfiguration
         *        a consumer that will call methods on {@link CustomizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizationConfiguration(CustomizationConfiguration)
         */
        default Builder customizationConfiguration(Consumer<CustomizationConfiguration.Builder> customizationConfiguration) {
            return customizationConfiguration(CustomizationConfiguration.builder().applyMutation(customizationConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String webExperienceId;

        private String roleArn;

        private WebExperienceAuthConfiguration authenticationConfiguration;

        private String title;

        private String subtitle;

        private String welcomeMessage;

        private String samplePromptsControlMode;

        private IdentityProviderConfiguration identityProviderConfiguration;

        private List<String> origins = DefaultSdkAutoConstructList.getInstance();

        private BrowserExtensionConfiguration browserExtensionConfiguration;

        private CustomizationConfiguration customizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebExperienceRequest model) {
            super(model);
            applicationId(model.applicationId);
            webExperienceId(model.webExperienceId);
            roleArn(model.roleArn);
            authenticationConfiguration(model.authenticationConfiguration);
            title(model.title);
            subtitle(model.subtitle);
            welcomeMessage(model.welcomeMessage);
            samplePromptsControlMode(model.samplePromptsControlMode);
            identityProviderConfiguration(model.identityProviderConfiguration);
            origins(model.origins);
            browserExtensionConfiguration(model.browserExtensionConfiguration);
            customizationConfiguration(model.customizationConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getWebExperienceId() {
            return webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Deprecated
        public final WebExperienceAuthConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setAuthenticationConfiguration(WebExperienceAuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder authenticationConfiguration(WebExperienceAuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSubtitle() {
            return subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final String getWelcomeMessage() {
            return welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return identityProviderConfiguration != null ? identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build()
                    : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        public final Collection<String> getOrigins() {
            if (origins instanceof SdkAutoConstructList) {
                return null;
            }
            return origins;
        }

        public final void setOrigins(Collection<String> origins) {
            this.origins = WebExperienceOriginsCopier.copy(origins);
        }

        @Override
        public final Builder origins(Collection<String> origins) {
            this.origins = WebExperienceOriginsCopier.copy(origins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origins(String... origins) {
            origins(Arrays.asList(origins));
            return this;
        }

        public final BrowserExtensionConfiguration.Builder getBrowserExtensionConfiguration() {
            return browserExtensionConfiguration != null ? browserExtensionConfiguration.toBuilder() : null;
        }

        public final void setBrowserExtensionConfiguration(BrowserExtensionConfiguration.BuilderImpl browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration != null ? browserExtensionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder browserExtensionConfiguration(BrowserExtensionConfiguration browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration;
            return this;
        }

        public final CustomizationConfiguration.Builder getCustomizationConfiguration() {
            return customizationConfiguration != null ? customizationConfiguration.toBuilder() : null;
        }

        public final void setCustomizationConfiguration(CustomizationConfiguration.BuilderImpl customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration != null ? customizationConfiguration.build() : null;
        }

        @Override
        public final Builder customizationConfiguration(CustomizationConfiguration customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebExperienceRequest build() {
            return new UpdateWebExperienceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
