/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for an Amazon Q Business web experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebExperience implements SdkPojo, Serializable, ToCopyableBuilder<WebExperience.Builder, WebExperience> {
    private static final SdkField<String> WEB_EXPERIENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webExperienceId").getter(getter(WebExperience::webExperienceId))
            .setter(setter(Builder::webExperienceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperienceId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(WebExperience::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(WebExperience::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> DEFAULT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultEndpoint").getter(getter(WebExperience::defaultEndpoint))
            .setter(setter(Builder::defaultEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultEndpoint").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WebExperience::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_EXPERIENCE_ID_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, DEFAULT_ENDPOINT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String webExperienceId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String defaultEndpoint;

    private final String status;

    private WebExperience(BuilderImpl builder) {
        this.webExperienceId = builder.webExperienceId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.defaultEndpoint = builder.defaultEndpoint;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of your Amazon Q Business web experience.
     * </p>
     * 
     * @return The identifier of your Amazon Q Business web experience.
     */
    public final String webExperienceId() {
        return webExperienceId;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when your Amazon Q Business web experience was updated.
     * </p>
     * 
     * @return The Unix timestamp when your Amazon Q Business web experience was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The endpoint URLs for your Amazon Q Business web experience. The URLs are unique and fully hosted by Amazon Web
     * Services.
     * </p>
     * 
     * @return The endpoint URLs for your Amazon Q Business web experience. The URLs are unique and fully hosted by
     *         Amazon Web Services.
     */
    public final String defaultEndpoint() {
        return defaultEndpoint;
    }

    /**
     * <p>
     * The status of your Amazon Q Business web experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WebExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your Amazon Q Business web experience.
     * @see WebExperienceStatus
     */
    public final WebExperienceStatus status() {
        return WebExperienceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of your Amazon Q Business web experience.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WebExperienceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your Amazon Q Business web experience.
     * @see WebExperienceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webExperienceId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebExperience)) {
            return false;
        }
        WebExperience other = (WebExperience) obj;
        return Objects.equals(webExperienceId(), other.webExperienceId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(defaultEndpoint(), other.defaultEndpoint())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebExperience").add("WebExperienceId", webExperienceId()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("DefaultEndpoint", defaultEndpoint()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webExperienceId":
            return Optional.ofNullable(clazz.cast(webExperienceId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "defaultEndpoint":
            return Optional.ofNullable(clazz.cast(defaultEndpoint()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("webExperienceId", WEB_EXPERIENCE_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("defaultEndpoint", DEFAULT_ENDPOINT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebExperience, T> g) {
        return obj -> g.apply((WebExperience) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebExperience> {
        /**
         * <p>
         * The identifier of your Amazon Q Business web experience.
         * </p>
         * 
         * @param webExperienceId
         *        The identifier of your Amazon Q Business web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperienceId(String webExperienceId);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was last updated.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q Business application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when your Amazon Q Business web experience was updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when your Amazon Q Business web experience was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The endpoint URLs for your Amazon Q Business web experience. The URLs are unique and fully hosted by Amazon
         * Web Services.
         * </p>
         * 
         * @param defaultEndpoint
         *        The endpoint URLs for your Amazon Q Business web experience. The URLs are unique and fully hosted by
         *        Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEndpoint(String defaultEndpoint);

        /**
         * <p>
         * The status of your Amazon Q Business web experience.
         * </p>
         * 
         * @param status
         *        The status of your Amazon Q Business web experience.
         * @see WebExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of your Amazon Q Business web experience.
         * </p>
         * 
         * @param status
         *        The status of your Amazon Q Business web experience.
         * @see WebExperienceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceStatus
         */
        Builder status(WebExperienceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String webExperienceId;

        private Instant createdAt;

        private Instant updatedAt;

        private String defaultEndpoint;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(WebExperience model) {
            webExperienceId(model.webExperienceId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            defaultEndpoint(model.defaultEndpoint);
            status(model.status);
        }

        public final String getWebExperienceId() {
            return webExperienceId;
        }

        public final void setWebExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
        }

        @Override
        public final Builder webExperienceId(String webExperienceId) {
            this.webExperienceId = webExperienceId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDefaultEndpoint() {
            return defaultEndpoint;
        }

        public final void setDefaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
        }

        @Override
        public final Builder defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WebExperienceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public WebExperience build() {
            return new WebExperience(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
