/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.S3;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class APISchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, APISchema> {
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payload").getter(APISchema.getter(APISchema::payload)).setter(APISchema.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<S3> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(APISchema.getter(APISchema::s3)).setter(APISchema.setter(Builder::s3)).constructor(S3::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FIELD, S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = APISchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String payload;
    private final S3 s3;
    private final Type type;

    private APISchema(BuilderImpl builder) {
        this.payload = builder.payload;
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    public final String payload() {
        return this.payload;
    }

    public final S3 s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APISchema)) {
            return false;
        }
        APISchema other = (APISchema)obj;
        return Objects.equals(this.payload(), other.payload()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"APISchema").add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public static APISchema fromPayload(String payload) {
        return (APISchema)APISchema.builder().payload(payload).build();
    }

    public static APISchema fromS3(S3 s3) {
        return (APISchema)APISchema.builder().s3(s3).build();
    }

    public static APISchema fromS3(Consumer<S3.Builder> s3) {
        S3.Builder builder = S3.builder();
        s3.accept(builder);
        return APISchema.fromS3((S3)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payload", PAYLOAD_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<APISchema, T> g) {
        return obj -> g.apply((APISchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PAYLOAD,
        S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String payload;
        private S3 s3;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(APISchema model) {
            this.payload(model.payload);
            this.s3(model.s3);
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            String oldValue = this.payload;
            this.payload = payload;
            this.handleUnionValueChange(Type.PAYLOAD, oldValue, this.payload);
        }

        @Override
        public final Builder payload(String payload) {
            String oldValue = this.payload;
            this.payload = payload;
            this.handleUnionValueChange(Type.PAYLOAD, oldValue, this.payload);
            return this;
        }

        public final S3.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3.BuilderImpl s3) {
            S3 oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3 s3) {
            S3 oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public APISchema build() {
            return new APISchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, APISchema> {
        public Builder payload(String var1);

        public Builder s3(S3 var1);

        default public Builder s3(Consumer<S3.Builder> s3) {
            return this.s3((S3)((S3.Builder)S3.builder().applyMutation(s3)).build());
        }
    }
}

