/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.DataAccessor;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse;

public class ListDataAccessorsIterable
implements SdkIterable<ListDataAccessorsResponse> {
    private final QBusinessClient client;
    private final ListDataAccessorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataAccessorsIterable(QBusinessClient client, ListDataAccessorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataAccessorsResponseFetcher();
    }

    public Iterator<ListDataAccessorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataAccessor> dataAccessors() {
        Function<ListDataAccessorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataAccessors() != null) {
                return response.dataAccessors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataAccessorsResponseFetcher
    implements SyncPageFetcher<ListDataAccessorsResponse> {
        private ListDataAccessorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataAccessorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataAccessorsResponse nextPage(ListDataAccessorsResponse previousPage) {
            if (previousPage == null) {
                return ListDataAccessorsIterable.this.client.listDataAccessors(ListDataAccessorsIterable.this.firstRequest);
            }
            return ListDataAccessorsIterable.this.client.listDataAccessors((ListDataAccessorsRequest)((Object)ListDataAccessorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

