/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DocumentAclGroup;
import software.amazon.awssdk.services.qbusiness.model.DocumentAclGroupsCopier;
import software.amazon.awssdk.services.qbusiness.model.DocumentAclUser;
import software.amazon.awssdk.services.qbusiness.model.DocumentAclUsersCopier;
import software.amazon.awssdk.services.qbusiness.model.MemberRelation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAclCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAclCondition> {
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberRelation").getter(DocumentAclCondition.getter(DocumentAclCondition::memberRelationAsString)).setter(DocumentAclCondition.setter(Builder::memberRelation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()}).build();
    private static final SdkField<List<DocumentAclUser>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("users").getter(DocumentAclCondition.getter(DocumentAclCondition::users)).setter(DocumentAclCondition.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAclUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentAclGroup>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groups").getter(DocumentAclCondition.getter(DocumentAclCondition::groups)).setter(DocumentAclCondition.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAclGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_RELATION_FIELD, USERS_FIELD, GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentAclCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memberRelation;
    private final List<DocumentAclUser> users;
    private final List<DocumentAclGroup> groups;

    private DocumentAclCondition(BuilderImpl builder) {
        this.memberRelation = builder.memberRelation;
        this.users = builder.users;
        this.groups = builder.groups;
    }

    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(this.memberRelation);
    }

    public final String memberRelationAsString() {
        return this.memberRelation;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<DocumentAclUser> users() {
        return this.users;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<DocumentAclGroup> groups() {
        return this.groups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRelationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAclCondition)) {
            return false;
        }
        DocumentAclCondition other = (DocumentAclCondition)obj;
        return Objects.equals(this.memberRelationAsString(), other.memberRelationAsString()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAclCondition").add("MemberRelation", (Object)this.memberRelationAsString()).add("Users", this.hasUsers() ? this.users() : null).add("Groups", this.hasGroups() ? this.groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberRelation": {
                return Optional.ofNullable(clazz.cast(this.memberRelationAsString()));
            }
            case "users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        map.put("users", USERS_FIELD);
        map.put("groups", GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAclCondition, T> g) {
        return obj -> g.apply((DocumentAclCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memberRelation;
        private List<DocumentAclUser> users = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentAclGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAclCondition model) {
            this.memberRelation(model.memberRelation);
            this.users(model.users);
            this.groups(model.groups);
        }

        public final String getMemberRelation() {
            return this.memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public final List<DocumentAclUser.Builder> getUsers() {
            List<DocumentAclUser.Builder> result = DocumentAclUsersCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<DocumentAclUser.BuilderImpl> users) {
            this.users = DocumentAclUsersCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<DocumentAclUser> users) {
            this.users = DocumentAclUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(DocumentAclUser ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<DocumentAclUser.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (DocumentAclUser)((DocumentAclUser.Builder)DocumentAclUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DocumentAclGroup.Builder> getGroups() {
            List<DocumentAclGroup.Builder> result = DocumentAclGroupsCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<DocumentAclGroup.BuilderImpl> groups) {
            this.groups = DocumentAclGroupsCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<DocumentAclGroup> groups) {
            this.groups = DocumentAclGroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(DocumentAclGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<DocumentAclGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (DocumentAclGroup)((DocumentAclGroup.Builder)DocumentAclGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentAclCondition build() {
            return new DocumentAclCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAclCondition> {
        public Builder memberRelation(String var1);

        public Builder memberRelation(MemberRelation var1);

        public Builder users(Collection<DocumentAclUser> var1);

        public Builder users(DocumentAclUser ... var1);

        public Builder users(Consumer<DocumentAclUser.Builder> ... var1);

        public Builder groups(Collection<DocumentAclGroup> var1);

        public Builder groups(DocumentAclGroup ... var1);

        public Builder groups(Consumer<DocumentAclGroup.Builder> ... var1);
    }
}

