/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.AssociatedGroup;
import software.amazon.awssdk.services.qbusiness.model.AssociatedGroupsCopier;
import software.amazon.awssdk.services.qbusiness.model.AssociatedUser;
import software.amazon.awssdk.services.qbusiness.model.AssociatedUsersCopier;
import software.amazon.awssdk.services.qbusiness.model.DocumentAcl;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDocumentAccessResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, CheckDocumentAccessResponse> {
    private static final SdkField<List<AssociatedGroup>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userGroups").getter(CheckDocumentAccessResponse.getter(CheckDocumentAccessResponse::userGroups)).setter(CheckDocumentAccessResponse.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssociatedUser>> USER_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAliases").getter(CheckDocumentAccessResponse.getter(CheckDocumentAccessResponse::userAliases)).setter(CheckDocumentAccessResponse.setter(Builder::userAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HAS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasAccess").getter(CheckDocumentAccessResponse.getter(CheckDocumentAccessResponse::hasAccess)).setter(CheckDocumentAccessResponse.setter(Builder::hasAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasAccess").build()}).build();
    private static final SdkField<DocumentAcl> DOCUMENT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentAcl").getter(CheckDocumentAccessResponse.getter(CheckDocumentAccessResponse::documentAcl)).setter(CheckDocumentAccessResponse.setter(Builder::documentAcl)).constructor(DocumentAcl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAcl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUPS_FIELD, USER_ALIASES_FIELD, HAS_ACCESS_FIELD, DOCUMENT_ACL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckDocumentAccessResponse.memberNameToFieldInitializer();
    private final List<AssociatedGroup> userGroups;
    private final List<AssociatedUser> userAliases;
    private final Boolean hasAccess;
    private final DocumentAcl documentAcl;

    private CheckDocumentAccessResponse(BuilderImpl builder) {
        super(builder);
        this.userGroups = builder.userGroups;
        this.userAliases = builder.userAliases;
        this.hasAccess = builder.hasAccess;
        this.documentAcl = builder.documentAcl;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<AssociatedGroup> userGroups() {
        return this.userGroups;
    }

    public final boolean hasUserAliases() {
        return this.userAliases != null && !(this.userAliases instanceof SdkAutoConstructList);
    }

    public final List<AssociatedUser> userAliases() {
        return this.userAliases;
    }

    public final Boolean hasAccess() {
        return this.hasAccess;
    }

    public final DocumentAcl documentAcl() {
        return this.documentAcl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAliases() ? this.userAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAcl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDocumentAccessResponse)) {
            return false;
        }
        CheckDocumentAccessResponse other = (CheckDocumentAccessResponse)((Object)obj);
        return this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups()) && this.hasUserAliases() == other.hasUserAliases() && Objects.equals(this.userAliases(), other.userAliases()) && Objects.equals(this.hasAccess(), other.hasAccess()) && Objects.equals(this.documentAcl(), other.documentAcl());
    }

    public final String toString() {
        return ToString.builder((String)"CheckDocumentAccessResponse").add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).add("UserAliases", this.hasUserAliases() ? this.userAliases() : null).add("HasAccess", (Object)this.hasAccess()).add("DocumentAcl", (Object)this.documentAcl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "userAliases": {
                return Optional.ofNullable(clazz.cast(this.userAliases()));
            }
            case "hasAccess": {
                return Optional.ofNullable(clazz.cast(this.hasAccess()));
            }
            case "documentAcl": {
                return Optional.ofNullable(clazz.cast(this.documentAcl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userGroups", USER_GROUPS_FIELD);
        map.put("userAliases", USER_ALIASES_FIELD);
        map.put("hasAccess", HAS_ACCESS_FIELD);
        map.put("documentAcl", DOCUMENT_ACL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckDocumentAccessResponse, T> g) {
        return obj -> g.apply((CheckDocumentAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private List<AssociatedGroup> userGroups = DefaultSdkAutoConstructList.getInstance();
        private List<AssociatedUser> userAliases = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasAccess;
        private DocumentAcl documentAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDocumentAccessResponse model) {
            super(model);
            this.userGroups(model.userGroups);
            this.userAliases(model.userAliases);
            this.hasAccess(model.hasAccess);
            this.documentAcl(model.documentAcl);
        }

        public final List<AssociatedGroup.Builder> getUserGroups() {
            List<AssociatedGroup.Builder> result = AssociatedGroupsCopier.copyToBuilder(this.userGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserGroups(Collection<AssociatedGroup.BuilderImpl> userGroups) {
            this.userGroups = AssociatedGroupsCopier.copyFromBuilder(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<AssociatedGroup> userGroups) {
            this.userGroups = AssociatedGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(AssociatedGroup ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(Consumer<AssociatedGroup.Builder> ... userGroups) {
            this.userGroups(Stream.of(userGroups).map(c -> (AssociatedGroup)((AssociatedGroup.Builder)AssociatedGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssociatedUser.Builder> getUserAliases() {
            List<AssociatedUser.Builder> result = AssociatedUsersCopier.copyToBuilder(this.userAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliases(Collection<AssociatedUser.BuilderImpl> userAliases) {
            this.userAliases = AssociatedUsersCopier.copyFromBuilder(userAliases);
        }

        @Override
        public final Builder userAliases(Collection<AssociatedUser> userAliases) {
            this.userAliases = AssociatedUsersCopier.copy(userAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(AssociatedUser ... userAliases) {
            this.userAliases(Arrays.asList(userAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(Consumer<AssociatedUser.Builder> ... userAliases) {
            this.userAliases(Stream.of(userAliases).map(c -> (AssociatedUser)((AssociatedUser.Builder)AssociatedUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getHasAccess() {
            return this.hasAccess;
        }

        public final void setHasAccess(Boolean hasAccess) {
            this.hasAccess = hasAccess;
        }

        @Override
        public final Builder hasAccess(Boolean hasAccess) {
            this.hasAccess = hasAccess;
            return this;
        }

        public final DocumentAcl.Builder getDocumentAcl() {
            return this.documentAcl != null ? this.documentAcl.toBuilder() : null;
        }

        public final void setDocumentAcl(DocumentAcl.BuilderImpl documentAcl) {
            this.documentAcl = documentAcl != null ? documentAcl.build() : null;
        }

        @Override
        public final Builder documentAcl(DocumentAcl documentAcl) {
            this.documentAcl = documentAcl;
            return this;
        }

        @Override
        public CheckDocumentAccessResponse build() {
            return new CheckDocumentAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckDocumentAccessResponse> {
        public Builder userGroups(Collection<AssociatedGroup> var1);

        public Builder userGroups(AssociatedGroup ... var1);

        public Builder userGroups(Consumer<AssociatedGroup.Builder> ... var1);

        public Builder userAliases(Collection<AssociatedUser> var1);

        public Builder userAliases(AssociatedUser ... var1);

        public Builder userAliases(Consumer<AssociatedUser.Builder> ... var1);

        public Builder hasAccess(Boolean var1);

        public Builder documentAcl(DocumentAcl var1);

        default public Builder documentAcl(Consumer<DocumentAcl.Builder> documentAcl) {
            return this.documentAcl((DocumentAcl)((DocumentAcl.Builder)DocumentAcl.builder().applyMutation(documentAcl)).build());
        }
    }
}

