/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeBoostingConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeBoostingOverrideMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NativeIndexConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NativeIndexConfiguration> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(NativeIndexConfiguration.getter(NativeIndexConfiguration::indexId)).setter(NativeIndexConfiguration.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()}).build();
    private static final SdkField<Map<String, DocumentAttributeBoostingConfiguration>> BOOSTING_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("boostingOverride").getter(NativeIndexConfiguration.getter(NativeIndexConfiguration::boostingOverride)).setter(NativeIndexConfiguration.setter(Builder::boostingOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingOverride").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttributeBoostingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, BOOSTING_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NativeIndexConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String indexId;
    private final Map<String, DocumentAttributeBoostingConfiguration> boostingOverride;

    private NativeIndexConfiguration(BuilderImpl builder) {
        this.indexId = builder.indexId;
        this.boostingOverride = builder.boostingOverride;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final boolean hasBoostingOverride() {
        return this.boostingOverride != null && !(this.boostingOverride instanceof SdkAutoConstructMap);
    }

    public final Map<String, DocumentAttributeBoostingConfiguration> boostingOverride() {
        return this.boostingOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBoostingOverride() ? this.boostingOverride() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NativeIndexConfiguration)) {
            return false;
        }
        NativeIndexConfiguration other = (NativeIndexConfiguration)obj;
        return Objects.equals(this.indexId(), other.indexId()) && this.hasBoostingOverride() == other.hasBoostingOverride() && Objects.equals(this.boostingOverride(), other.boostingOverride());
    }

    public final String toString() {
        return ToString.builder((String)"NativeIndexConfiguration").add("IndexId", (Object)this.indexId()).add("BoostingOverride", this.hasBoostingOverride() ? this.boostingOverride() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "boostingOverride": {
                return Optional.ofNullable(clazz.cast(this.boostingOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("indexId", INDEX_ID_FIELD);
        map.put("boostingOverride", BOOSTING_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NativeIndexConfiguration, T> g) {
        return obj -> g.apply((NativeIndexConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexId;
        private Map<String, DocumentAttributeBoostingConfiguration> boostingOverride = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NativeIndexConfiguration model) {
            this.indexId(model.indexId);
            this.boostingOverride(model.boostingOverride);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Map<String, DocumentAttributeBoostingConfiguration.Builder> getBoostingOverride() {
            Map<String, DocumentAttributeBoostingConfiguration.Builder> result = DocumentAttributeBoostingOverrideMapCopier.copyToBuilder(this.boostingOverride);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBoostingOverride(Map<String, DocumentAttributeBoostingConfiguration.BuilderImpl> boostingOverride) {
            this.boostingOverride = DocumentAttributeBoostingOverrideMapCopier.copyFromBuilder(boostingOverride);
        }

        @Override
        public final Builder boostingOverride(Map<String, DocumentAttributeBoostingConfiguration> boostingOverride) {
            this.boostingOverride = DocumentAttributeBoostingOverrideMapCopier.copy(boostingOverride);
            return this;
        }

        public NativeIndexConfiguration build() {
            return new NativeIndexConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NativeIndexConfiguration> {
        public Builder indexId(String var1);

        public Builder boostingOverride(Map<String, DocumentAttributeBoostingConfiguration> var1);
    }
}

