/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.TopicConfiguration;

public class GetChatControlsConfigurationIterable
implements SdkIterable<GetChatControlsConfigurationResponse> {
    private final QBusinessClient client;
    private final GetChatControlsConfigurationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetChatControlsConfigurationIterable(QBusinessClient client, GetChatControlsConfigurationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetChatControlsConfigurationResponseFetcher();
    }

    public Iterator<GetChatControlsConfigurationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TopicConfiguration> topicConfigurations() {
        Function<GetChatControlsConfigurationResponse, Iterator> getIterator = response -> {
            if (response != null && response.topicConfigurations() != null) {
                return response.topicConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetChatControlsConfigurationResponseFetcher
    implements SyncPageFetcher<GetChatControlsConfigurationResponse> {
        private GetChatControlsConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(GetChatControlsConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetChatControlsConfigurationResponse nextPage(GetChatControlsConfigurationResponse previousPage) {
            if (previousPage == null) {
                return GetChatControlsConfigurationIterable.this.client.getChatControlsConfiguration(GetChatControlsConfigurationIterable.this.firstRequest);
            }
            return GetChatControlsConfigurationIterable.this.client.getChatControlsConfiguration((GetChatControlsConfigurationRequest)((Object)GetChatControlsConfigurationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

