/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.PluginBuildStatus;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePluginResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, CreatePluginResponse> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(CreatePluginResponse.getter(CreatePluginResponse::pluginId)).setter(CreatePluginResponse.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> PLUGIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginArn").getter(CreatePluginResponse.getter(CreatePluginResponse::pluginArn)).setter(CreatePluginResponse.setter(Builder::pluginArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginArn").build()}).build();
    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildStatus").getter(CreatePluginResponse.getter(CreatePluginResponse::buildStatusAsString)).setter(CreatePluginResponse.setter(Builder::buildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD, PLUGIN_ARN_FIELD, BUILD_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePluginResponse.memberNameToFieldInitializer();
    private final String pluginId;
    private final String pluginArn;
    private final String buildStatus;

    private CreatePluginResponse(BuilderImpl builder) {
        super(builder);
        this.pluginId = builder.pluginId;
        this.pluginArn = builder.pluginArn;
        this.buildStatus = builder.buildStatus;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final String pluginArn() {
        return this.pluginArn;
    }

    public final PluginBuildStatus buildStatus() {
        return PluginBuildStatus.fromValue(this.buildStatus);
    }

    public final String buildStatusAsString() {
        return this.buildStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePluginResponse)) {
            return false;
        }
        CreatePluginResponse other = (CreatePluginResponse)((Object)obj);
        return Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.pluginArn(), other.pluginArn()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePluginResponse").add("PluginId", (Object)this.pluginId()).add("PluginArn", (Object)this.pluginArn()).add("BuildStatus", (Object)this.buildStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "pluginArn": {
                return Optional.ofNullable(clazz.cast(this.pluginArn()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("pluginArn", PLUGIN_ARN_FIELD);
        map.put("buildStatus", BUILD_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePluginResponse, T> g) {
        return obj -> g.apply((CreatePluginResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String pluginId;
        private String pluginArn;
        private String buildStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePluginResponse model) {
            super(model);
            this.pluginId(model.pluginId);
            this.pluginArn(model.pluginArn);
            this.buildStatus(model.buildStatus);
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getPluginArn() {
            return this.pluginArn;
        }

        public final void setPluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
        }

        @Override
        public final Builder pluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(PluginBuildStatus buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        @Override
        public CreatePluginResponse build() {
            return new CreatePluginResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePluginResponse> {
        public Builder pluginId(String var1);

        public Builder pluginArn(String var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(PluginBuildStatus var1);
    }
}

