/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.SourceAttribution;
import software.amazon.awssdk.services.qbusiness.model.SourceAttributionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetadataEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataEvent>,
ChatOutputStream {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(MetadataEvent.getter(MetadataEvent::conversationId)).setter(MetadataEvent.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userMessageId").getter(MetadataEvent.getter(MetadataEvent::userMessageId)).setter(MetadataEvent.setter(Builder::userMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageId").getter(MetadataEvent.getter(MetadataEvent::systemMessageId)).setter(MetadataEvent.setter(Builder::systemMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()}).build();
    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceAttributions").getter(MetadataEvent.getter(MetadataEvent::sourceAttributions)).setter(MetadataEvent.setter(Builder::sourceAttributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAttribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FINAL_TEXT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finalTextMessage").getter(MetadataEvent.getter(MetadataEvent::finalTextMessage)).setter(MetadataEvent.setter(Builder::finalTextMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalTextMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD, USER_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_ID_FIELD, SOURCE_ATTRIBUTIONS_FIELD, FINAL_TEXT_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String conversationId;
    private final String userMessageId;
    private final String systemMessageId;
    private final List<SourceAttribution> sourceAttributions;
    private final String finalTextMessage;

    protected MetadataEvent(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.userMessageId = builder.userMessageId;
        this.systemMessageId = builder.systemMessageId;
        this.sourceAttributions = builder.sourceAttributions;
        this.finalTextMessage = builder.finalTextMessage;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String userMessageId() {
        return this.userMessageId;
    }

    public final String systemMessageId() {
        return this.systemMessageId;
    }

    public final boolean hasSourceAttributions() {
        return this.sourceAttributions != null && !(this.sourceAttributions instanceof SdkAutoConstructList);
    }

    public final List<SourceAttribution> sourceAttributions() {
        return this.sourceAttributions;
    }

    public final String finalTextMessage() {
        return this.finalTextMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAttributions() ? this.sourceAttributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.finalTextMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataEvent)) {
            return false;
        }
        MetadataEvent other = (MetadataEvent)obj;
        return Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.userMessageId(), other.userMessageId()) && Objects.equals(this.systemMessageId(), other.systemMessageId()) && this.hasSourceAttributions() == other.hasSourceAttributions() && Objects.equals(this.sourceAttributions(), other.sourceAttributions()) && Objects.equals(this.finalTextMessage(), other.finalTextMessage());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataEvent").add("ConversationId", (Object)this.conversationId()).add("UserMessageId", (Object)this.userMessageId()).add("SystemMessageId", (Object)this.systemMessageId()).add("SourceAttributions", this.hasSourceAttributions() ? this.sourceAttributions() : null).add("FinalTextMessage", (Object)this.finalTextMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "userMessageId": {
                return Optional.ofNullable(clazz.cast(this.userMessageId()));
            }
            case "systemMessageId": {
                return Optional.ofNullable(clazz.cast(this.systemMessageId()));
            }
            case "sourceAttributions": {
                return Optional.ofNullable(clazz.cast(this.sourceAttributions()));
            }
            case "finalTextMessage": {
                return Optional.ofNullable(clazz.cast(this.finalTextMessage()));
            }
        }
        return Optional.empty();
    }

    public final MetadataEvent copy(Consumer<? super Builder> modifier) {
        return (MetadataEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("userMessageId", USER_MESSAGE_ID_FIELD);
        map.put("systemMessageId", SYSTEM_MESSAGE_ID_FIELD);
        map.put("sourceAttributions", SOURCE_ATTRIBUTIONS_FIELD);
        map.put("finalTextMessage", FINAL_TEXT_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataEvent, T> g) {
        return obj -> g.apply((MetadataEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String conversationId;
        private String userMessageId;
        private String systemMessageId;
        private List<SourceAttribution> sourceAttributions = DefaultSdkAutoConstructList.getInstance();
        private String finalTextMessage;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MetadataEvent model) {
            this.conversationId(model.conversationId);
            this.userMessageId(model.userMessageId);
            this.systemMessageId(model.systemMessageId);
            this.sourceAttributions(model.sourceAttributions);
            this.finalTextMessage(model.finalTextMessage);
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getUserMessageId() {
            return this.userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final String getSystemMessageId() {
            return this.systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttributions() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttributions(Collection<SourceAttribution.BuilderImpl> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copyFromBuilder(sourceAttributions);
        }

        @Override
        public final Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copy(sourceAttributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(SourceAttribution ... sourceAttributions) {
            this.sourceAttributions(Arrays.asList(sourceAttributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(Consumer<SourceAttribution.Builder> ... sourceAttributions) {
            this.sourceAttributions(Stream.of(sourceAttributions).map(c -> (SourceAttribution)((SourceAttribution.Builder)SourceAttribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFinalTextMessage() {
            return this.finalTextMessage;
        }

        public final void setFinalTextMessage(String finalTextMessage) {
            this.finalTextMessage = finalTextMessage;
        }

        @Override
        public final Builder finalTextMessage(String finalTextMessage) {
            this.finalTextMessage = finalTextMessage;
            return this;
        }

        public MetadataEvent build() {
            return new MetadataEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataEvent> {
        public Builder conversationId(String var1);

        public Builder userMessageId(String var1);

        public Builder systemMessageId(String var1);

        public Builder sourceAttributions(Collection<SourceAttribution> var1);

        public Builder sourceAttributions(SourceAttribution ... var1);

        public Builder sourceAttributions(Consumer<SourceAttribution.Builder> ... var1);

        public Builder finalTextMessage(String var1);
    }
}

